/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit.animator;

import java.awt.Color;
import java.awt.Component;
import org.jdesktop.animation.timing.TimingTarget;

public class ColorAnimator
implements TimingTarget {
    private final Component comp;
    private Color foregroundFrom;
    private Color foregroundTo;
    private Color backgroundFrom;
    private Color backgroundTo;

    public ColorAnimator(Component component, Color fgFrom, Color fgTo, Color bgFrom, Color bgTo) {
        this.comp = component;
        this.foregroundFrom = fgFrom;
        this.foregroundTo = fgTo;
        this.backgroundFrom = bgFrom;
        this.backgroundTo = bgTo;
    }

    public void begin() {
        this.comp.setForeground(this.foregroundFrom);
        this.comp.setBackground(this.backgroundFrom);
    }

    public void end() {
        this.comp.setForeground(this.foregroundTo);
        this.comp.setBackground(this.backgroundTo);
    }

    public void repeat() {
    }

    public void timingEvent(float arg0) {
        Color color;
        if (this.foregroundTo != null) {
            color = this.createIntermediateColour(this.foregroundFrom, this.foregroundTo, arg0);
        }
        if (this.backgroundTo != null) {
            color = this.createIntermediateColour(this.backgroundFrom, this.backgroundTo, arg0);
        }
    }

    private Color createIntermediateColour(Color c1, Color c2, float arg0) {
        return new Color((float)c2.getRed() - arg0 * (float)c1.getRed(), (float)c2.getGreen() - arg0 * (float)c1.getGreen(), (float)c2.getBlue() - arg0 * (float)c1.getBlue(), (float)c2.getAlpha() - arg0 * (float)c1.getAlpha());
    }
}

