/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit.animator;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import waitermate.guikit.animator.LinearPathMapper;
import waitermate.guikit.animator.ParametricBoundsAnimator;
import waitermate.guikit.animator.PathMapper;

public class SimpleSizeBoundsAnimator
extends ParametricBoundsAnimator {
    private PathMapper mapperWidth = LinearPathMapper.getInstance();
    private PathMapper mapperHeight = LinearPathMapper.getInstance();

    public SimpleSizeBoundsAnimator(Component toAnimate, Dimension startingSize, Dimension endingSize) {
        this(toAnimate, new Rectangle(new Point(), startingSize), new Rectangle(new Point(), endingSize));
    }

    public SimpleSizeBoundsAnimator(Component toAnimate, Rectangle startingBounds, Rectangle endingBounds) {
        super(toAnimate, startingBounds, endingBounds);
    }

    public void setPathMapperWidth(PathMapper mapper) {
        this.mapperWidth = mapper;
    }

    public void setPathMapperHeight(PathMapper mapper) {
        this.mapperHeight = mapper;
    }

    @Override
    protected int getHeight(Rectangle starting, Rectangle ending, float fraction) {
        if (starting.height == ending.height) {
            return starting.height;
        }
        return this.mapperHeight.getPathStage(starting.height, ending.height, fraction);
    }

    @Override
    protected int getWidth(Rectangle starting, Rectangle ending, float fraction) {
        if (starting.width == ending.width) {
            return starting.width;
        }
        return this.mapperWidth.getPathStage(starting.width, ending.width, fraction);
    }

    @Override
    protected int getXLoc(Rectangle starting, Rectangle ending, float fraction) {
        return starting.x;
    }

    @Override
    protected int getYLoc(Rectangle starting, Rectangle ending, float fraction) {
        return starting.y;
    }
}

