/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import waitermate.guikit.ScreenResource;

public class DrawerToggleButton
extends JToggleButton
implements ActionListener {
    private JComponent drawer;
    private Icon open;
    private Icon close;

    public DrawerToggleButton(Icon newOpen, Icon newClose) {
        this.open = newOpen;
        this.close = newClose;
        this.setIcon(this.open);
        this.addActionListener(this);
    }

    public void setDrawer(JComponent newDrawer) {
        this.drawer = newDrawer;
        if (this.drawer.getName() == null) {
            this.drawer.setName(this.getName() + " Drawer");
        }
    }

    public JComponent getDrawer() {
        return this.drawer;
    }

    private void checkDrawer() {
        if (this.drawer == null) {
            throw new IllegalStateException("Cannot use DrawerToggleButton until setDrawer is called");
        }
    }

    public void openDrawer() {
        this.setSelected(true);
        this.openDrawerNoSelected();
    }

    private void openDrawerNoSelected() {
        this.checkDrawer();
        ScreenResource.startPopupDrawer(this);
        this.setIcon(this.close);
    }

    public void closeDrawer() {
        this.setSelected(false);
        this.closeDrawerNoSelected();
    }

    private void closeDrawerNoSelected() {
        this.checkDrawer();
        if (ScreenResource.isCurrentDrawer(this)) {
            ScreenResource.stopPopupDrawer();
        }
        this.setIcon(this.open);
    }

    public void closeDrawerSlamShut() {
        this.checkDrawer();
        this.setIcon(this.open);
        this.setSelected(false);
        this.getDrawer().setSize(this.getDrawer().getWidth(), 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isSelected()) {
            this.openDrawer();
        } else {
            this.closeDrawer();
        }
    }
}

