/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit.dialogs;

import au.com.ordermate.util.StringUtils;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.reservation.Reservation;
import ordermate.database.sales.reservation.ReservationsHelper;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.internationalization.Internationalization;
import waitermate.guikit.dialogs.AccountCommentsDialog;
import waitermate.guikit.dialogs.CustomerCommentRenderer;
import waitermate.guikit.dialogs.Dialogs;

public class AccountComments {
    private Account account;

    public AccountComments(Account currentAccount) {
        this.account = currentAccount;
    }

    public void autoDisplayAccountComments(Account theAccount, User user) {
        if (theAccount != null && !theAccount.equals((Object)this.account)) {
            this.account = theAccount;
            if (this.shouldAutoShow()) {
                this.displayAccountComments(user);
            }
        }
    }

    public void displayAccountComments(User user) {
        Customer customer = this.account.getCustomer();
        AccountCommentsDialog ACD = new AccountCommentsDialog(this.account, user);
        boolean okPressed = ACD.start();
        if (customer != null) {
            if (okPressed) {
                customer.setComments(ACD.getCustomerComment());
            }
            customer.setDisplayedComments(true);
            customer.save();
        }
        if (okPressed) {
            this.account.setComment(ACD.getAccountComment());
            Reservation reservation = null;
            if (this.account instanceof TableAccount && (reservation = ReservationsHelper.getFirstReservationForTableAccount((TableAccount)((TableAccount)this.account))) != null) {
                reservation.setComments(ACD.getReservationComments());
                reservation.save();
            }
        }
    }

    private boolean shouldAutoShow() {
        boolean shouldShow;
        Customer customer = this.account.getCustomer();
        Reservation reservation = null;
        if (this.account instanceof TableAccount) {
            reservation = ReservationsHelper.getFirstReservationForTableAccount((TableAccount)((TableAccount)this.account));
        }
        boolean bl = shouldShow = customer != null && !customer.isDisplayedComments() && !StringUtils.isEmpty((String)customer.getComments());
        if (!shouldShow && this.account.getItems().size() == 0) {
            shouldShow = reservation != null && !StringUtils.isEmpty((String)reservation.getCommentsSafe());
        }
        return shouldShow;
    }

    public static void displayMultiCustomerComment(Collection<Customer> customers, User user) {
        ArrayList<Customer> customersList = new ArrayList<Customer>();
        for (Customer customer : customers) {
            if (StringUtils.isEmpty((String)customer.getComments())) continue;
            customersList.add(customer);
        }
        if (!customersList.isEmpty()) {
            CustomerCommentRenderer renderer = new CustomerCommentRenderer(user != null && user.hasPermission(AllPermissions.CUSTOMER_COMMENT));
            RendererScrollPaneModel model = new RendererScrollPaneModel((Renderer)renderer, 1, 5);
            CustomScrollPane scrolly = new CustomScrollPane((CustomScrollPaneModel)model);
            model.setObjects(customersList);
            scrolly.setPreferredSize(new Dimension(600, 400));
            Dialogs.displayDialog((JComponent)scrolly, Internationalization.getLiteralFor((String)"CUSTOMER_COMMENTS"), false);
        }
    }
}

