/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.reservation.Reservation;
import ordermate.database.sales.reservation.ReservationsHelper;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.integration.ReservationIntegrationUtils;
import ordermate.internationalization.Internationalization;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.PopupWindow;

final class AccountCommentsDialog
extends PopupWindow {
    private EditableCommentPanel customerPanel;
    private EditableCommentPanel accountPanel;
    private EditableCommentPanel reservationPanel;
    private static final int WIDTH = 640;
    private static final int HEIGHT = 150;
    Customer customer = null;
    Reservation reservation = null;

    AccountCommentsDialog(Account account, User user) {
        JPanel holder = new JPanel();
        holder.setLayout(new BoxLayout(holder, 1));
        NavBar bar = this.getNavBar();
        this.setCancelButtonVisible(false);
        bar.setText("Account Comments");
        bar.getBackButton().setVisible(true);
        bar.getBackButton().setText(Internationalization.getLiteralFor((String)"BACK"));
        bar.getOkButton().setText(Internationalization.getLiteralFor((String)"SAVE"));
        this.accountPanel = new EditableCommentPanel("Account");
        holder.add(this.accountPanel);
        this.accountPanel.setEnabled(user != null && user.hasPermission(AllPermissions.ACCOUNT_ADMIN));
        this.accountPanel.setTitle(account.toString());
        this.accountPanel.setComment(account.getComment());
        int count = 1;
        this.customer = account.getCustomer();
        if (this.customer != null) {
            this.customerPanel = new EditableCommentPanel("Customer");
            this.customerPanel.setEnabled(user != null && user.hasPermission(AllPermissions.CUSTOMER_COMMENT));
            this.customerPanel.setVisible(false);
            ++count;
            this.customerPanel.setVisible(true);
            this.customerPanel.setTitle(this.customer.getNameAndTitle());
            this.customerPanel.setComment(this.customer.getComments());
            holder.add(this.customerPanel);
        }
        if (account instanceof TableAccount) {
            this.reservation = ReservationsHelper.getFirstReservationForTableAccount((TableAccount)((TableAccount)account));
            if (this.reservation != null) {
                this.reservationPanel = new EditableCommentPanel("Reservation");
                if (ReservationIntegrationUtils.isCloudReservationsConfigured()) {
                    this.reservationPanel.setEnabled(false);
                } else {
                    this.reservationPanel.setEnabled(user != null && user.hasPermission(AllPermissions.EDIT_RESERVATIONS));
                }
                this.reservationPanel.setVisible(false);
                ++count;
                holder.add(this.reservationPanel);
                this.reservationPanel.setTitle(this.reservation.toString());
                this.reservationPanel.setComment(this.reservation.getComments());
                this.reservationPanel.setVisible(true);
            }
        }
        Dimension preferredSize = new Dimension(640, count * 150);
        holder.setPreferredSize(preferredSize);
        this.setComponent(holder);
    }

    public String getCustomerComment() {
        return this.customerPanel.getComment();
    }

    public String getAccountComment() {
        return this.accountPanel.getComment();
    }

    public String getReservationComments() {
        return this.reservationPanel.getComment();
    }

    class EditableCommentPanel
    extends JPanel
    implements ActionListener {
        private JPanel buttonPanel;
        private JLabel commentLabel;
        private JLabel titleLabel;
        private JButton editCommentButton;
        private String mirrorText;
        final int PAD = 20;

        EditableCommentPanel(String name) {
            super(new BorderLayout(20, 5));
            this.PAD = 20;
            this.setBorder(new TitledBorder(name));
            this.titleLabel = new JLabel();
            this.titleLabel.setOpaque(true);
            this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
            this.titleLabel.setHorizontalAlignment(2);
            this.add((Component)this.titleLabel, "North");
            this.commentLabel = new JLabel();
            this.commentLabel.getInsets().set(5, 10, 5, 20);
            this.commentLabel.setOpaque(true);
            this.commentLabel.setBackground(Color.RED);
            this.commentLabel.setBackground(null);
            this.commentLabel.setFont(OrderMateTheme.getMediumFont());
            this.commentLabel.setMinimumSize(new Dimension(350, 40));
            this.commentLabel.setVerticalAlignment(1);
            this.commentLabel.setHorizontalAlignment(2);
            this.commentLabel.setName(name + "_comment_label");
            this.add((Component)this.commentLabel, "Center");
            this.editCommentButton = new JButton("Edit");
            this.editCommentButton.addActionListener(this);
            this.editCommentButton.setName(name + "_edit_comment");
            OrderMateTheme.setupTouchScreenButton((AbstractButton)this.editCommentButton);
            this.editCommentButton.setBorder(new EmptyBorder(20, 20, 20, 20));
            this.buttonPanel = new JPanel(new FlowLayout(2));
            this.buttonPanel.add(this.editCommentButton);
            this.add((Component)this.buttonPanel, "East");
        }

        public void setTitle(String title) {
            this.titleLabel.setText(title);
        }

        public void setComment(String comments) {
            this.mirrorText = comments;
            this.updateText();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.editCommentButton) {
                String text = Dialogs.getString(Internationalization.getLiteralFor((String)"COMMENT") + ":", this.mirrorText, true, Internationalization.getLiteralFor((String)"CUSTOMER_COMMENT"));
                if (text.length() != 1 || text.charAt(0) != '\u0000') {
                    this.mirrorText = text;
                }
                this.updateText();
            }
        }

        @Override
        public void setEnabled(boolean value) {
            super.setEnabled(value);
            this.editCommentButton.setEnabled(value);
        }

        public String getComment() {
            if (this.mirrorText != null) {
                this.mirrorText = this.mirrorText.trim();
                if (this.mirrorText.isEmpty()) {
                    this.mirrorText = null;
                }
            }
            return this.mirrorText;
        }

        public void gotClearComment() {
            this.mirrorText = "";
            this.updateText();
        }

        private void updateText() {
            if (this.mirrorText == null || this.mirrorText.isEmpty()) {
                this.commentLabel.setText(Internationalization.getLiteralFor((String)"NO_COMMENT_SET_IN_EXCLAMATION"));
                this.commentLabel.setEnabled(false);
            } else {
                this.mirrorText = this.mirrorText.trim();
                this.commentLabel.setText("<html>" + this.mirrorText + "</html>");
                this.commentLabel.setEnabled(true);
            }
            this.validate();
            this.repaint();
        }
    }
}

