/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit.dialogs;

import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.net.URL;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.text.html.HTMLEditorKit;
import ordermate.OrderMate;
import ordermate.database.misc.SystemProperty;
import ordermate.gui.DecoratorLocation;
import ordermate.gui.keypad.Keypad;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import org.jdesktop.swingx.JXLabel;
import waitermate.guikit.NavBar;
import waitermate.guikit.ScreenResource;
import waitermate.guikit.dialogs.KeyboardDialog;
import waitermate.guikit.dialogs.KeypadDialog;
import waitermate.guikit.dialogs.ObjectPopupWindow;
import waitermate.guikit.dialogs.PopupWindow;

public final class Dialogs {
    public static final int CANCELLED_INT = Integer.MIN_VALUE;
    public static final double CANCELLED_DOUBLE = Double.MIN_VALUE;
    public static final String CANCELLED_STRING = "\u0000";
    public static final int MAX_LOGIN_DIALOG_WIDTH = 400;
    public static final int MAX_LOGIN_DIALOG_HEIGHT = 550;
    private static KeypadDialog pinKeyPadDlg;
    private static KeypadDialog intDialog;
    private static KeypadDialog priceInput;
    private static KeypadDialog percentInput;
    private static PopupWindow quickLogoutPanel;
    private static KeypadDialog quickLogoutKeypad;

    private Dialogs() {
    }

    public static boolean displayDialog(JComponent toDisplay, String title, boolean displayCancel) {
        return Dialogs.displayDialog(toDisplay, title, null, null, displayCancel, false, true);
    }

    public static boolean displayDialog(JComponent toDisplay, String title, boolean displayCancel, boolean noBorder, boolean displayOk) {
        return Dialogs.displayDialog(toDisplay, title, null, null, displayCancel, noBorder, displayOk);
    }

    public static boolean displayDialog(JComponent toDisplay, String title, String posText, String negText, boolean displayCancel, boolean noBorder, boolean displayOk) {
        return Dialogs.displayDialog(toDisplay, title, posText, negText, displayCancel, noBorder, displayOk, null, null);
    }

    private static boolean displayDialog(JComponent toDisplay, String title, String posText, String negText, boolean displayCancel, boolean noBorder, boolean displayOk, Dimension size, Point location) {
        PopupWindow popupWindow = Dialogs.createDialog(toDisplay, title, posText, negText, displayCancel, noBorder, displayOk);
        return Dialogs.displayDialog(popupWindow, size, location);
    }

    public static boolean displayDialog(PopupWindow toDisplay, Dimension size, Point location) {
        if (toDisplay != null) {
            toDisplay.setDisplayLocation(location);
            toDisplay.setPreferredSize(size);
            boolean success = toDisplay.start();
            return success;
        }
        return false;
    }

    public static PopupWindow createDialog(JComponent toDisplay, String title, String posText, String negText, boolean displayCancel, boolean noBorder, boolean displayOk) {
        PopupWindow localPopupWindow = noBorder ? new PopupWindow(false) : new PopupWindow();
        localPopupWindow = Dialogs.setupPopupWindowForDialog(localPopupWindow, toDisplay, title, posText, negText, displayCancel, displayOk);
        return localPopupWindow;
    }

    public static PopupWindow setupPopupWindowForDialog(PopupWindow localPopupWindow, JComponent toDisplay, String title, String posText, String negText, boolean displayCancel, boolean displayOk) {
        localPopupWindow.setText(title);
        localPopupWindow.setComponent(toDisplay);
        localPopupWindow.setCancelButtonVisible(displayCancel);
        localPopupWindow.setOkButtonVisible(displayOk);
        if (posText != null) {
            localPopupWindow.setOKButtonText(posText);
        }
        if (negText != null) {
            localPopupWindow.setCancelButtonText(negText);
        } else {
            localPopupWindow.setCancelButtonText(Internationalization.getLiteralFor((String)"CANCEL"));
        }
        return localPopupWindow;
    }

    public static PopupWindow createDialog(JComponent toDisplay, String title, String trueText, String trueIcon, String falseText, String falseIcon, boolean displayFalse, boolean displayTrue, boolean noBorder) {
        NavBar navBar = new NavBar();
        if (displayFalse) {
            JButton falseButton = navBar.constructButton((Icon)IconLoader.get((String)falseIcon), falseText, Internationalization.getLiteralFor((String)"FALSE"), navBar.cancel);
            navBar.addLeft(falseButton);
        }
        if (displayTrue) {
            JButton trueButton = navBar.constructButton((Icon)IconLoader.get((String)trueIcon), trueText, Internationalization.getLiteralFor((String)"TRUE"), navBar.ok);
            navBar.addRight(trueButton);
        }
        PopupWindow localPopupWindow = new PopupWindow(navBar, noBorder);
        localPopupWindow.setText(title);
        localPopupWindow.setComponent(toDisplay);
        return localPopupWindow;
    }

    public static synchronized void displayOkDialog(String message, String title) {
        OrderMate.LOG.info("Dialog msg: " + message);
        JLabel messageLabel = Dialogs.createMessageLabel(message);
        Dialogs.displayDialog(messageLabel, title, false);
    }

    public static void displayOkDialog(JComponent messageComponent, String title) {
        Dialogs.displayDialog(messageComponent, title, false);
    }

    public static synchronized boolean displayChoiceDialog(String message, String title, boolean forceConfirmation) {
        return Dialogs.displayChoiceDialog(message, title, null, null, forceConfirmation);
    }

    public static synchronized boolean displayChoiceDialog(String message, String title, String posText, String negText, boolean forceConfirmation) {
        if (forceConfirmation || SystemProperty.getInstance().isConfirmationsEnabled()) {
            return Dialogs.displayForcedChoiceDialog(message, title, posText, negText);
        }
        return true;
    }

    public static synchronized boolean displayChoiceDialogWithTimer(String message, String title, String posText, String negText, int timer, final boolean okAfterTimer) {
        JLabel messageLabel = Dialogs.createMessageLabel(message);
        final PopupWindow theWindow = Dialogs.createDialog(messageLabel, title, posText, negText, negText != null, false, true);
        Timer countDownTimer = new Timer(timer, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (okAfterTimer) {
                    theWindow.gotOk();
                } else {
                    theWindow.gotCancel();
                }
            }
        });
        countDownTimer.start();
        return Dialogs.displayDialog(theWindow, null, null);
    }

    public static synchronized boolean displayForcedChoiceDialog(String message, String title, String posText, String negText) {
        JLabel messageLabel = Dialogs.createMessageLabel(message);
        return Dialogs.displayDialog(messageLabel, title, posText, negText, true, false, true);
    }

    public static synchronized boolean displayBlockingDialog(String message, String title) {
        JLabel messageLabel = Dialogs.createMessageLabel(message);
        return Dialogs.displayDialog(messageLabel, title, false, false, false);
    }

    public static synchronized boolean displayOptionsDialog(String title, String message, List<BasicAction> options, boolean showCancel) {
        String cancelText = null;
        if (showCancel) {
            cancelText = Internationalization.getLiteralFor((String)"CANCEL");
        }
        return Dialogs.displayOptionsDialog(title, message, options, cancelText, IconLoader.get((String)"/waitermate/guikit/images/cancel.png"));
    }

    public static boolean displayOptionsDialog(String title, String message, List<BasicAction> options, String cancelText, Icon cancelIcon) {
        JLabel messageLabel = Dialogs.createMessageLabel(message);
        NavBar nav = new NavBar();
        if (cancelText != null) {
            JButton cancelButton = nav.getCancelButton();
            cancelButton.setText(cancelText);
            cancelButton.setIcon(cancelIcon);
            nav.addLeft(cancelButton);
        }
        final PopupWindow window = new PopupWindow(nav);
        window.setText(title);
        window.setComponent(messageLabel);
        for (BasicAction action : options) {
            JButton button;
            if (action == null) {
                OrderMate.LOG.warn("Action should not be null, continuing.", (Throwable)new IllegalArgumentException());
                continue;
            }
            JButton toAdd = button = nav.constructButton(action);
            if (action.getPermission() != null) {
                toAdd = new StandardSecurityDecorator((JComponent)button, action.getPermission());
            }
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    window.gotOk();
                }
            });
            nav.addRight(toAdd);
        }
        return Dialogs.displayDialog(window, null, null);
    }

    public static <T> T displaySelectionDialog(String message, List<T> selections) {
        ObjectPopupWindow.ObjectPopupWindowBuilder<T> popupBuilder = new ObjectPopupWindow.ObjectPopupWindowBuilder(message, 1, 5, null).setAllowCancel(true);
        for (T option : selections) {
            popupBuilder.addSelectionButton(option);
        }
        ObjectPopupWindow popup = popupBuilder.build();
        popup.getPopupWindow().setDecorationLocation(DecoratorLocation.East);
        return (T)popup.start();
    }

    public static Object displaySelectionDialogNoCancel(String title, String message, List<?> selections) {
        ObjectPopupWindow popup = new ObjectPopupWindow(message, selections, 1, 5, false);
        return popup.start();
    }

    public static JLabel createMessageLabel(String msg) {
        JXLabel label = new JXLabel(msg);
        label.setFont(OrderMateTheme.getMediumFont());
        if (msg.length() > 5 && msg.substring(0, 5).equalsIgnoreCase("<HTML")) {
            label.setMaximumSize(new Dimension(550, 500));
            label.setMaxLineSpan(750);
            label.setLineWrap(true);
        } else {
            label.setMaxLineSpan(750);
            label.setLineWrap(true);
            label.setMinimumSize(new Dimension(550, 60));
            label.setPreferredSize(new Dimension(550, 60));
            label.setMaximumSize(new Dimension(550, 500));
        }
        return label;
    }

    public static String getPhoneNumber() {
        return Dialogs.getPhoneNumber("");
    }

    public static String getPhoneNumber(String initialValue) {
        KeypadDialog keypadDialog = new KeypadDialog();
        keypadDialog.setup(false);
        keypadDialog.setMaxChars(10);
        keypadDialog.setUnits("Phone:");
        keypadDialog.setValue(initialValue);
        boolean result = Dialogs.displayDialog(keypadDialog, "", true);
        String value = result ? keypadDialog.getValue() : CANCELLED_STRING;
        return value;
    }

    public static String getPIN(boolean maskPin) {
        return Dialogs.getPIN(maskPin, null, null, null, null, null);
    }

    public static String getPIN(boolean maskPin, String dialogText, Point location, Dimension bounds, String posText, String negText) {
        pinKeyPadDlg = new KeypadDialog();
        pinKeyPadDlg.setup(false);
        pinKeyPadDlg.setUnits("PIN Number");
        pinKeyPadDlg.pinInput(maskPin);
        boolean result = Dialogs.displayDialog(pinKeyPadDlg, dialogText, posText, negText, true, false, true, bounds, location);
        String value = result ? pinKeyPadDlg.getValueAsString() : CANCELLED_STRING;
        return value;
    }

    public static boolean stopQuickLogoutPinDialog() {
        boolean isVisible;
        if (quickLogoutKeypad == null) {
            return false;
        }
        boolean bl = isVisible = quickLogoutKeypad.getTopLevelAncestor() != null && quickLogoutKeypad.getTopLevelAncestor().isVisible();
        if (isVisible) {
            Container parent;
            for (parent = quickLogoutKeypad.getParent(); parent != null && !(parent instanceof PopupWindow); parent = parent.getParent()) {
            }
            if (parent != null) {
                ((PopupWindow)parent).gotCancel();
            }
        }
        return isVisible;
    }

    public static int getSingleDigitInteger(String unit) {
        return Dialogs.getSingleDigitInteger(unit, Integer.MIN_VALUE);
    }

    public static int getSingleDigitInteger(String unit, int defaultValue) {
        int value;
        boolean result;
        KeypadDialog keypadDialog = new KeypadDialog();
        keypadDialog.setup(false);
        keypadDialog.setOverwriteValue(true);
        keypadDialog.setUnits(unit);
        if (defaultValue != Integer.MIN_VALUE) {
            keypadDialog.setValue(Integer.toString(defaultValue));
        }
        if (result = Dialogs.displayDialog(keypadDialog, "", true)) {
            value = keypadDialog.getValueAsInt();
            if (value == -1) {
                value = Integer.MIN_VALUE;
            }
        } else {
            value = Integer.MIN_VALUE;
        }
        return value;
    }

    public static int getInteger(String unit) {
        return Dialogs.getInteger(unit, Integer.MIN_VALUE);
    }

    public static int getInteger(String unit, int defaultValue) {
        return Dialogs.getInteger(unit, defaultValue, true);
    }

    public static int getInteger(String unit, int defaultValue, boolean showCancel) {
        return Dialogs.getInteger(unit, defaultValue, showCancel, "");
    }

    public static int getInteger(String unit, int defaultValue, boolean showCancel, String title) {
        int value;
        boolean result;
        intDialog = new KeypadDialog();
        intDialog.setup(false);
        intDialog.setUnits(unit);
        intDialog.intInput();
        intDialog.setOverwriteValue(true);
        if (defaultValue != Integer.MIN_VALUE) {
            intDialog.setValue(Integer.toString(defaultValue));
        }
        if (result = Dialogs.displayDialog(intDialog, title, showCancel)) {
            value = intDialog.getValueAsInt();
            if (value == -1) {
                value = Integer.MIN_VALUE;
            }
        } else {
            value = Integer.MIN_VALUE;
        }
        return value;
    }

    public static int getLongInteger(String unit, int defaultValue, int maxNumbFigures, boolean showCancel, String title) {
        int value;
        boolean result;
        KeypadDialog keypadDialog = new KeypadDialog();
        keypadDialog.setup(false);
        keypadDialog.setUnits(unit);
        keypadDialog.longIntInput(maxNumbFigures);
        keypadDialog.setOverwriteValue(true);
        if (defaultValue != Integer.MIN_VALUE) {
            keypadDialog.setValue(Integer.toString(defaultValue));
        }
        if (result = Dialogs.displayDialog(keypadDialog, title, showCancel)) {
            value = keypadDialog.getValueAsInt();
            if (value == -1) {
                value = Integer.MIN_VALUE;
            }
        } else {
            value = Integer.MIN_VALUE;
        }
        return value;
    }

    public static BigDecimal getBigDecimal(String unit) {
        return Dialogs.getBigDecimal(unit, null);
    }

    public static BigDecimal getBigDecimal(String unit, BigDecimal defaultVal) {
        return Dialogs.getBigDecimal(unit, defaultVal, 5, true, "");
    }

    public static BigDecimal getBigDecimal(String unit, BigDecimal defaultValue, int maxNumbFigures, boolean showCancel, String title) {
        boolean result;
        KeypadDialog keypadDialog = new KeypadDialog();
        keypadDialog.setup(true);
        keypadDialog.setUnits(unit);
        keypadDialog.doubleInput(maxNumbFigures);
        keypadDialog.setOverwriteValue(true);
        if (defaultValue != null) {
            keypadDialog.setValue(defaultValue.toPlainString());
        }
        BigDecimal value = (result = Dialogs.displayDialog(keypadDialog, title, showCancel)) ? keypadDialog.getValueAsBigDecimal() : null;
        return value;
    }

    public static double getDouble(String unit) {
        return Dialogs.getDouble(unit, Double.MIN_VALUE);
    }

    public static double getDouble(String unit, boolean showMinusSign) {
        return Dialogs.getDouble(unit, Double.MIN_VALUE, showMinusSign);
    }

    public static double getDouble(String unit, double defaultValue) {
        return Dialogs.getDouble(unit, defaultValue, false);
    }

    public static double getDouble(String unit, double defaultValue, boolean showMinusSign) {
        double value;
        boolean result;
        KeypadDialog keypadDialog = new KeypadDialog();
        if (showMinusSign) {
            keypadDialog = new KeypadDialog(new Keypad.KeypadBuilder().setShowMinusSignButton(true).build(), 0);
        }
        keypadDialog.doubleInput();
        keypadDialog.setup(true);
        keypadDialog.setUnits(unit);
        if (defaultValue != Double.MIN_VALUE) {
            keypadDialog.setValue(Double.toString(defaultValue));
        }
        if (result = Dialogs.displayDialog(keypadDialog, "", true)) {
            value = keypadDialog.getValueAsDouble();
            if (value == -1.0) {
                value = Double.MIN_VALUE;
            }
        } else {
            value = Double.MIN_VALUE;
        }
        keypadDialog.setValue("");
        return value;
    }

    public static String getString(String label) {
        return Dialogs.getString(label, "");
    }

    public static String getString(String label, String currentString, boolean displayCancel) {
        return Dialogs.getString(label, currentString, displayCancel, "");
    }

    public static String getString(String label, String currentString) {
        return Dialogs.getString(label, currentString, true);
    }

    public static String getString(String label, String currentString, boolean displayCancel, String title) {
        return Dialogs.getString(label, currentString, displayCancel, title, "", null, null);
    }

    public static String getString(String label, String currentString, boolean displayCancel, String title, String hint) {
        return Dialogs.getString(label, currentString, displayCancel, title, hint, null, null);
    }

    public static String getString(String label, String currentString, boolean displayCancel, String title, String hint, Dimension size, Point location) {
        String value = "";
        KeyboardDialog keyboardDialog = new KeyboardDialog();
        keyboardDialog.setLabel(label);
        keyboardDialog.setHint(hint);
        if (currentString != null) {
            keyboardDialog.setValue(currentString);
        } else {
            keyboardDialog.setValue("");
        }
        boolean result = Dialogs.displayDialog(keyboardDialog, title, null, null, displayCancel, true, true, size, location);
        value = result ? keyboardDialog.getValue() : CANCELLED_STRING;
        return value;
    }

    public static double getPriceDouble(String unit) {
        return Dialogs.getPriceDouble(unit, Double.MIN_VALUE);
    }

    public static double getDoubleValueWithinRange(String message, double defaultAmount, double lowerLimit, double upperLimit) {
        double valueFromDialog = defaultAmount;
        while (((valueFromDialog = Dialogs.getPriceDouble(message, defaultAmount)) < lowerLimit || valueFromDialog > upperLimit) && lowerLimit != upperLimit) {
        }
        return valueFromDialog;
    }

    public static double getPercentageValueWithinRange(String message, double defaultPercent, double lowerLimit, double upperLimit) {
        double valueFromDialog = defaultPercent;
        while ((valueFromDialog = Dialogs.getPercentage(message, valueFromDialog)) < lowerLimit || valueFromDialog > upperLimit) {
        }
        return valueFromDialog;
    }

    public static double getPercentage(String unit, double defaultValue) {
        double value = 0.0;
        percentInput = new KeypadDialog();
        percentInput.doubleInput();
        percentInput.setUnits(unit);
        if (defaultValue != Double.MIN_VALUE) {
            percentInput.setValue(Double.toString(defaultValue));
        }
        percentInput.setValue(String.valueOf(defaultValue));
        percentInput.setOverwriteValue(true);
        boolean result = Dialogs.displayDialog(percentInput, "", true);
        if (result) {
            value = percentInput.getValueAsDouble();
            if (value == -1.0) {
                value = Double.MIN_VALUE;
            }
        } else {
            value = Double.MIN_VALUE;
        }
        percentInput.setValue("");
        return value;
    }

    public static double getPriceDouble(String message, double defaultValue) {
        double value = 0.0;
        priceInput = new KeypadDialog();
        priceInput.priceInput();
        priceInput.setUnits(message);
        if (defaultValue != Double.MIN_VALUE) {
            priceInput.setValue(Double.toString(defaultValue));
        }
        Price paddedPrice = new Price(defaultValue, 0.01);
        priceInput.setValue(paddedPrice.toString());
        priceInput.setOverwriteValue(true);
        boolean result = Dialogs.displayDialog(priceInput, "", true);
        if (result) {
            value = priceInput.getValueAsDouble();
            if (value == -1.0) {
                value = Double.MIN_VALUE;
            }
        } else {
            value = Double.MIN_VALUE;
        }
        priceInput.setValue("");
        return value;
    }

    public static String showKeypadQuickLogout(Dimension size, Point location) {
        return Dialogs.showKeypadQuickLogout(size, location, null);
    }

    public static String showKeypadQuickLogout(Dimension size, Point location, String cancelText) {
        if (quickLogoutPanel == null) {
            quickLogoutPanel = new PopupWindow();
            quickLogoutPanel.setText("<html>" + Internationalization.getLiteralFor((String)"ENTER_PIN_SWIPE_CARD_OR") + "<br> " + Internationalization.getLiteralFor((String)"USE_PROXIMITY_BAND_TO_LOGIN") + "</html>");
            quickLogoutKeypad = new KeypadDialog();
            quickLogoutKeypad.setup(false);
            quickLogoutKeypad.setUnits("PIN Number");
            quickLogoutPanel.setComponent(quickLogoutKeypad);
            quickLogoutPanel.setCancelButtonText(Internationalization.getLiteralFor((String)(cancelText == null ? "LOGOUT" : cancelText)));
            quickLogoutKeypad.pinInput(true);
        }
        String value = CANCELLED_STRING;
        Dialogs.quickLogoutKeypad.keypad.resetModel();
        quickLogoutPanel.setDisplayLocation(location);
        quickLogoutPanel.setPreferredSize(size);
        ScreenResource.startModalWindow(quickLogoutPanel, location);
        boolean result = quickLogoutPanel.getResult();
        value = result ? quickLogoutKeypad.getValueAsString() : CANCELLED_STRING;
        return value;
    }

    public static void displayHtmlDocDialog(String title, String webaddress, String errorMessage) {
        PopupWindow popupWin = new PopupWindow(false);
        NavBar nav = popupWin.getNavBar();
        nav.removeLeft(nav.getCancelButton());
        nav.setText(title);
        try {
            URL url = new URL(webaddress);
            JEditorPane editorPane = new JEditorPane();
            editorPane.setName("htmlDocArea");
            editorPane.setEditorKit(new HTMLEditorKit());
            editorPane.setEditable(false);
            editorPane.setPage(url);
            JScrollPane editorScrollPane = new JScrollPane(editorPane);
            OrderMateTheme.setupScrollPane((JScrollPane)editorScrollPane);
            popupWin.setComponent(editorScrollPane);
            popupWin.startFillTheFrame();
        }
        catch (Exception ex) {
            popupWin.setComponent(new JLabel(errorMessage));
            popupWin.start();
        }
    }
}

