/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit.dialogs;

import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JPanel;
import waitermate.guikit.dialogs.KeypadDialog;

public class DoubleKeypadDialog
extends JPanel {
    private static final Dimension GAP_SIZE = new Dimension(50, 0);
    private final JPanel spacer;
    private final KeypadDialog leftKeypad;
    private final KeypadDialog rightKeypad;

    public DoubleKeypadDialog(String leftTitle, String rightTitle) {
        this(leftTitle, rightTitle, -1, -1);
    }

    public DoubleKeypadDialog(String leftTitle, String rightTitle, int leftDefault, int rightDefault) {
        this.leftKeypad = this.buildKeypad(leftTitle, leftDefault);
        this.rightKeypad = this.buildKeypad(rightTitle, rightDefault);
        this.spacer = new JPanel();
        this.spacer.setPreferredSize(GAP_SIZE);
        this.setLayout(new FlowLayout(1));
        this.add(this.leftKeypad);
        this.add(this.spacer);
        this.add(this.rightKeypad);
    }

    private KeypadDialog buildKeypad(String title, int defaultValue) {
        KeypadDialog kd = new KeypadDialog();
        kd.setup(false);
        kd.setUnits(title);
        kd.intInput();
        kd.setOverwriteValue(true);
        if (defaultValue > 0) {
            kd.setValue(String.valueOf(defaultValue));
        }
        return kd;
    }

    public void resetFirstPressFlag() {
        this.leftKeypad.setFirstPressQuantityFlag(true);
        this.rightKeypad.setFirstPressQuantityFlag(true);
    }

    public int getLeftKeypadValue() {
        return this.leftKeypad.getValueAsInt();
    }

    public int getRightKeypadValue() {
        return this.rightKeypad.getValueAsInt();
    }
}

