/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit.dialogs;

import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.JButton;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.guikit.dialogs.CalendarDialog;
import waitermate.guikit.dialogs.Dialogs;

public class MonthlyCalendarDialog
extends CalendarDialog {
    private Signal nullDate = Signals.createSignal();

    public MonthlyCalendarDialog(Date startDate, String nullDateButtonText, Icon nullButtonIcon) {
        super(startDate);
        super.setSelectedDate(startDate);
        if (nullDateButtonText != null && !nullDateButtonText.isEmpty()) {
            this.nullDate.connect((Object)this, "gotNullDate");
            JButton noExpiryDateButton = this.parentWindow.getNavBar().constructButton(new BasicAction(nullDateButtonText, nullButtonIcon, nullDateButtonText){

                public void actionPerformed(ActionEvent e) {
                    MonthlyCalendarDialog.this.nullDate.emit();
                }
            });
            this.parentWindow.getNavBar().addRight(noExpiryDateButton);
        }
    }

    @Override
    protected void gotDate() {
        Date selected = this.monthView.getSelectionDate();
        if (DateTimeUtils.dateIsAfterToday((Date)selected)) {
            super.gotDate();
        } else {
            Dialogs.displayOkDialog("Selection Date cannot be before today.", "Date Selection");
            this.setSelectedDate(new Date());
        }
    }

    private boolean selectableDate(Date selectDate) {
        if (selectDate != null) {
            return DateTimeUtils.dateIsAfterToday((Date)selectDate);
        }
        return false;
    }

    @Override
    protected void setSelectedDate(Date selectedDate) {
        if (this.selectableDate(selectedDate)) {
            super.setSelectedDate(selectedDate);
        } else {
            super.setSelectedDate(new Date());
        }
    }

    public boolean go() {
        return Dialogs.displayDialog(this.parentWindow, null, null);
    }

    @Override
    @Deprecated
    public Date start() {
        return super.start();
    }

    public void gotNullDate() {
        this.selectedDate = null;
        this.parentWindow.getNavBar().ok.emit();
    }
}

