/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit.dialogs;

import au.com.ordermate.guicore.NameDecorator;
import au.com.ordermate.persistence.Displayable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import ordermate.gui.button.CustomToggleButton;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.DataScrollPaneModel;
import ordermate.gui.scroll.DefaultScrollPaneModel;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.guikit.dialogs.PopupWindow;

public class MultiSelectPopupWindow
implements ActionListener {
    private List<Displayable> selectedObjects;
    private List<? extends Displayable> allObjects;
    private PopupWindow popupWindow;
    private CustomScrollPane mainArea;
    private DefaultScrollPaneModel objectModel;
    public final Signal<Displayable, ?, ?, ?, ?> objectSelected = Signals.createSignal(Displayable.class, (String)"object");

    public MultiSelectPopupWindow(String text, List<? extends Displayable> objects, int columns, int rows) {
        this(text, objects, columns, rows, true, true);
    }

    public MultiSelectPopupWindow(String text, List<? extends Displayable> objects, int columns, int rows, boolean hasClearButton, boolean allowCancel) {
        this.allObjects = objects;
        this.objectModel = new DefaultScrollPaneModel(columns, rows);
        this.popupWindow = new PopupWindow();
        this.popupWindow.setOkButtonVisible(true);
        this.popupWindow.setText(text);
        this.popupWindow.setComponent(this.getMainArea());
        this.popupWindow.setCancelButtonText(Internationalization.getLiteralFor((String)"CANCEL"));
        this.popupWindow.setCancelButtonVisible(allowCancel);
        if (hasClearButton) {
            this.popupWindow.getNavBar().addRight(this.popupWindow.getNavBar().getClearButton());
            this.popupWindow.clear.connect((Object)this, "gotClear");
        }
        this.setupModel(this.objectModel, this.allObjects);
    }

    public List<? extends Displayable> start(List<Displayable> intiallySelectedObjects) {
        this.selectedObjects = new ArrayList<Displayable>(intiallySelectedObjects);
        this.updateButtons();
        boolean result = this.popupWindow.start();
        return result ? this.selectedObjects : intiallySelectedObjects;
    }

    private void setupModel(DefaultScrollPaneModel model, List<? extends Displayable> objects) {
        List buttons = DataScrollPaneModel.createToggleButtons(objects, null, (ActionListener)this, (boolean)false);
        this.selectedObjects = new ArrayList<Displayable>();
        model.setItems((Collection)buttons);
        this.mainArea.displayPage(0);
    }

    public void gotClear() {
        this.selectedObjects.clear();
        this.updateButtons();
    }

    private void updateButtons() {
        for (Object dec : this.objectModel.getComponents()) {
            NameDecorator decor = (NameDecorator)dec;
            CustomToggleButton button = (CustomToggleButton)decor.getDecorateComponent();
            button.setSelected(this.selectedObjects.contains(button.getData()));
        }
    }

    private JComponent getMainArea() {
        if (this.mainArea == null) {
            this.mainArea = new CustomScrollPane((CustomScrollPaneModel)this.objectModel);
        }
        return this.mainArea;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof CustomToggleButton) {
            CustomToggleButton source = (CustomToggleButton)e.getSource();
            Displayable data = source.getData();
            this.objectSelected.emit((Object)data);
            for (Object dec : this.objectModel.getComponents()) {
                NameDecorator decor = (NameDecorator)dec;
                CustomToggleButton button = (CustomToggleButton)decor.getDecorateComponent();
                if (button.isSelected() && !this.selectedObjects.contains(button.getData())) {
                    this.selectedObjects.add(button.getData());
                    continue;
                }
                if (button.isSelected() || !this.selectedObjects.contains(button.getData())) continue;
                this.selectedObjects.remove(button.getData());
            }
        }
    }
}

