/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit.dialogs;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import ordermate.gui.dialogs.ForcedChoiceOptionDialog;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.PopupWindow;

public class WaiterMateForcedChoiceOptionDialog
extends PopupWindow
implements ForcedChoiceOptionDialog,
ActionListener {
    public final Signal<String, ?, ?, ?, ?> gotOption = Signals.createSignal(String.class, (String)"option");
    private List<JToggleButton> optionButtons;
    private boolean confirmation;
    private String confMessage;
    private String confTitle;
    private String confPosText;
    private String confNegText;

    public WaiterMateForcedChoiceOptionDialog(String message, String title, String posText, String negText, List<String> options, boolean requiresConfirmation) {
        super(true);
        this.confirmation = requiresConfirmation;
        this.setText(title);
        this.setComponent(this.createBodyComponent(message, options));
        this.setOkButtonVisible(true);
        this.setCancelButtonVisible(negText != null);
        this.setOKButtonText(posText != null ? posText : Internationalization.getLiteralFor((String)"OK"));
        this.setCancelButtonText(negText != null ? negText : Internationalization.getLiteralFor((String)"CANCEL"));
        this.setDisplayLocation(null);
        this.setPreferredSize(null);
        this.getNavBar().getOkButton().setEnabled(false);
    }

    private JComponent createBodyComponent(String message, List<String> options) {
        JPanel body = new JPanel(new GridLayout(2, 1, 0, 15));
        JLabel messageLabel = Dialogs.createMessageLabel(message);
        body.add(messageLabel);
        JPanel buttonGridWrapper = this.createOptionsPanel(body, options);
        body.add(buttonGridWrapper);
        return body;
    }

    private JPanel createOptionsPanel(JPanel parentBody, List<String> optionsToCreate) {
        this.optionButtons = new ArrayList<JToggleButton>();
        JPanel buttonGridWrapper = new JPanel(new FlowLayout(1));
        JPanel buttonGrid = new JPanel(new GridLayout(this.optionButtons.size(), 1, 0, 15));
        Dimension parentSize = parentBody.getPreferredSize();
        buttonGrid.setPreferredSize(new Dimension(parentSize.width / 2, parentSize.height / 2));
        for (String option : optionsToCreate) {
            JToggleButton optionButton = new JToggleButton(option);
            optionButton.addActionListener(this);
            buttonGrid.add(optionButton);
            this.optionButtons.add(optionButton);
        }
        buttonGridWrapper.add(buttonGrid);
        return buttonGridWrapper;
    }

    @Override
    public void gotOk() {
        this.gotOption.emit((Object)this.getChoice());
    }

    public void enableConfirmation(String message, String title, String posText, String negText) {
        this.confMessage = message;
        this.confTitle = title;
        this.confPosText = posText;
        this.confNegText = negText;
    }

    public boolean doConfirmation() {
        boolean proceed = false;
        if (this.confirmation) {
            proceed = Dialogs.displayForcedChoiceDialog(this.confMessage, this.confTitle, this.confPosText, this.confNegText);
        }
        if (proceed) {
            this.stop();
        }
        return proceed;
    }

    public JPanel getDisplayablePanel() {
        return this;
    }

    public Signal getSignal() {
        return this.gotOption;
    }

    public String getChoice() {
        for (JToggleButton button : this.optionButtons) {
            if (!button.isSelected()) continue;
            return button.getText();
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JToggleButton pressed = (JToggleButton)e.getSource();
        for (JToggleButton button : this.optionButtons) {
            if (button.equals(pressed)) continue;
            button.setSelected(false);
        }
        this.getNavBar().getOkButton().setEnabled(false);
        for (JToggleButton button : this.optionButtons) {
            if (!button.isSelected()) continue;
            this.getNavBar().getOkButton().setEnabled(true);
            break;
        }
    }
}

