/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit.search.searchfield;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.control.IDateRangePanel;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.util.DateTimeUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.finance.Shift;
import ordermate.database.misc.TradingDay;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.guikit.dialogs.CalendarDialog;

public class WaitermateDateRangePanel
extends JPanel
implements ActionListener,
IDateRangePanel {
    private JButton startDateButton;
    private Date startDate;
    private JButton endDateButton;
    private Date endDate;
    private RefreshAction refAction;
    private String startString;
    private String endString;
    private JComponent extraComponent;
    private FlaggedDateStrategy flagStrategy = new NoFlagsStrategy();
    public final Signal<?, ?, ?, ?, ?> dateChanged = Signals.createSignal();

    public WaitermateDateRangePanel() {
        this(Calendar.getInstance(), Calendar.getInstance());
    }

    public WaitermateDateRangePanel(Calendar start, Calendar end) {
        this(start, end, "Start date:", "End date:", null);
    }

    public WaitermateDateRangePanel(Calendar start, Calendar end, String startString, String endString, RefreshAction refAction) {
        super(null);
        this.startDateButton = new JButton();
        this.endDateButton = new JButton();
        this.startString = startString;
        this.endString = endString;
        this.startDate = start.getTime();
        this.endDate = end.getTime();
        this.startDateButton.setName("startDateButton");
        this.startDateButton.addActionListener(this);
        this.endDateButton.setName("endDateButton");
        this.endDateButton.addActionListener(this);
        this.refAction = refAction;
        this.layoutComponents();
        this.updateGui();
    }

    private void layoutComponents() {
        if (this.extraComponent != null) {
            this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(2, 3), 3, 3));
        } else {
            this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(2, 2), 3, 3));
        }
        this.add((Component)new JLabel(this.startString), new Rectangle(0, 0, 1, 1));
        this.add((Component)this.startDateButton, new Rectangle(1, 0, 1, 1));
        this.add((Component)new JLabel(this.endString), new Rectangle(0, 1, 1, 1));
        this.add((Component)this.endDateButton, new Rectangle(1, 1, 1, 1));
        if (this.extraComponent != null) {
            this.add((Component)this.extraComponent, new Rectangle(0, 2, 2, 1));
        }
    }

    public void addAction(Action action) {
        if (action != null) {
            this.startDateButton.addActionListener(action);
            this.endDateButton.addActionListener(action);
        }
    }

    public TradingDay getStartTradingDay() {
        return this.getStartShift() == null ? null : this.getStartShift().getTradingDay();
    }

    public TradingDay getEndTradingDay() {
        return this.getEndShift() == null ? null : this.getEndShift().getTradingDay();
    }

    public Shift getStartShift() {
        return Shift.getFirstShiftForDate((Date)this.startDate);
    }

    public Shift getEndShift() {
        return Shift.getFirstShiftForDate((Date)this.endDate);
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setDates(Calendar start, Calendar end) {
        this.setDates(start.getTime(), end.getTime());
    }

    public void setDates(Date startDate, Date endDate) {
        this.setStartDate(startDate);
        this.setEndDate(endDate);
    }

    public void setStartDate(Date start) {
        this.startDate = start;
        this.updateGui();
    }

    public void setEndDate(Date end) {
        this.endDate = end;
        this.updateGui();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.getStartButton().setEnabled(enabled);
        this.getEndButton().setEnabled(enabled);
        super.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        if (this.getStartButton() == null || this.getEndButton() == null) {
            return false;
        }
        return this.getStartButton().isEnabled() && this.getEndButton().isEnabled();
    }

    public JButton getStartButton() {
        return this.startDateButton;
    }

    public JButton getEndButton() {
        return this.endDateButton;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Date newDate;
        if (this.getStartButton().equals(e.getSource())) {
            Date newDate2 = this.gotButtonPressed(this.startDate);
            if (newDate2 != null) {
                this.setStartDate(newDate2);
                this.dateChanged.emit();
                this.fireRefresh();
            }
        } else if (this.getEndButton().equals(e.getSource()) && (newDate = this.gotButtonPressed(this.endDate)) != null) {
            this.setEndDate(DateTimeUtils.getEndOfDay((Date)newDate));
            this.dateChanged.emit();
            this.fireRefresh();
        }
    }

    private Date gotButtonPressed(Date selectedDate) {
        CalendarDialog dialog = new CalendarDialog(selectedDate == null ? new Date() : selectedDate);
        dialog.setup(selectedDate, this.flagStrategy.getDates());
        return dialog.start();
    }

    private void updateGui() {
        this.startDateButton.setText(this.getStartDate() == null ? "" : DateTimeUtils.getMediumDateFormat().format(this.getStartDate()));
        this.endDateButton.setText(this.getEndDate() == null ? "" : DateTimeUtils.getMediumDateFormat().format(this.getEndDate()));
    }

    public void fireRefresh() {
        if (this.refAction != null) {
            ActionEvent event = new ActionEvent(this, 1, "refresh");
            this.refAction.actionPerformed(event);
        }
    }

    public FlaggedDateStrategy getFlagStrategy() {
        return this.flagStrategy;
    }

    public void setFlagStrategy(FlaggedDateStrategy flagStrat) {
        this.flagStrategy = flagStrat;
    }

    public void setExtraComponent(JComponent newExtraComponent) {
        this.extraComponent = newExtraComponent;
        this.layoutComponents();
    }

    public static class QueryTypeWithDatePropertyFlagStrategy<T extends PropertiedObject>
    implements FlaggedDateStrategy {
        private String query;
        private Class clazzType;
        private PropertiedObject.Property<Date> dateProp;

        public QueryTypeWithDatePropertyFlagStrategy(Class<T> clazz, PropertiedObject.Property<Date> dateProp, String query) {
            this.query = query;
            this.clazzType = clazz;
            this.dateProp = dateProp;
        }

        @Override
        public Date[] getDates() {
            ArrayList<Object> toReturn = new ArrayList<Object>();
            List types = PersistenceManager.getObjectList((Class)this.clazzType, (String)this.query, null);
            for (PropertiedObject type : types) {
                toReturn.add(type.getPropertyValue(this.dateProp));
            }
            return toReturn.toArray(new Date[toReturn.size()]);
        }
    }

    static class NoFlagsStrategy
    implements FlaggedDateStrategy {
        NoFlagsStrategy() {
        }

        @Override
        public Date[] getDates() {
            return new Date[0];
        }
    }

    static interface FlaggedDateStrategy {
        public Date[] getDates();
    }
}

