/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit.search.searchfield;

import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.IRangedSearchFilter;
import au.com.ordermate.search.searchfield.java.AbstractDateRangeSearchField;
import au.com.ordermate.util.DateTimeUtils;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.Action;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import waitermate.guikit.search.searchfield.WaitermateDateRangePanel;
import waitermate.guikit.search.searchfield.WaitermateFixedPeriodsPanel;

public class WaitermateDateRangeSearchField
extends AbstractDateRangeSearchField
implements PropertyChangeListener {
    boolean updating = false;
    private WaitermateDateRangePanel dateRangePanel;
    private WaitermateFixedPeriodsPanel fixedDatesPanel;

    public WaitermateDateRangeSearchField(String label, PropertiedObject.Property prop, Date startSearchDate, SQLDateType dateType) {
        this(label, prop, startSearchDate, null, dateType);
    }

    public WaitermateDateRangeSearchField(String label, PropertiedObject.Property prop, Date startSearchDate, Action refreshAction, SQLDateType dateType) {
        this(label, (IRangedSearchFilter<Date>)new OptimisedDateRangeSearchFilter(prop, dateType), startSearchDate, refreshAction);
    }

    public WaitermateDateRangeSearchField(String label, IRangedSearchFilter<Date> prop, Date startSearchDate, Action refreshAction) {
        this(label, prop, startSearchDate, refreshAction, null);
    }

    public WaitermateDateRangeSearchField(String label, IRangedSearchFilter<Date> prop, Date startSearchDate, Action refreshAction, WaitermateDateRangePanel dateRangePanel) {
        super(label, prop, refreshAction);
        Date start;
        prop.addPropertyChangeListener((PropertyChangeListener)this);
        Date date = start = prop.getStart() != null ? (Date)prop.getStart() : startSearchDate;
        if (startSearchDate == null) {
            GregorianCalendar startCal = new GregorianCalendar();
            startCal.set(11, 0);
            startCal.set(12, 0);
            startCal.set(13, 0);
            startCal.set(14, 0);
            start = startCal.getTime();
        }
        this.dateRangePanel = dateRangePanel;
        this.getDateRangePanel().setDates(start, prop.getEnd() != null ? (Date)prop.getEnd() : new Date());
    }

    public WaitermateDateRangeSearchField(String label, PropertiedObject.Property prop, SQLDateType dateType) {
        this(label, prop, null, null, dateType);
    }

    public WaitermateDateRangeSearchField(String label, PropertiedObject.Property prop, Action refreshAction, SQLDateType dateType) {
        this(label, prop, null, refreshAction, dateType);
    }

    public WaitermateDateRangeSearchField useFixedDates() {
        this.getDateRangePanel().setExtraComponent(this.getFixedDatesPanel());
        return this;
    }

    public Component getGuiComponent() {
        return this.getDateRangePanel();
    }

    public void addAction(Action action) {
        this.getDateRangePanel().addAction(action);
    }

    public void reset() {
        this.getDateRangePanel().setEndDate(DateTimeUtils.getEndOfDay((Date)new Date()));
        this.getDateRangePanel().setStartDate(DateTimeUtils.getStartOfDay((Date)new Date()));
        this.fixedDatesPanel.reset();
    }

    public WaitermateDateRangePanel getDateRangePanel() {
        if (this.dateRangePanel == null) {
            this.dateRangePanel = new WaitermateDateRangePanel();
        }
        return this.dateRangePanel;
    }

    public WaitermateFixedPeriodsPanel getFixedDatesPanel() {
        if (this.fixedDatesPanel == null) {
            this.fixedDatesPanel = new WaitermateFixedPeriodsPanel(this.getDateRangePanel());
        }
        return this.fixedDatesPanel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.updating) {
            try {
                this.updating = true;
                this.getDateRangePanel().setStartDate((Date)this.getSearchProperty().getStart());
                this.getDateRangePanel().setEndDate((Date)this.getSearchProperty().getEnd());
            }
            finally {
                this.updating = false;
            }
        }
    }

    public IRangedSearchFilter<Date> getSearchProperty() {
        try {
            this.updating = true;
            IRangedSearchFilter searchProp = super.getSearchProperty();
            if (this.isEnabled()) {
                searchProp.setStart((Comparable)this.getDateRangePanel().getStartDate());
                searchProp.setEnd((Comparable)this.getDateRangePanel().getEndDate());
            } else {
                searchProp.setStart(null);
                searchProp.setEnd(null);
            }
            IRangedSearchFilter iRangedSearchFilter = searchProp;
            return iRangedSearchFilter;
        }
        finally {
            this.updating = false;
        }
    }

    public void setVisible(boolean flag) {
        this.getGuiComponent().setVisible(flag);
    }

    public boolean isVisible() {
        return this.getGuiComponent().isVisible();
    }

    public void setEnabled(boolean flag) {
        this.getGuiComponent().setEnabled(flag);
    }

    public boolean isEnabled() {
        return this.getGuiComponent().isEnabled();
    }
}

