/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit.search.searchfield;

import au.com.ordermate.gui.ObjectEditedDespatch;
import au.com.ordermate.gui.ObjectEditedListener;
import au.com.ordermate.search.filter.FixedPeriod;
import au.com.ordermate.util.HtmlUtils;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import ordermate.database.misc.DayPart;
import waitermate.guikit.dialogs.ObjectPopupWindow;
import waitermate.guikit.search.searchfield.WaitermateDateRangePanel;

public class WaitermateFixedPeriodsPanel
extends JPanel
implements ActionListener,
ObjectEditedListener {
    private String CUSTOM_DATE_RANGE = "Custom Date Range";
    private WaitermateDateRangePanel rangePanel;
    private ObjectPopupWindow dialog;
    private JButton button;
    private final EventList<FixedPeriod> datesList = new BasicEventList();

    public WaitermateFixedPeriodsPanel(WaitermateDateRangePanel yourPanel) {
        super(new BorderLayout());
        if (yourPanel == null) {
            throw new IllegalArgumentException("Cannot have a Fixed Period Panel without a DateRangePanel");
        }
        this.rangePanel = yourPanel;
        this.rangePanel.dateChanged.connect((Object)this, "gotDateChanged");
        this.setupComponents();
        ObjectEditedDespatch.getInstance().addListener(DayPart.class, (ObjectEditedListener)this);
        this.setSelectedFixedPeriod((FixedPeriod)FixedPeriod.getDefaultFuturePeriods().get(0));
    }

    public void gotDateChanged() {
        this.button.setText(this.CUSTOM_DATE_RANGE);
    }

    public void reset() {
        this.setSelectedFixedPeriod(FixedPeriod.getDefaultFixedPeriodForLabel((String)"Today"));
    }

    private void setupComponents() {
        this.button = new JButton(FixedPeriod.getDefaultFixedPeriodForLabel((String)"Today").getLabel());
        this.button.setName("fixedPeriod");
        this.button.addActionListener(this);
        this.refreshList();
        this.add(this.button);
    }

    public void objectEdited(Class clazz) {
        if (DayPart.class.equals((Object)clazz)) {
            this.button.removeActionListener(this);
            this.refreshList();
            this.button.addActionListener(this);
        }
    }

    private void refreshList() {
        try {
            this.datesList.getReadWriteLock().writeLock().lock();
            this.datesList.clear();
            this.datesList.addAll((Collection)FixedPeriod.getDefaultFuturePeriods());
            if (this.datesList.size() == 0) {
                this.setVisible(false);
            } else {
                this.setVisible(true);
            }
        }
        finally {
            this.datesList.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.button)) {
            this.gotButtonClicked();
        }
    }

    private void gotButtonClicked() {
        this.dialog = new ObjectPopupWindow<FixedPeriod>("Select Range", (List<FixedPeriod>)this.datesList, 3, 3, true, new ObjectPopupWindow.ObjectDisplayableLabelStrategy<FixedPeriod>(){

            @Override
            public String getDisplayableLabel(FixedPeriod object) {
                return object != null ? HtmlUtils.html((String)object.toString()) : "";
            }
        });
        Object result = this.dialog.start();
        this.setSelectedFixedPeriod((FixedPeriod)result);
    }

    private void setSelectedFixedPeriod(FixedPeriod fixedPeriod) {
        if (fixedPeriod != null) {
            this.rangePanel.setDates(fixedPeriod.getStartDate(), fixedPeriod.getEndDate());
            this.rangePanel.fireRefresh();
        }
        if (fixedPeriod != null) {
            this.button.setText(fixedPeriod.toString());
        }
    }

    public void refreshRangePanel() {
        this.setSelectedFixedPeriod(FixedPeriod.getDefaultFixedPeriodForLabel((String)this.button.getText().replace("Due ", "")));
    }
}

