/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit.search.searchfield;

import au.com.ordermate.oquery.search.filter.QuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import ca.odell.glazedlists.EventList;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import waitermate.guikit.dialogs.MultiSelectPopupWindow;

public class WaitermateMultiSelectToggleButtonDialogSearchField
extends SearchGuiField
implements ActionListener {
    private EventList dataList;
    private JButton guiButton;
    private MultiSelectPopupWindow popup;
    private final MultiOptionSearchFilter searchFilter;
    private List<Action> actions;
    private boolean noneEqualsAll = true;

    public WaitermateMultiSelectToggleButtonDialogSearchField(String searchFieldLabel, PropertiedObject.Property prop, EventList dataList, Action refreshAction) {
        this(searchFieldLabel, new MultiOptionSearchFilter(prop), dataList, refreshAction);
    }

    public WaitermateMultiSelectToggleButtonDialogSearchField(String searchFieldLabel, MultiOptionSearchFilter searchProp, EventList dataList, Action refreshAction) {
        super(searchFieldLabel, refreshAction);
        this.dataList = dataList;
        this.searchFilter = searchProp;
        this.popup = new MultiSelectPopupWindow("Select " + searchProp.getProperty().getUserVisibleLabel() + ":", (List<? extends Displayable>)this.dataList, 2, 3);
        this.updateButtonText();
    }

    public void setNoneEqualsAll(boolean value) {
        this.noneEqualsAll = value;
    }

    public void reset() {
        if (!this.noneEqualsAll) {
            this.searchFilter.clearSearch();
        } else {
            this.searchFilter.setSearchOptions((Collection)this.dataList);
        }
        this.updateButtonText();
    }

    public QuerySearchFilter getSearchProperty() {
        return this.getMultiOptionSearchProperty();
    }

    protected MultiOptionSearchFilter getMultiOptionSearchProperty() {
        if (!this.isEnabled()) {
            this.reset();
        }
        return this.searchFilter;
    }

    public void setVisible(boolean flag) {
        this.getGuiComponent().setVisible(flag);
    }

    public boolean isVisible() {
        return this.getGuiComponent().isVisible();
    }

    public void setEnabled(boolean flag) {
        this.getGuiComponent().setEnabled(flag);
    }

    public boolean isEnabled() {
        return this.getGuiComponent().isEnabled();
    }

    public Component getGuiComponent() {
        return this.getGuiButton();
    }

    private JButton getGuiButton() {
        if (this.guiButton == null) {
            this.guiButton = new JButton();
            this.guiButton.addActionListener(this);
        }
        return this.guiButton;
    }

    public void addAction(Action action) {
        if (this.actions == null) {
            this.actions = new ArrayList<Action>();
        }
        this.actions.add(action);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.getGuiButton())) {
            List<? extends Displayable> results = this.popup.start(this.searchFilter.getSelectedOptions());
            if (this.noneEqualsAll && results.isEmpty()) {
                results.addAll((Collection<? extends Displayable>)this.dataList);
            }
            this.searchFilter.setSearchOptions(results);
            this.updateButtonText();
            this.fireAllActions();
        }
    }

    private void fireAllActions() {
        for (Action action : this.actions) {
            ActionEvent event = new ActionEvent(this, 1, "refresh");
            action.actionPerformed(event);
        }
    }

    private void updateButtonText() {
        if (this.searchFilter.getSelectedOptions() == null || this.searchFilter.getSelectedOptions().isEmpty()) {
            this.getGuiButton().setText("ALL");
        } else {
            StringBuilder sb = new StringBuilder().append("<html>");
            for (Object selected : this.searchFilter.getSelectedOptions()) {
                sb.append(((Displayable)selected).getLabel()).append(", ");
            }
            sb.delete(sb.length() - 2, sb.length());
            sb.append("</html>");
            this.getGuiButton().setText(sb.toString());
        }
    }
}

