/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit.showitem;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.HtmlUtils;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import ordermate.database.misc.Course;
import ordermate.database.misc.EventLogRecord;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemSummary;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.printSummary.GroupByNameStrategy;
import ordermate.database.sales.printSummary.SalesItemSummaryGroup;
import ordermate.database.sales.printSummary.SummaryGroupCreator;
import ordermate.database.sales.printSummary.SummaryGroupingStrategy;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.LogicalTableState;
import ordermate.internationalization.Internationalization;
import waitermate.guikit.showitem.BySeatComparator;
import waitermate.guikit.showitem.ShowItemsDetails;

class EnhancedShowItemsDetails
extends ShowItemsDetails {
    private DateFormat timeFormat = DateFormat.getTimeInstance();
    private ItemGroup group;
    private boolean isTableAccount = false;

    EnhancedShowItemsDetails() {
    }

    @Override
    protected void addDetails(List<String> lines, ItemGroup currentGroup) {
        this.group = currentGroup;
        LogicalTable table = null;
        if (this.group instanceof TableAccount) {
            table = ((TableAccount)this.group).getTable();
            this.isTableAccount = true;
        } else if (this.group instanceof BarTabAccount) {
            table = ((BarTabAccount)this.group).getLogicalTable();
        }
        this.doState(lines, table);
        for (Course course : Course.getCourses()) {
            this.doCourse(lines, course);
        }
    }

    private void doState(List<String> lines, LogicalTable table) {
        StringBuilder SB = new StringBuilder("Created: ").append(this.timeFormat.format(this.group.getAccount().getCreationDateTime()));
        if (this.group.isOpen()) {
            if (table != null && this.group.isOpen() && table.getTableState() != null) {
                SB.append("<br>Table State: \"").append(table.getTableState().getLabel()).append("\"");
                if (table.getStateTime() != null) {
                    Date time = new Date(table.getStateTime());
                    SB.append(" at ").append(this.timeFormat.format(time));
                }
            }
        } else {
            SB.append("<br>Closed: ").append(this.timeFormat.format(this.group.getAccount().getClosedDateTime()));
        }
        SB.append("<br>");
        lines.add(SB.toString());
    }

    private void doCourse(List<String> lines, Course course) {
        List items;
        StringBuilder SB = new StringBuilder();
        if (this.group instanceof TableAccount) {
            TableAccount tableAccount = (TableAccount)this.group;
            LogicalTableState state = (LogicalTableState)PersistenceManager.getObject(LogicalTableState.class, (String)Query.select(LogicalTableState.class).equals(LogicalTableState.Properties.COURSE, (Object)course).toString());
            EventLogRecord log = null;
            if (state != null) {
                String courseChangeText = "No Table";
                if (tableAccount.getTable() != null) {
                    courseChangeText = "Table " + tableAccount.getTable().getPrimaryPhysicalTable().getName();
                }
                courseChangeText = courseChangeText + " changed from % to " + state.getLabel();
                ObjectQuery query = Query.select(EventLogRecord.class).equals(EventLogRecord.Properties.TRADING_DAY, (Object)tableAccount.getTradingDay()).equals(EventLogRecord.Properties.TYPE, (Object)"Table State").greaterThanOrEqual(EventLogRecord.Properties.EVENT_DATE, tableAccount.getCreationDateTime(), SQLDateType.DATE).greaterThanOrEqual(EventLogRecord.Properties.EVENT_TIME, tableAccount.getCreationDateTime(), SQLDateType.TIME).wherePropertyLike(EventLogRecord.Properties.MESSAGE, courseChangeText).orderBy(EventLogRecord.Properties.EVENT_DATE, true).limit(1);
                if (tableAccount.getClosedDateTime() != null) {
                    query.lessThanOrEqual(EventLogRecord.Properties.EVENT_DATE, tableAccount.getClosedDateTime(), SQLDateType.TIMESTAMP);
                }
                log = (EventLogRecord)PersistenceManager.getObject(EventLogRecord.class, (String)query.toString());
            }
            SB.append("<font color=\"green\">");
            SB.append(Internationalization.getLiteralFor((String)"COURSE")).append(" ").append(course.getName()).append("</font>");
            Course currentCourse = ((TableAccount)this.group).getCurrentCourse();
            if (log != null) {
                SB.append(HtmlUtils.addSpaces((int)4));
                String called = "Course called @ " + this.timeFormat.format(log.getEventTime());
                if (course.equals((Object)currentCourse)) {
                    SB.append(HtmlUtils.boldColor((String)called, (String)"orange"));
                } else {
                    SB.append(HtmlUtils.colour((String)called, (String)"gray"));
                }
            }
        }
        if (!(items = this.group.getItemHelper().getItems(course.getCourseIndex())).isEmpty()) {
            if (!SB.toString().isEmpty()) {
                lines.add(SB.toString());
            }
            this.doItems(lines, items);
        } else if (this.isTableAccount && !SystemProperty.getInstance().isHideNoItemsInSummary()) {
            lines.add(SB.toString());
            lines.add("<font color=\"gray\">No Items</font>");
        }
    }

    @Override
    protected void doItems(List<String> lines, List<SalesLineItem> items) {
        GroupByNameStrategy grouping = new GroupByNameStrategy();
        BySeatComparator comparator = new BySeatComparator();
        List summaryGroups = new SummaryGroupCreator((SummaryGroupingStrategy)grouping).createSummaryGroupsFromItems(items);
        Collections.sort(summaryGroups, comparator);
        for (SalesItemSummaryGroup summaryGroup : summaryGroups) {
            List summaries = summaryGroup.getSummaries();
            for (SalesItemSummary summary : summaries) {
                this.doItemSummary(lines, summary);
            }
        }
    }

    private void doItemSummary(List<String> lines, SalesItemSummary theSummary) {
        int indentSpaces = 9;
        String itemPad = this.getHTMLSpaces(9);
        String seats = "";
        if (this.isTableAccount) {
            seats = this.doSeats("", theSummary);
        }
        for (SalesItem currentItem : theSummary.getSalesItem().getSalesItems()) {
            String currentText = itemPad + theSummary.getTotalQuantity() + " " + currentItem.getLabel();
            String htmlTable = "<table class='ItemSeat' style='width: 100%;'><tr class='ItemSeat'><td class='ItemSeat' style='width: 50%'>" + currentText + "</td><td class='ItemSeat'>" + seats + "</td></tr></table>";
            lines.add(htmlTable);
            if (currentItem.getNotes() != null && currentItem.getNotes().length() > 0) {
                String notes = itemPad + itemPad + currentItem.getNotes();
                lines.add(itemPad + itemPad + currentItem.getNotes());
            }
            List theComponents = currentItem.getComponentList();
            for (SalesComponent currentComponent : theComponents) {
                if (!currentComponent.hasMinuses() && !currentComponent.hasPlusses() && !currentComponent.hasOption()) continue;
                this.doComponent(lines, currentComponent, theComponents.size() > 1);
            }
        }
    }

    private String doSeats(String prepend, SalesItemSummary summary) {
        StringBuilder SB = new StringBuilder("<font color=\"666666\">").append(prepend).append(this.getHTMLSpaces(2));
        ArrayList seats = new ArrayList(summary.getSeatNumbers());
        Collections.sort(seats);
        if (seats.size() == 1) {
            SB.append("Seat ");
            Integer seat = summary.getLowestSeat();
            SB.append(seat == null || seat == 0 ? "ALL" : seat);
            SB.append("</font>");
        } else {
            SB.append("Seats ");
            for (Integer nextSeat : seats) {
                if (nextSeat == null || nextSeat == 0) {
                    SB.append("ALL");
                } else {
                    SB.append(nextSeat);
                }
                SB.append(",");
            }
            SB.replace(SB.length() - 1, SB.length(), "</font>");
        }
        return SB.toString();
    }
}

