/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit.startup;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.configuration.Config;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.util.FontManagerUtil;
import java.awt.Color;
import javax.swing.UIManager;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.startup.laf.KunstoffSetup;
import ordermate.startup.laf.SubstanceSetup;
import org.jvnet.substance.skin.SubstanceSaharaLookAndFeel;

public class LaFSetupTask
extends AbstractTask {
    public final int getTotalSubTasks() {
        return 2;
    }

    public final String getName() {
        return "Setting up look and feel";
    }

    protected final void performTask() throws Exception {
        String lookAndFeelName;
        int scale = Config.getIntValue((String)"scale");
        Color toggleColor = Config.getColorValue((String)"toggle_color");
        int fontSize = Config.getIntValue((String)"Scale") + 10;
        String font = FontManagerUtil.setupFonts((int)fontSize);
        if (toggleColor != null) {
            UIManager.put("ToggleButton.select", toggleColor);
        }
        if ((lookAndFeelName = Config.getStringValue((String)"look_and_feel")).isEmpty()) {
            lookAndFeelName = SubstanceSaharaLookAndFeel.class.getName();
        }
        OrderMateLog.LOG.info("Attempting to use look and feel : " + lookAndFeelName);
        if (lookAndFeelName.endsWith("KunststoffLookAndFeel")) {
            new KunstoffSetup(scale, font, toggleColor, Config.getStringValue((String)"bgColor")).setupLaF();
        } else if (lookAndFeelName.contains("Substance")) {
            SubstanceSetup setup = new SubstanceSetup(scale, font, toggleColor, lookAndFeelName, Config.getBooleanValue((String)"showWatermark"), true);
            if (!setup.setupLaF()) {
                lookAndFeelName = "KunststoffLookAndFeel";
                setup = new KunstoffSetup(scale, font, toggleColor, Config.getStringValue((String)"bgColor"));
                setup.setupLaF();
            }
        } else {
            UIManager.setLookAndFeel(lookAndFeelName);
        }
        OrderMateTheme.initFonts();
        this.emitProgress();
        OrderMateLog.LOG.info("Setup look and feel : " + lookAndFeelName);
    }
}

