/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.base;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.JRThermometerPlot;
import net.sf.jasperreports.charts.JRValueDisplay;
import net.sf.jasperreports.charts.base.JRBaseDataRange;
import net.sf.jasperreports.charts.base.JRBaseValueDisplay;
import net.sf.jasperreports.charts.type.ValueLocationEnum;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.base.JRBaseChartPlot;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;

public class JRBaseThermometerPlot
extends JRBaseChartPlot
implements JRThermometerPlot {
    private static final long serialVersionUID = 10200L;
    protected JRDataRange dataRange = null;
    protected JRValueDisplay valueDisplay = null;
    protected boolean showValueLines = false;
    protected ValueLocationEnum valueLocationObject = null;
    protected Color mercuryColor = null;
    protected JRDataRange lowRange = null;
    protected JRDataRange mediumRange = null;
    protected JRDataRange highRange = null;
    private int PSEUDO_SERIAL_VERSION_UID = 30702;
    private byte valueLocation = ValueLocationEnum.BULB.getValue();
    private Byte valueLocationByte = null;

    public JRBaseThermometerPlot(JRChartPlot plot, JRChart chart) {
        super(plot, chart);
        JRThermometerPlot thermoPlot = plot instanceof JRThermometerPlot ? (JRThermometerPlot)plot : null;
        this.valueDisplay = thermoPlot == null ? new JRBaseValueDisplay(null, chart) : new JRBaseValueDisplay(thermoPlot.getValueDisplay(), chart);
    }

    public JRBaseThermometerPlot(JRThermometerPlot thermoPlot, JRBaseObjectFactory factory) {
        super((JRChartPlot)thermoPlot, factory);
        this.dataRange = new JRBaseDataRange(thermoPlot.getDataRange(), factory);
        this.valueDisplay = new JRBaseValueDisplay(thermoPlot.getValueDisplay(), factory);
        this.valueLocationObject = thermoPlot.getValueLocationValue();
        this.mercuryColor = thermoPlot.getMercuryColor();
        if (thermoPlot.getLowRange() != null) {
            this.lowRange = new JRBaseDataRange(thermoPlot.getLowRange(), factory);
        }
        if (thermoPlot.getMediumRange() != null) {
            this.mediumRange = new JRBaseDataRange(thermoPlot.getMediumRange(), factory);
        }
        if (thermoPlot.getHighRange() != null) {
            this.highRange = new JRBaseDataRange(thermoPlot.getHighRange(), factory);
        }
    }

    public JRDataRange getDataRange() {
        return this.dataRange;
    }

    public JRValueDisplay getValueDisplay() {
        return this.valueDisplay;
    }

    public boolean isShowValueLines() {
        return this.showValueLines;
    }

    public byte getValueLocation() {
        return this.getValueLocationValue() == null ? ValueLocationEnum.BULB.getValue() : this.getValueLocationValue().getValue();
    }

    public Byte getValueLocationByte() {
        return this.getValueLocationValue() == null ? null : this.getValueLocationValue().getValueByte();
    }

    public ValueLocationEnum getValueLocationValue() {
        return this.valueLocationObject;
    }

    public Color getMercuryColor() {
        return this.mercuryColor;
    }

    public JRDataRange getLowRange() {
        return this.lowRange;
    }

    public JRDataRange getMediumRange() {
        return this.mediumRange;
    }

    public JRDataRange getHighRange() {
        return this.highRange;
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public Object clone(JRChart parentChart) {
        JRBaseThermometerPlot clone = (JRBaseThermometerPlot)super.clone(parentChart);
        if (this.dataRange != null) {
            clone.dataRange = (JRDataRange)this.dataRange.clone();
        }
        if (this.valueDisplay != null) {
            clone.valueDisplay = (JRValueDisplay)this.valueDisplay.clone();
        }
        if (this.lowRange != null) {
            clone.lowRange = (JRDataRange)this.lowRange.clone();
        }
        if (this.mediumRange != null) {
            clone.mediumRange = (JRDataRange)this.mediumRange.clone();
        }
        if (this.highRange != null) {
            clone.highRange = (JRDataRange)this.highRange.clone();
        }
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30103) {
            this.valueLocationObject = ValueLocationEnum.getByValue(this.valueLocation);
        } else if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.valueLocationObject = ValueLocationEnum.getByValue(this.valueLocationByte);
            this.valueLocationByte = null;
        }
    }
}

