/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import jcifs.Config;
import jcifs.smb.SmbFile;

public class Handler
extends URLStreamHandler {
    static final URLStreamHandler SMB_HANDLER = new Handler();

    @Override
    protected int getDefaultPort() {
        return 445;
    }

    @Override
    public URLConnection openConnection(URL u) throws IOException {
        return new SmbFile(u, Config.getOpneConnectionAuthenticator());
    }

    @Override
    protected void parseURL(URL u, String spec, int start, int limit) {
        int port;
        String host = u.getHost();
        if (spec.equals("smb://")) {
            spec = "smb:////";
            limit += 2;
        } else if (!spec.startsWith("smb://") && host != null && host.length() == 0) {
            spec = "//" + spec;
            limit += 2;
        }
        super.parseURL(u, spec, start, limit);
        String path = u.getPath();
        String ref = u.getRef();
        if (ref != null) {
            path = path + '#' + ref;
        }
        if ((port = u.getPort()) == -1) {
            port = this.getDefaultPort();
        }
        this.setURL(u, "smb", u.getHost(), port, u.getAuthority(), u.getUserInfo(), path, u.getQuery(), null);
    }
}

