/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import jcifs.spnego.NegTokenInit;
import jcifs.spnego.NegTokenTarg;
import jcifs.spnego.SpnegoToken;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

class SpnegoContext {
    private GSSContext context;
    private Oid[] mechs;

    SpnegoContext(GSSContext source) throws GSSException {
        this(source, new Oid[]{source.getMech()});
    }

    SpnegoContext(GSSContext source, Oid[] mech) {
        this.context = source;
        this.mechs = mech;
    }

    Oid[] getMechs() {
        return this.mechs;
    }

    void setMechs(Oid[] mechs) {
        this.mechs = mechs;
    }

    GSSContext getGssContext() {
        return this.context;
    }

    byte[] initSecContext(byte[] inputBuf, int offset, int len) throws GSSException {
        byte[] ret = null;
        if (len == 0) {
            byte[] mechToken = this.context.initSecContext(inputBuf, offset, len);
            int contextFlags = 0;
            if (this.context.getCredDelegState()) {
                contextFlags |= 0x40;
            }
            if (this.context.getMutualAuthState()) {
                contextFlags |= 0x20;
            }
            if (this.context.getReplayDetState()) {
                contextFlags |= 0x10;
            }
            if (this.context.getSequenceDetState()) {
                contextFlags |= 8;
            }
            if (this.context.getAnonymityState()) {
                contextFlags |= 4;
            }
            if (this.context.getConfState()) {
                contextFlags |= 2;
            }
            if (this.context.getIntegState()) {
                contextFlags |= 1;
            }
            ret = new NegTokenInit(new String[]{this.context.getMech().toString()}, contextFlags, mechToken, null).toByteArray();
        } else {
            SpnegoToken spToken = this.getToken(inputBuf, offset, len);
            byte[] mechToken = spToken.getMechanismToken();
            if ((mechToken = this.context.initSecContext(mechToken, 0, mechToken.length)) != null) {
                int result = 1;
                if (this.context.isEstablished()) {
                    result = 0;
                }
                ret = new NegTokenTarg(result, this.context.getMech().toString(), mechToken, null).toByteArray();
            }
        }
        return ret;
    }

    public boolean isEstablished() {
        return this.context.isEstablished();
    }

    private SpnegoToken getToken(byte[] token, int off, int len) throws GSSException {
        byte[] b = new byte[len];
        if (off == 0 && token.length == len) {
            b = token;
        } else {
            System.arraycopy(token, off, b, 0, len);
        }
        return this.getToken(b);
    }

    private SpnegoToken getToken(byte[] token) throws GSSException {
        SpnegoToken spnegoToken = null;
        try {
            switch (token[0]) {
                case 96: {
                    spnegoToken = new NegTokenInit(token);
                    break;
                }
                case -95: {
                    spnegoToken = new NegTokenTarg(token);
                    break;
                }
                default: {
                    throw new GSSException(10);
                }
            }
            return spnegoToken;
        }
        catch (IOException e) {
            throw new GSSException(11);
        }
    }
}

