/*
 * Decompiled with CFR 0.152.
 */
package jcifs.spnego;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import jcifs.spnego.SpnegoToken;
import jcifs.spnego.asn1.ASN1EncodableVector;
import jcifs.spnego.asn1.ASN1OctetString;
import jcifs.spnego.asn1.ASN1Sequence;
import jcifs.spnego.asn1.ASN1TaggedObject;
import jcifs.spnego.asn1.DEREnumerated;
import jcifs.spnego.asn1.DERInputStream;
import jcifs.spnego.asn1.DERObjectIdentifier;
import jcifs.spnego.asn1.DEROctetString;
import jcifs.spnego.asn1.DEROutputStream;
import jcifs.spnego.asn1.DERSequence;
import jcifs.spnego.asn1.DERTaggedObject;

public class NegTokenTarg
extends SpnegoToken {
    public static final int UNSPECIFIED_RESULT = -1;
    public static final int ACCEPT_COMPLETED = 0;
    public static final int ACCEPT_INCOMPLETE = 1;
    public static final int REJECTED = 2;
    private String mechanism;
    private int result = -1;

    public NegTokenTarg() {
    }

    public NegTokenTarg(int result, String mechanism, byte[] mechanismToken, byte[] mechanismListMIC) {
        this.setResult(result);
        this.setMechanism(mechanism);
        this.setMechanismToken(mechanismToken);
        this.setMechanismListMIC(mechanismListMIC);
    }

    public NegTokenTarg(byte[] token) throws IOException {
        this.parse(token);
    }

    public int getResult() {
        return this.result;
    }

    public void setResult(int result) {
        this.result = result;
    }

    public String getMechanism() {
        return this.mechanism;
    }

    public void setMechanism(String mechanism) {
        this.mechanism = mechanism;
    }

    @Override
    public byte[] toByteArray() {
        try {
            byte[] mechanismListMIC;
            byte[] mechanismToken;
            String mechanism;
            ByteArrayOutputStream collector = new ByteArrayOutputStream();
            DEROutputStream der = new DEROutputStream(collector);
            ASN1EncodableVector fields = new ASN1EncodableVector();
            int result = this.getResult();
            if (result != -1) {
                fields.add(new DERTaggedObject(true, 0, new DEREnumerated(result)));
            }
            if ((mechanism = this.getMechanism()) != null) {
                fields.add(new DERTaggedObject(true, 1, new DERObjectIdentifier(mechanism)));
            }
            if ((mechanismToken = this.getMechanismToken()) != null) {
                fields.add(new DERTaggedObject(true, 2, new DEROctetString(mechanismToken)));
            }
            if ((mechanismListMIC = this.getMechanismListMIC()) != null) {
                fields.add(new DERTaggedObject(true, 3, new DEROctetString(mechanismListMIC)));
            }
            der.writeObject(new DERTaggedObject(true, 1, new DERSequence(fields)));
            return collector.toByteArray();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
    }

    @Override
    protected void parse(byte[] token) throws IOException {
        ByteArrayInputStream tokenStream = new ByteArrayInputStream(token);
        DERInputStream der = new DERInputStream(tokenStream);
        ASN1TaggedObject tagged = (ASN1TaggedObject)der.readObject();
        ASN1Sequence sequence = ASN1Sequence.getInstance(tagged, true);
        Enumeration fields = sequence.getObjects();
        block6: while (fields.hasMoreElements()) {
            tagged = (ASN1TaggedObject)fields.nextElement();
            switch (tagged.getTagNo()) {
                case 0: {
                    DEREnumerated enumerated = DEREnumerated.getInstance(tagged, true);
                    this.setResult(enumerated.getValue().intValue());
                    continue block6;
                }
                case 1: {
                    DERObjectIdentifier mechanism = DERObjectIdentifier.getInstance(tagged, true);
                    this.setMechanism(mechanism.getId());
                    continue block6;
                }
                case 2: {
                    ASN1OctetString mechanismToken = ASN1OctetString.getInstance(tagged, true);
                    this.setMechanismToken(mechanismToken.getOctets());
                    continue block6;
                }
                case 3: {
                    ASN1OctetString mechanismListMIC = ASN1OctetString.getInstance(tagged, true);
                    this.setMechanismListMIC(mechanismListMIC.getOctets());
                    continue block6;
                }
            }
            throw new IOException("Malformed token field.");
        }
    }
}

