/*
 * Decompiled with CFR 0.152.
 */
package jcifs.spnego.asn1;

import java.io.IOException;
import java.math.BigInteger;
import jcifs.spnego.asn1.ASN1OctetString;
import jcifs.spnego.asn1.ASN1TaggedObject;
import jcifs.spnego.asn1.DERObject;
import jcifs.spnego.asn1.DEROutputStream;

public class DERInteger
extends DERObject {
    byte[] bytes;

    public static DERInteger getInstance(Object obj) {
        if (obj == null || obj instanceof DERInteger) {
            return (DERInteger)obj;
        }
        if (obj instanceof ASN1OctetString) {
            return new DERInteger(((ASN1OctetString)obj).getOctets());
        }
        if (obj instanceof ASN1TaggedObject) {
            return DERInteger.getInstance(((ASN1TaggedObject)obj).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERInteger getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DERInteger.getInstance(obj.getObject());
    }

    public DERInteger(int value) {
        this.bytes = BigInteger.valueOf(value).toByteArray();
    }

    public DERInteger(BigInteger value) {
        this.bytes = value.toByteArray();
    }

    public DERInteger(byte[] bytes) {
        this.bytes = bytes;
    }

    public BigInteger getValue() {
        return new BigInteger(this.bytes);
    }

    public BigInteger getPositiveValue() {
        return new BigInteger(1, this.bytes);
    }

    @Override
    void encode(DEROutputStream out) throws IOException {
        out.writeEncoded(2, this.bytes);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof DERInteger)) {
            return false;
        }
        DERInteger other = (DERInteger)o;
        if (this.bytes.length != other.bytes.length) {
            return false;
        }
        for (int i = 0; i != this.bytes.length; ++i) {
            if (this.bytes[i] == other.bytes[i]) continue;
            return false;
        }
        return true;
    }
}

