/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.BasicInputConnector;
import com.sun.media.BasicSinkModule;
import com.sun.media.Connector;
import com.sun.media.CreateWorkThreadAction;
import com.sun.media.InputConnector;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.Log;
import com.sun.media.PlaybackEngine;
import com.sun.media.RenderThread;
import com.sun.media.SimpleGraphBuilder;
import com.sun.media.renderer.audio.AudioRenderer;
import com.sun.media.rtp.util.RTPTimeBase;
import com.sun.media.rtp.util.RTPTimeReporter;
import com.sun.media.util.ElapseTime;
import com.sun.media.util.jdk12;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.media.Buffer;
import javax.media.Clock;
import javax.media.Drainable;
import javax.media.Format;
import javax.media.Prefetchable;
import javax.media.Renderer;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.renderer.VideoRenderer;

public class BasicRendererModule
extends BasicSinkModule
implements RTPTimeReporter {
    protected PlaybackEngine engine;
    protected Renderer renderer;
    protected InputConnector ic;
    protected int framesPlayed = 0;
    protected float frameRate = 30.0f;
    protected boolean framesWereBehind = false;
    protected boolean prefetching = false;
    protected boolean started = false;
    private boolean opened = false;
    private int chunkSize = Integer.MAX_VALUE;
    private long prefetchedAudioDuration = 0L;
    private long lastDuration = 0L;
    private RTPTimeBase rtpTimeBase = null;
    private String rtpCNAME = null;
    RenderThread renderThread;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    private Object prefetchSync = new Object();
    private ElapseTime elapseTime = new ElapseTime();
    private long LEEWAY = 10L;
    private long lastRendered = 0L;
    private boolean failed = false;
    private boolean notToDropNext = false;
    private Buffer storedBuffer = null;
    private boolean checkRTP = false;
    private boolean noSync = false;
    final float MAX_RATE = 1.05f;
    final float RATE_INCR = 0.01f;
    final int FLOW_LIMIT = 20;
    boolean overMsg = false;
    int overflown = 10;
    float rate = 1.0f;
    long systemErr = 0L;
    static final long RTP_TIME_MARGIN = 2000000000L;
    boolean rtpErrMsg = false;
    long lastTimeStamp;
    static final int MAX_CHUNK_SIZE = 16;
    AudioFormat ulawFormat = new AudioFormat("ULAW");
    AudioFormat linearFormat = new AudioFormat("LINEAR");
    static /* synthetic */ Class class$com$sun$media$RenderThread;
    static /* synthetic */ Class class$com$sun$media$BasicRendererModule;

    protected BasicRendererModule(Renderer renderer) {
        this.setRenderer(renderer);
        this.ic = new BasicInputConnector();
        if (renderer instanceof VideoRenderer) {
            this.ic.setSize(4);
        } else {
            this.ic.setSize(1);
        }
        this.ic.setModule(this);
        this.registerInputConnector("input", this.ic);
        this.setProtocol(1);
    }

    public boolean isThreaded() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean doRealize() {
        Object object;
        this.chunkSize = this.computeChunkSize(this.ic.getFormat());
        if (jmfSecurity != null) {
            object = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    object = "thread";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    object = "thread group";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (!jmfSecurity.getName().startsWith("internet")) {
                    // empty if block
                }
            }
            catch (Throwable throwable) {
                securityPrivelege = false;
            }
        }
        if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
            try {
                object = CreateWorkThreadAction.cons;
                this.renderThread = (RenderThread)jdk12.doPrivM.invoke((Object)jdk12.ac, ((Constructor)object).newInstance(class$com$sun$media$RenderThread == null ? (class$com$sun$media$RenderThread = BasicRendererModule.class$("com.sun.media.RenderThread")) : class$com$sun$media$RenderThread, class$com$sun$media$BasicRendererModule == null ? (class$com$sun$media$BasicRendererModule = BasicRendererModule.class$("com.sun.media.BasicRendererModule")) : class$com$sun$media$BasicRendererModule, this));
            }
            catch (Exception exception) {}
        } else {
            this.renderThread = new RenderThread(this);
        }
        this.engine = (PlaybackEngine)this.getController();
        return true;
    }

    public boolean doPrefetch() {
        super.doPrefetch();
        if (!this.opened) {
            try {
                this.renderer.open();
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                this.prefetchFailed = true;
                return false;
            }
            this.prefetchFailed = false;
            this.opened = true;
        }
        if (!((PlaybackEngine)this.controller).prefetchEnabled) {
            return true;
        }
        this.prefetching = true;
        this.renderThread.start();
        return true;
    }

    public void doFailedPrefetch() {
        this.renderThread.pause();
        this.renderer.close();
        this.opened = false;
        this.prefetching = false;
    }

    public void abortPrefetch() {
        this.renderThread.pause();
        this.renderer.close();
        this.prefetching = false;
        this.opened = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() {
        super.doStart();
        if (!(this.renderer instanceof Clock)) {
            this.renderer.start();
        }
        this.prerolling = false;
        this.started = true;
        Object object = this.prefetchSync;
        synchronized (object) {
            this.prefetching = false;
            this.renderThread.start();
        }
    }

    public void doStop() {
        this.started = false;
        this.prefetching = true;
        super.doStop();
        if (this.renderer != null && !(this.renderer instanceof Clock)) {
            this.renderer.stop();
        }
    }

    public void doDealloc() {
        this.renderer.close();
    }

    public void doClose() {
        this.renderThread.kill();
        if (this.renderer != null) {
            this.renderer.close();
        }
        if (this.rtpTimeBase != null) {
            RTPTimeBase.remove(this, this.rtpCNAME);
            this.rtpTimeBase = null;
        }
    }

    public void reset() {
        super.reset();
        this.prefetching = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerReset() {
        if (this.renderer != null) {
            this.renderer.reset();
        }
        Object object = this.prefetchSync;
        synchronized (object) {
            this.prefetching = false;
            if (this.resetted) {
                this.renderThread.start();
            }
        }
    }

    public void doneReset() {
        this.renderThread.pause();
    }

    protected boolean reinitRenderer(Format format) {
        if (this.renderer != null && this.renderer.setInputFormat(format) != null) {
            return true;
        }
        if (this.started) {
            this.renderer.stop();
            this.renderer.reset();
        }
        this.renderer.close();
        this.renderer = null;
        Renderer renderer = SimpleGraphBuilder.findRenderer(format);
        if (renderer == null) {
            return false;
        }
        this.setRenderer(renderer);
        if (this.started) {
            this.renderer.start();
        }
        this.chunkSize = this.computeChunkSize(format);
        return true;
    }

    protected void setRenderer(Renderer renderer) {
        this.renderer = renderer;
        if (this.renderer instanceof Clock) {
            this.setClock((Clock)((Object)this.renderer));
        }
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    protected void process() {
    }

    protected boolean doProcess() {
        if ((this.started || this.prefetching) && this.stopTime > -1L && this.elapseTime.value >= this.stopTime) {
            if (this.renderer instanceof Drainable) {
                ((Drainable)((Object)this.renderer)).drain();
            }
            this.doStop();
            if (this.moduleListener != null) {
                this.moduleListener.stopAtTime(this);
            }
        }
        Buffer buffer = this.storedBuffer != null ? this.storedBuffer : this.ic.getValidBuffer();
        if (!this.checkRTP) {
            if ((buffer.getFlags() & 0x1000) != 0) {
                String string = this.engine.getCNAME();
                if (string != null) {
                    this.rtpTimeBase = RTPTimeBase.find(this, string);
                    this.rtpCNAME = string;
                    if (this.ic.getFormat() instanceof AudioFormat) {
                        Log.comment("RTP master time set: " + this.renderer + "\n");
                        this.rtpTimeBase.setMaster(this);
                    }
                    this.checkRTP = true;
                    this.noSync = false;
                } else {
                    this.noSync = true;
                }
            } else {
                this.checkRTP = true;
            }
        }
        this.lastTimeStamp = buffer.getTimeStamp();
        if (this.failed || this.resetted) {
            if ((buffer.getFlags() & 0x200) != 0) {
                this.resetted = false;
                this.renderThread.pause();
                if (this.moduleListener != null) {
                    this.moduleListener.resetted(this);
                }
            }
            this.storedBuffer = null;
            this.ic.readReport();
            return true;
        }
        if (PlaybackEngine.DEBUG) {
            this.jmd.moduleIn(this, 0, buffer, true);
        }
        boolean bl = this.scheduleBuffer(buffer);
        if (this.storedBuffer == null && buffer.isEOM()) {
            if (this.prefetching) {
                this.donePrefetch();
            }
            if ((buffer.getFlags() & 0x40) == 0 && buffer.getTimeStamp() > 0L && buffer.getDuration() > 0L && buffer.getFormat() != null && !(buffer.getFormat() instanceof AudioFormat) && !this.noSync) {
                this.waitForPT(buffer.getTimeStamp() + this.lastDuration);
            }
            this.storedBuffer = null;
            this.ic.readReport();
            if (PlaybackEngine.DEBUG) {
                this.jmd.moduleIn(this, 0, buffer, false);
            }
            this.doStop();
            if (this.moduleListener != null) {
                this.moduleListener.mediaEnded(this);
            }
            return true;
        }
        if (this.storedBuffer == null) {
            this.ic.readReport();
        }
        if (PlaybackEngine.DEBUG) {
            this.jmd.moduleIn(this, 0, buffer, false);
        }
        return bl;
    }

    protected boolean scheduleBuffer(Buffer buffer) {
        int n2 = 0;
        Format format = buffer.getFormat();
        if (format == null) {
            format = this.ic.getFormat();
            buffer.setFormat(format);
        }
        if (!(format == this.ic.getFormat() || format.equals(this.ic.getFormat()) || buffer.isDiscard() || this.handleFormatChange(format))) {
            return false;
        }
        if ((buffer.getFlags() & 0x400) != 0 && this.moduleListener != null) {
            this.moduleListener.markedDataArrived(this, buffer);
            buffer.setFlags(buffer.getFlags() & 0xFFFFFBFF);
        }
        if (this.prefetching || format instanceof AudioFormat || buffer.getTimeStamp() <= 0L || (buffer.getFlags() & 0x60) == 96 || this.noSync) {
            if (!buffer.isDiscard()) {
                n2 = this.processBuffer(buffer);
            }
        } else {
            long l2 = this.getSyncTime(buffer.getTimeStamp());
            long l3 = l2 / 1000000L - buffer.getTimeStamp() / 1000000L - this.getLatency() / 1000000L;
            if (this.storedBuffer == null && l3 > 0L) {
                if (buffer.isDiscard()) {
                    this.notToDropNext = true;
                } else {
                    if (buffer.isEOM()) {
                        this.notToDropNext = true;
                    } else if (this.moduleListener != null && format instanceof VideoFormat) {
                        float f2 = (float)l3 * this.frameRate / 1000.0f;
                        if (f2 < 1.0f) {
                            f2 = 1.0f;
                        }
                        this.moduleListener.framesBehind(this, f2, this.ic);
                        this.framesWereBehind = true;
                    }
                    if ((buffer.getFlags() & 0x20) != 0) {
                        n2 = this.processBuffer(buffer);
                    } else if (l3 < this.LEEWAY || this.notToDropNext || buffer.getTimeStamp() - this.lastRendered > 1000000000L) {
                        n2 = this.processBuffer(buffer);
                        this.lastRendered = buffer.getTimeStamp();
                        this.notToDropNext = false;
                    }
                }
            } else {
                if (this.moduleListener != null && this.framesWereBehind && format instanceof VideoFormat) {
                    this.moduleListener.framesBehind(this, 0.0f, this.ic);
                    this.framesWereBehind = false;
                }
                if (!buffer.isDiscard()) {
                    if ((buffer.getFlags() & 0x40) == 0) {
                        this.waitForPT(buffer.getTimeStamp());
                    }
                    if (!this.resetted) {
                        n2 = this.processBuffer(buffer);
                        this.lastRendered = buffer.getTimeStamp();
                    }
                }
            }
        }
        if (n2 & true) {
            this.storedBuffer = null;
        } else if ((n2 & 2) != 0) {
            this.storedBuffer = buffer;
        } else {
            this.storedBuffer = null;
            if (buffer.getDuration() >= 0L) {
                this.lastDuration = buffer.getDuration();
            }
        }
        return true;
    }

    public int processBuffer(Buffer buffer) {
        int n2 = buffer.getLength();
        int n3 = buffer.getOffset();
        int n4 = 0;
        boolean bl = false;
        if (this.renderer instanceof Clock) {
            this.overflown = (buffer.getFlags() & 0x2000) != 0 ? ++this.overflown : --this.overflown;
            if (this.overflown > 20) {
                if (this.rate < 1.05f) {
                    this.rate += 0.01f;
                    this.renderer.stop();
                    ((Clock)((Object)this.renderer)).setRate(this.rate);
                    this.renderer.start();
                    if (!this.overMsg) {
                        Log.comment("Data buffers overflown.  Adjust rendering speed up to 5 % to compensate");
                        this.overMsg = true;
                    }
                }
                this.overflown = 10;
            } else if (this.overflown <= 0) {
                if (this.rate > 1.0f) {
                    this.rate -= 0.01f;
                    this.renderer.stop();
                    ((Clock)((Object)this.renderer)).setRate(this.rate);
                    this.renderer.start();
                }
                this.overflown = 10;
            }
        }
        do {
            int n5;
            block25: {
                if (this.stopTime > -1L && this.elapseTime.value >= this.stopTime) {
                    if (this.prefetching) {
                        this.donePrefetch();
                    }
                    return 2;
                }
                if (n2 <= this.chunkSize || this.prerolling) {
                    if (bl) {
                        bl = false;
                        buffer.setEOM(true);
                    }
                    n5 = n2;
                } else {
                    if (buffer.isEOM()) {
                        bl = true;
                        buffer.setEOM(false);
                    }
                    n5 = this.chunkSize;
                }
                buffer.setLength(n5);
                buffer.setOffset(n3);
                if (this.prerolling && !this.handlePreroll(buffer)) {
                    n3 += n5;
                    n2 -= n5;
                    continue;
                }
                try {
                    n4 = this.renderer.process(buffer);
                }
                catch (Throwable throwable) {
                    Log.dumpStack(throwable);
                    if (this.moduleListener == null) break block25;
                    this.moduleListener.internalErrorOccurred(this);
                }
            }
            if ((n4 & 8) != 0) {
                this.failed = true;
                if (this.moduleListener != null) {
                    this.moduleListener.pluginTerminated(this);
                }
                return n4;
            }
            if ((n4 & 1) != 0) {
                buffer.setDiscard(true);
                if (this.prefetching) {
                    this.donePrefetch();
                }
                return n4;
            }
            if ((n4 & 2) != 0) {
                n5 -= buffer.getLength();
            }
            n3 += n5;
            n2 -= n5;
            if (this.prefetching && (!(this.renderer instanceof Prefetchable) || ((Prefetchable)((Object)this.renderer)).isPrefetched())) {
                bl = false;
                buffer.setEOM(false);
                this.donePrefetch();
                break;
            }
            this.elapseTime.update(n5, buffer.getTimeStamp(), buffer.getFormat());
        } while (n2 > 0 && !this.resetted);
        if (bl) {
            buffer.setEOM(true);
        }
        buffer.setLength(n2);
        buffer.setOffset(n3);
        if (n4 == 0) {
            ++this.framesPlayed;
        }
        return n4;
    }

    private boolean handleFormatChange(Format format) {
        float f2;
        if (!this.reinitRenderer(format)) {
            this.storedBuffer = null;
            this.failed = true;
            if (this.moduleListener != null) {
                this.moduleListener.formatChangedFailure(this, this.ic.getFormat(), format);
            }
            return false;
        }
        Format format2 = this.ic.getFormat();
        this.ic.setFormat(format);
        if (this.moduleListener != null) {
            this.moduleListener.formatChanged(this, format2, format);
        }
        if (format instanceof VideoFormat && (f2 = ((VideoFormat)format).getFrameRate()) != -1.0f) {
            this.frameRate = f2;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void donePrefetch() {
        Object object = this.prefetchSync;
        synchronized (object) {
            if (!this.started && this.prefetching) {
                this.renderThread.pause();
            }
            this.prefetching = false;
        }
        if (this.moduleListener != null) {
            this.moduleListener.bufferPrefetched(this);
        }
    }

    public void setPreroll(long l2, long l3) {
        super.setPreroll(l2, l3);
        this.elapseTime.setValue(l3);
    }

    protected boolean handlePreroll(Buffer buffer) {
        if (buffer.getFormat() instanceof AudioFormat ? !this.hasReachAudioPrerollTarget(buffer) : (buffer.getFlags() & 0x60) == 0 && buffer.getTimeStamp() >= 0L && buffer.getTimeStamp() < this.getSyncTime(buffer.getTimeStamp())) {
            return false;
        }
        this.prerolling = false;
        return true;
    }

    private boolean hasReachAudioPrerollTarget(Buffer buffer) {
        long l2 = this.getSyncTime(buffer.getTimeStamp());
        this.elapseTime.update(buffer.getLength(), buffer.getTimeStamp(), buffer.getFormat());
        if (this.elapseTime.value >= l2) {
            long l3 = ElapseTime.audioTimeToLen(this.elapseTime.value - l2, (AudioFormat)buffer.getFormat());
            int n2 = buffer.getOffset() + buffer.getLength() - (int)l3;
            if (n2 >= 0) {
                buffer.setOffset(n2);
                buffer.setLength((int)l3);
            }
            this.elapseTime.setValue(l2);
            return true;
        }
        return false;
    }

    private boolean waitForPT(long l2) {
        long l3 = this.getSyncTime(l2);
        long l4 = -1L;
        int n2 = 0;
        long l5 = (l2 - l3) / 1000000L;
        if (this.rate != 1.0f) {
            l5 = (long)((float)l5 / this.rate);
        }
        while (l5 > this.systemErr && !this.resetted) {
            long l6;
            if (l5 == l4) {
                l6 = l5 + (long)(5 * n2);
                if (l6 > 33L) {
                    l6 = 33L;
                } else {
                    ++n2;
                }
            } else {
                l6 = l5;
                n2 = 0;
            }
            l6 = l6 > 125L ? 125L : l6;
            long l7 = System.currentTimeMillis();
            l6 -= this.systemErr;
            try {
                if (l6 > 0L) {
                    Thread.currentThread();
                    Thread.sleep(l6);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            long l8 = System.currentTimeMillis() - l7;
            this.systemErr = (l8 - l6 + this.systemErr) / 2L;
            if (this.systemErr < 0L) {
                this.systemErr = 0L;
            } else if (this.systemErr > l6) {
                this.systemErr = l6;
            }
            l3 = this.getSyncTime(l2);
            l4 = l5;
            l5 = (l2 - l3) / 1000000L;
            if (this.rate != 1.0f) {
                l5 = (long)((float)l5 / this.rate);
            }
            if (this.getState() == 600) continue;
            break;
        }
        return true;
    }

    private long getSyncTime(long l2) {
        if (this.rtpTimeBase != null) {
            if (this.rtpTimeBase.getMaster() == this.getController()) {
                return l2;
            }
            long l3 = this.rtpTimeBase.getNanoseconds();
            if (l3 > l2 + 2000000000L || l3 < l2 - 2000000000L) {
                if (!this.rtpErrMsg) {
                    Log.comment("Cannot perform RTP sync beyond a difference of: " + (l3 - l2) / 1000000L + " msecs.\n");
                    this.rtpErrMsg = true;
                }
                return l2;
            }
            return l3;
        }
        return this.getMediaNanoseconds();
    }

    public long getRTPTime() {
        if (this.ic.getFormat() instanceof AudioFormat) {
            if (this.renderer instanceof AudioRenderer) {
                return this.lastTimeStamp - ((AudioRenderer)this.renderer).getLatency();
            }
            return this.lastTimeStamp;
        }
        return this.lastTimeStamp;
    }

    public Object[] getControls() {
        return this.renderer.getControls();
    }

    public Object getControl(String string) {
        return this.renderer.getControl(string);
    }

    public void setFormat(Connector connector, Format format) {
        float f2;
        this.renderer.setInputFormat(format);
        if (format instanceof VideoFormat && (f2 = ((VideoFormat)format).getFrameRate()) != -1.0f) {
            this.frameRate = f2;
        }
    }

    public int getFramesPlayed() {
        return this.framesPlayed;
    }

    public void resetFramesPlayed() {
        this.framesPlayed = 0;
    }

    private int computeChunkSize(Format format) {
        if (format instanceof AudioFormat && (this.ulawFormat.matches(format) || this.linearFormat.matches(format))) {
            AudioFormat audioFormat = (AudioFormat)format;
            int n2 = audioFormat.getSampleSizeInBits() * audioFormat.getChannels() / 8;
            if (n2 == 0) {
                n2 = 1;
            }
            int n3 = (int)audioFormat.getSampleRate() * n2 / 16;
            return n3 / n2 * n2;
        }
        return Integer.MAX_VALUE;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

