/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers;

import com.google.i18n.phonenumbers.AsYouTypeFormatter;
import com.google.i18n.phonenumbers.CountryCodeToRegionCodeMap;
import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberMatch;
import com.google.i18n.phonenumbers.PhoneNumberMatcher;
import com.google.i18n.phonenumbers.Phonemetadata;
import com.google.i18n.phonenumbers.Phonenumber;
import com.google.i18n.phonenumbers.RegexCache;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhoneNumberUtil {
    static final int REGEX_FLAGS = 66;
    private static final int MIN_LENGTH_FOR_NSN = 3;
    static final int MAX_LENGTH_FOR_NSN = 16;
    static final int MAX_LENGTH_COUNTRY_CODE = 3;
    static final String META_DATA_FILE_PREFIX = "/com/google/i18n/phonenumbers/data/PhoneNumberMetadataProto";
    private String currentFilePrefix = "/com/google/i18n/phonenumbers/data/PhoneNumberMetadataProto";
    private static final Logger LOGGER = Logger.getLogger(PhoneNumberUtil.class.getName());
    private Map<Integer, List<String>> countryCallingCodeToRegionCodeMap = null;
    private final Set<String> supportedRegions = new HashSet<String>(320);
    private static final String UNKNOWN_REGION = "ZZ";
    private final Set<String> nanpaRegions = new HashSet<String>(35);
    private static final int NANPA_COUNTRY_CODE = 1;
    private static final String COLOMBIA_MOBILE_TO_FIXED_LINE_PREFIX = "3";
    static final char PLUS_SIGN = '+';
    private static final char STAR_SIGN = '*';
    private static final String RFC3966_EXTN_PREFIX = ";ext=";
    private static final Map<Character, Character> DIALLABLE_CHAR_MAPPINGS;
    private static final Map<Character, Character> ALPHA_MAPPINGS;
    private static final Map<Character, Character> ALPHA_PHONE_MAPPINGS;
    private static final Map<Character, Character> ALL_PLUS_NUMBER_GROUPING_SYMBOLS;
    private static final Pattern UNIQUE_INTERNATIONAL_PREFIX;
    static final String VALID_PUNCTUATION = "-x\u2010-\u2015\u2212\u30fc\uff0d-\uff0f \u00a0\u200b\u2060\u3000()\uff08\uff09\uff3b\uff3d.\\[\\]/~\u2053\u223c\uff5e";
    private static final String DIGITS = "\\p{Nd}";
    private static final String VALID_ALPHA;
    static final String PLUS_CHARS = "+\uff0b";
    static final Pattern PLUS_CHARS_PATTERN;
    private static final Pattern SEPARATOR_PATTERN;
    private static final Pattern CAPTURING_DIGIT_PATTERN;
    private static final String VALID_START_CHAR = "[+\uff0b\\p{Nd}]";
    private static final Pattern VALID_START_CHAR_PATTERN;
    private static final String SECOND_NUMBER_START = "[\\\\/] *x";
    static final Pattern SECOND_NUMBER_START_PATTERN;
    private static final String UNWANTED_END_CHARS = "[[\\P{N}&&\\P{L}]&&[^#]]+$";
    static final Pattern UNWANTED_END_CHAR_PATTERN;
    private static final Pattern VALID_ALPHA_PHONE_PATTERN;
    private static final String VALID_PHONE_NUMBER;
    private static final String DEFAULT_EXTN_PREFIX = " ext. ";
    private static final String CAPTURING_EXTN_DIGITS = "(\\p{Nd}{1,7})";
    private static final String EXTN_PATTERNS_FOR_PARSING;
    static final String EXTN_PATTERNS_FOR_MATCHING;
    private static final Pattern EXTN_PATTERN;
    private static final Pattern VALID_PHONE_NUMBER_PATTERN;
    private static final Pattern NON_DIGITS_PATTERN;
    private static final Pattern FIRST_GROUP_PATTERN;
    private static final Pattern NP_PATTERN;
    private static final Pattern FG_PATTERN;
    private static final Pattern CC_PATTERN;
    private static PhoneNumberUtil instance;
    private final Map<String, Phonemetadata.PhoneMetadata> regionToMetadataMap = Collections.synchronizedMap(new HashMap());
    private final Map<Integer, Phonemetadata.PhoneMetadata> countryCodeToNonGeographicalMetadataMap = Collections.synchronizedMap(new HashMap());
    private RegexCache regexCache = new RegexCache(100);
    public static final String REGION_CODE_FOR_NON_GEO_ENTITY = "001";

    private static String createExtnPattern(String string) {
        return ";ext=(\\p{Nd}{1,7})|[ \u00a0\\t,]*(?:e?xt(?:ensi(?:o\u0301?|\u00f3))?n?|\uff45?\uff58\uff54\uff4e?|[" + string + "]|int|anexo|\uff49\uff4e\uff54)" + "[:\\.\uff0e]?[ \u00a0\\t,-]*" + CAPTURING_EXTN_DIGITS + "#?|" + "[- ]+(" + DIGITS + "{1,5})#";
    }

    private PhoneNumberUtil() {
    }

    private void init(String string) {
        this.currentFilePrefix = string;
        for (List<String> list : this.countryCallingCodeToRegionCodeMap.values()) {
            this.supportedRegions.addAll(list);
        }
        this.supportedRegions.remove(REGION_CODE_FOR_NON_GEO_ENTITY);
        this.nanpaRegions.addAll((Collection<String>)this.countryCallingCodeToRegionCodeMap.get(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMetadataFromFile(String string, String string2, int n) {
        boolean bl = REGION_CODE_FOR_NON_GEO_ENTITY.equals(string2);
        InputStream inputStream = bl ? PhoneNumberUtil.class.getResourceAsStream(string + "_" + n) : PhoneNumberUtil.class.getResourceAsStream(string + "_" + string2);
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(inputStream);
            Phonemetadata.PhoneMetadataCollection phoneMetadataCollection = new Phonemetadata.PhoneMetadataCollection();
            phoneMetadataCollection.readExternal(objectInputStream);
            for (Phonemetadata.PhoneMetadata phoneMetadata : phoneMetadataCollection.getMetadataList()) {
                if (bl) {
                    this.countryCodeToNonGeographicalMetadataMap.put(n, phoneMetadata);
                    continue;
                }
                this.regionToMetadataMap.put(string2, phoneMetadata);
            }
        }
        catch (IOException iOException) {
            try {
                LOGGER.log(Level.WARNING, iOException.toString());
            }
            catch (Throwable throwable) {
                PhoneNumberUtil.close(objectInputStream);
                throw throwable;
            }
            PhoneNumberUtil.close(objectInputStream);
        }
        PhoneNumberUtil.close(objectInputStream);
    }

    private static void close(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, iOException.toString());
            }
        }
    }

    static String extractPossibleNumber(String string) {
        Matcher matcher = VALID_START_CHAR_PATTERN.matcher(string);
        if (matcher.find()) {
            Matcher matcher2;
            Matcher matcher3 = UNWANTED_END_CHAR_PATTERN.matcher(string = string.substring(matcher.start()));
            if (matcher3.find()) {
                string = string.substring(0, matcher3.start());
                LOGGER.log(Level.FINER, "Stripped trailing characters: " + string);
            }
            if ((matcher2 = SECOND_NUMBER_START_PATTERN.matcher(string)).find()) {
                string = string.substring(0, matcher2.start());
            }
            return string;
        }
        return "";
    }

    static boolean isViablePhoneNumber(String string) {
        if (string.length() < 3) {
            return false;
        }
        Matcher matcher = VALID_PHONE_NUMBER_PATTERN.matcher(string);
        return matcher.matches();
    }

    static String normalize(String string) {
        Matcher matcher = VALID_ALPHA_PHONE_PATTERN.matcher(string);
        if (matcher.matches()) {
            return PhoneNumberUtil.normalizeHelper(string, ALPHA_PHONE_MAPPINGS, true);
        }
        return PhoneNumberUtil.normalizeDigitsOnly(string);
    }

    static void normalize(StringBuilder stringBuilder) {
        String string = PhoneNumberUtil.normalize(stringBuilder.toString());
        stringBuilder.replace(0, stringBuilder.length(), string);
    }

    public static String normalizeDigitsOnly(String string) {
        return PhoneNumberUtil.normalizeDigits(string, false).toString();
    }

    private static StringBuilder normalizeDigits(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (char c : string.toCharArray()) {
            int n = Character.digit(c, 10);
            if (n != -1) {
                stringBuilder.append(n);
                continue;
            }
            if (!bl) continue;
            stringBuilder.append(c);
        }
        return stringBuilder;
    }

    public static String convertAlphaCharactersInNumber(String string) {
        return PhoneNumberUtil.normalizeHelper(string, ALPHA_PHONE_MAPPINGS, false);
    }

    public int getLengthOfGeographicalAreaCode(Phonenumber.PhoneNumber phoneNumber) {
        String string = this.getRegionCodeForNumber(phoneNumber);
        if (!this.isValidRegionCode(string)) {
            return 0;
        }
        Phonemetadata.PhoneMetadata phoneMetadata = this.getMetadataForRegion(string);
        if (!phoneMetadata.hasNationalPrefix()) {
            return 0;
        }
        PhoneNumberType phoneNumberType = this.getNumberTypeHelper(this.getNationalSignificantNumber(phoneNumber), phoneMetadata);
        if (phoneNumberType != PhoneNumberType.FIXED_LINE && phoneNumberType != PhoneNumberType.FIXED_LINE_OR_MOBILE) {
            return 0;
        }
        return this.getLengthOfNationalDestinationCode(phoneNumber);
    }

    public int getLengthOfNationalDestinationCode(Phonenumber.PhoneNumber phoneNumber) {
        Phonenumber.PhoneNumber phoneNumber2;
        if (phoneNumber.hasExtension()) {
            phoneNumber2 = new Phonenumber.PhoneNumber();
            phoneNumber2.mergeFrom(phoneNumber);
            phoneNumber2.clearExtension();
        } else {
            phoneNumber2 = phoneNumber;
        }
        String string = this.format(phoneNumber2, PhoneNumberFormat.INTERNATIONAL);
        String[] stringArray = NON_DIGITS_PATTERN.split(string);
        if (stringArray.length <= 3) {
            return 0;
        }
        if (this.getRegionCodeForCountryCode(phoneNumber.getCountryCode()).equals("AR") && this.getNumberType(phoneNumber) == PhoneNumberType.MOBILE) {
            return stringArray[3].length() + 1;
        }
        return stringArray[2].length();
    }

    private static String normalizeHelper(String string, Map<Character, Character> map, boolean bl) {
        char[] cArray;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (char c : cArray = string.toCharArray()) {
            Character c2 = map.get(Character.valueOf(Character.toUpperCase(c)));
            if (c2 != null) {
                stringBuilder.append(c2);
                continue;
            }
            if (bl) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    static synchronized PhoneNumberUtil getInstance(String string, Map<Integer, List<String>> map) {
        if (instance == null) {
            instance = new PhoneNumberUtil();
            PhoneNumberUtil.instance.countryCallingCodeToRegionCodeMap = map;
            instance.init(string);
        }
        return instance;
    }

    static synchronized void resetInstance() {
        instance = null;
    }

    public Set<String> getSupportedRegions() {
        return this.supportedRegions;
    }

    public Set<Integer> getSupportedGlobalNetworkCallingCodes() {
        return this.countryCodeToNonGeographicalMetadataMap.keySet();
    }

    public static synchronized PhoneNumberUtil getInstance() {
        if (instance == null) {
            return PhoneNumberUtil.getInstance(META_DATA_FILE_PREFIX, CountryCodeToRegionCodeMap.getCountryCodeToRegionCodeMap());
        }
        return instance;
    }

    private boolean isValidRegionCode(String string) {
        return string != null && this.supportedRegions.contains(string);
    }

    private boolean hasValidCountryCallingCode(int n) {
        return this.countryCallingCodeToRegionCodeMap.containsKey(n);
    }

    public String format(Phonenumber.PhoneNumber phoneNumber, PhoneNumberFormat phoneNumberFormat) {
        CharSequence charSequence;
        if (phoneNumber.getNationalNumber() == 0L && phoneNumber.hasRawInput() && ((String)(charSequence = phoneNumber.getRawInput())).length() > 0) {
            return charSequence;
        }
        charSequence = new StringBuilder(20);
        this.format(phoneNumber, phoneNumberFormat, (StringBuilder)charSequence);
        return ((StringBuilder)charSequence).toString();
    }

    public void format(Phonenumber.PhoneNumber phoneNumber, PhoneNumberFormat phoneNumberFormat, StringBuilder stringBuilder) {
        stringBuilder.setLength(0);
        int n = phoneNumber.getCountryCode();
        String string = this.getNationalSignificantNumber(phoneNumber);
        if (phoneNumberFormat == PhoneNumberFormat.E164) {
            stringBuilder.append(string);
            this.prefixNumberWithCountryCallingCode(n, PhoneNumberFormat.E164, stringBuilder);
            return;
        }
        String string2 = this.getRegionCodeForCountryCode(n);
        if (!this.hasValidCountryCallingCode(n)) {
            stringBuilder.append(string);
            return;
        }
        Phonemetadata.PhoneMetadata phoneMetadata = this.getMetadataForRegionOrCallingCode(n, string2);
        stringBuilder.append(this.formatNsn(string, phoneMetadata, phoneNumberFormat));
        this.maybeAppendFormattedExtension(phoneNumber, phoneMetadata, phoneNumberFormat, stringBuilder);
        this.prefixNumberWithCountryCallingCode(n, phoneNumberFormat, stringBuilder);
    }

    public String formatByPattern(Phonenumber.PhoneNumber phoneNumber, PhoneNumberFormat phoneNumberFormat, List<Phonemetadata.NumberFormat> list) {
        int n = phoneNumber.getCountryCode();
        String string = this.getNationalSignificantNumber(phoneNumber);
        String string2 = this.getRegionCodeForCountryCode(n);
        if (!this.hasValidCountryCallingCode(n)) {
            return string;
        }
        Phonemetadata.PhoneMetadata phoneMetadata = this.getMetadataForRegionOrCallingCode(n, string2);
        StringBuilder stringBuilder = new StringBuilder(20);
        Phonemetadata.NumberFormat numberFormat = this.chooseFormattingPatternForNumber(list, string);
        if (numberFormat == null) {
            stringBuilder.append(string);
        } else {
            Phonemetadata.NumberFormat numberFormat2 = new Phonemetadata.NumberFormat();
            numberFormat2.mergeFrom(numberFormat);
            String string3 = numberFormat.getNationalPrefixFormattingRule();
            if (string3.length() > 0) {
                String string4 = phoneMetadata.getNationalPrefix();
                if (string4.length() > 0) {
                    string3 = NP_PATTERN.matcher(string3).replaceFirst(string4);
                    string3 = FG_PATTERN.matcher(string3).replaceFirst("\\$1");
                    numberFormat2.setNationalPrefixFormattingRule(string3);
                } else {
                    numberFormat2.clearNationalPrefixFormattingRule();
                }
            }
            stringBuilder.append(this.formatNsnUsingPattern(string, numberFormat2, phoneNumberFormat));
        }
        this.maybeAppendFormattedExtension(phoneNumber, phoneMetadata, phoneNumberFormat, stringBuilder);
        this.prefixNumberWithCountryCallingCode(n, phoneNumberFormat, stringBuilder);
        return stringBuilder.toString();
    }

    public String formatNationalNumberWithCarrierCode(Phonenumber.PhoneNumber phoneNumber, String string) {
        int n = phoneNumber.getCountryCode();
        String string2 = this.getNationalSignificantNumber(phoneNumber);
        String string3 = this.getRegionCodeForCountryCode(n);
        if (!this.hasValidCountryCallingCode(n)) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(20);
        Phonemetadata.PhoneMetadata phoneMetadata = this.getMetadataForRegionOrCallingCode(n, string3);
        stringBuilder.append(this.formatNsn(string2, phoneMetadata, PhoneNumberFormat.NATIONAL, string));
        this.maybeAppendFormattedExtension(phoneNumber, phoneMetadata, PhoneNumberFormat.NATIONAL, stringBuilder);
        this.prefixNumberWithCountryCallingCode(n, PhoneNumberFormat.NATIONAL, stringBuilder);
        return stringBuilder.toString();
    }

    private Phonemetadata.PhoneMetadata getMetadataForRegionOrCallingCode(int n, String string) {
        return REGION_CODE_FOR_NON_GEO_ENTITY.equals(string) ? this.getMetadataForNonGeographicalRegion(n) : this.getMetadataForRegion(string);
    }

    public String formatNationalNumberWithPreferredCarrierCode(Phonenumber.PhoneNumber phoneNumber, String string) {
        return this.formatNationalNumberWithCarrierCode(phoneNumber, phoneNumber.hasPreferredDomesticCarrierCode() ? phoneNumber.getPreferredDomesticCarrierCode() : string);
    }

    public String formatNumberForMobileDialing(Phonenumber.PhoneNumber phoneNumber, String string, boolean bl) {
        String string2;
        int n = phoneNumber.getCountryCode();
        if (!this.hasValidCountryCallingCode(n)) {
            return phoneNumber.hasRawInput() ? phoneNumber.getRawInput() : "";
        }
        Phonenumber.PhoneNumber phoneNumber2 = new Phonenumber.PhoneNumber().mergeFrom(phoneNumber).clearExtension();
        PhoneNumberType phoneNumberType = this.getNumberType(phoneNumber2);
        String string3 = this.getRegionCodeForCountryCode(n);
        if (string3.equals("CO") && string.equals("CO")) {
            string2 = phoneNumberType == PhoneNumberType.FIXED_LINE ? this.formatNationalNumberWithCarrierCode(phoneNumber2, COLOMBIA_MOBILE_TO_FIXED_LINE_PREFIX) : this.format(phoneNumber2, PhoneNumberFormat.NATIONAL);
        } else if (string3.equals("PE") && string.equals("PE")) {
            string2 = this.format(phoneNumber2, PhoneNumberFormat.NATIONAL);
        } else if (string3.equals("BR") && string.equals("BR") && (phoneNumberType == PhoneNumberType.FIXED_LINE || phoneNumberType == PhoneNumberType.MOBILE || phoneNumberType == PhoneNumberType.FIXED_LINE_OR_MOBILE)) {
            string2 = phoneNumber2.hasPreferredDomesticCarrierCode() ? this.formatNationalNumberWithPreferredCarrierCode(phoneNumber2, "") : "";
        } else {
            if (this.canBeInternationallyDialled(phoneNumber2)) {
                return bl ? this.format(phoneNumber2, PhoneNumberFormat.INTERNATIONAL) : this.format(phoneNumber2, PhoneNumberFormat.E164);
            }
            string2 = string.equals(string3) ? this.format(phoneNumber2, PhoneNumberFormat.NATIONAL) : "";
        }
        return bl ? string2 : PhoneNumberUtil.normalizeHelper(string2, DIALLABLE_CHAR_MAPPINGS, true);
    }

    public String formatOutOfCountryCallingNumber(Phonenumber.PhoneNumber phoneNumber, String string) {
        if (!this.isValidRegionCode(string)) {
            LOGGER.log(Level.WARNING, "Trying to format number from invalid region " + string + ". International formatting applied.");
            return this.format(phoneNumber, PhoneNumberFormat.INTERNATIONAL);
        }
        int n = phoneNumber.getCountryCode();
        String string2 = this.getNationalSignificantNumber(phoneNumber);
        if (!this.hasValidCountryCallingCode(n)) {
            return string2;
        }
        if (n == 1) {
            if (this.isNANPACountry(string)) {
                return n + " " + this.format(phoneNumber, PhoneNumberFormat.NATIONAL);
            }
        } else if (n == this.getCountryCodeForValidRegion(string)) {
            return this.format(phoneNumber, PhoneNumberFormat.NATIONAL);
        }
        Phonemetadata.PhoneMetadata phoneMetadata = this.getMetadataForRegion(string);
        String string3 = phoneMetadata.getInternationalPrefix();
        String string4 = "";
        if (UNIQUE_INTERNATIONAL_PREFIX.matcher(string3).matches()) {
            string4 = string3;
        } else if (phoneMetadata.hasPreferredInternationalPrefix()) {
            string4 = phoneMetadata.getPreferredInternationalPrefix();
        }
        String string5 = this.getRegionCodeForCountryCode(n);
        Phonemetadata.PhoneMetadata phoneMetadata2 = this.getMetadataForRegionOrCallingCode(n, string5);
        String string6 = this.formatNsn(string2, phoneMetadata2, PhoneNumberFormat.INTERNATIONAL);
        StringBuilder stringBuilder = new StringBuilder(string6);
        this.maybeAppendFormattedExtension(phoneNumber, phoneMetadata2, PhoneNumberFormat.INTERNATIONAL, stringBuilder);
        if (string4.length() > 0) {
            stringBuilder.insert(0, " ").insert(0, n).insert(0, " ").insert(0, string4);
        } else {
            this.prefixNumberWithCountryCallingCode(n, PhoneNumberFormat.INTERNATIONAL, stringBuilder);
        }
        return stringBuilder.toString();
    }

    public String formatInOriginalFormat(Phonenumber.PhoneNumber phoneNumber, String string) {
        String string2;
        String string3;
        if (phoneNumber.hasRawInput() && (this.hasUnexpectedItalianLeadingZero(phoneNumber) || !this.hasFormattingPatternForNumber(phoneNumber))) {
            return phoneNumber.getRawInput();
        }
        if (!phoneNumber.hasCountryCodeSource()) {
            return this.format(phoneNumber, PhoneNumberFormat.NATIONAL);
        }
        switch (phoneNumber.getCountryCodeSource()) {
            case FROM_NUMBER_WITH_PLUS_SIGN: {
                string3 = this.format(phoneNumber, PhoneNumberFormat.INTERNATIONAL);
                break;
            }
            case FROM_NUMBER_WITH_IDD: {
                string3 = this.formatOutOfCountryCallingNumber(phoneNumber, string);
                break;
            }
            case FROM_NUMBER_WITHOUT_PLUS_SIGN: {
                string3 = this.format(phoneNumber, PhoneNumberFormat.INTERNATIONAL).substring(1);
                break;
            }
            default: {
                string2 = this.getRegionCodeForCountryCode(phoneNumber.getCountryCode());
                String string4 = this.getNddPrefixForRegion(string2, true);
                String string5 = this.format(phoneNumber, PhoneNumberFormat.NATIONAL);
                if (string4 == null || string4.length() == 0) {
                    string3 = string5;
                    break;
                }
                if (this.rawInputContainsNationalPrefix(phoneNumber.getRawInput(), string4, string2)) {
                    string3 = string5;
                    break;
                }
                Phonemetadata.PhoneMetadata phoneMetadata = this.getMetadataForRegion(string2);
                String string6 = this.getNationalSignificantNumber(phoneNumber);
                Phonemetadata.NumberFormat numberFormat = this.chooseFormattingPatternForNumber(phoneMetadata.numberFormats(), string6);
                String string7 = numberFormat.getNationalPrefixFormattingRule();
                int n = string7.indexOf("$1");
                if (n <= 0) {
                    string3 = string5;
                    break;
                }
                string7 = string7.substring(0, n);
                if ((string7 = PhoneNumberUtil.normalizeDigitsOnly(string7)).length() == 0) {
                    string3 = string5;
                    break;
                }
                Phonemetadata.NumberFormat numberFormat2 = new Phonemetadata.NumberFormat();
                numberFormat2.mergeFrom(numberFormat);
                numberFormat2.clearNationalPrefixFormattingRule();
                ArrayList<Phonemetadata.NumberFormat> arrayList = new ArrayList<Phonemetadata.NumberFormat>(1);
                arrayList.add(numberFormat2);
                string3 = this.formatByPattern(phoneNumber, PhoneNumberFormat.NATIONAL, arrayList);
            }
        }
        string2 = phoneNumber.getRawInput();
        return string3 != null && PhoneNumberUtil.normalizeDigitsOnly(string3).equals(PhoneNumberUtil.normalizeDigitsOnly(string2)) ? string3 : string2;
    }

    private boolean rawInputContainsNationalPrefix(String string, String string2, String string3) {
        String string4 = PhoneNumberUtil.normalizeDigitsOnly(string);
        if (string4.startsWith(string2)) {
            try {
                return this.isValidNumber(this.parse(string4.substring(string2.length()), string3));
            }
            catch (NumberParseException numberParseException) {
                return false;
            }
        }
        return false;
    }

    private boolean hasUnexpectedItalianLeadingZero(Phonenumber.PhoneNumber phoneNumber) {
        return phoneNumber.isItalianLeadingZero() && !this.isLeadingZeroPossible(phoneNumber.getCountryCode());
    }

    private boolean hasFormattingPatternForNumber(Phonenumber.PhoneNumber phoneNumber) {
        String string;
        int n = phoneNumber.getCountryCode();
        Phonemetadata.PhoneMetadata phoneMetadata = this.getMetadataForRegionOrCallingCode(n, string = this.getRegionCodeForCountryCode(n));
        if (phoneMetadata == null) {
            return false;
        }
        String string2 = this.getNationalSignificantNumber(phoneNumber);
        Phonemetadata.NumberFormat numberFormat = this.chooseFormattingPatternForNumber(phoneMetadata.numberFormats(), string2);
        return numberFormat != null;
    }

    public String formatOutOfCountryKeepingAlphaChars(Phonenumber.PhoneNumber phoneNumber, String string) {
        CharSequence charSequence;
        int n;
        String string2 = phoneNumber.getRawInput();
        if (string2.length() == 0) {
            return this.formatOutOfCountryCallingNumber(phoneNumber, string);
        }
        int n2 = phoneNumber.getCountryCode();
        if (!this.hasValidCountryCallingCode(n2)) {
            return string2;
        }
        string2 = PhoneNumberUtil.normalizeHelper(string2, ALL_PLUS_NUMBER_GROUPING_SYMBOLS, true);
        String string3 = this.getNationalSignificantNumber(phoneNumber);
        if (string3.length() > 3 && (n = string2.indexOf(string3.substring(0, 3))) != -1) {
            string2 = string2.substring(n);
        }
        Phonemetadata.PhoneMetadata phoneMetadata = this.getMetadataForRegion(string);
        if (n2 == 1) {
            if (this.isNANPACountry(string)) {
                return n2 + " " + string2;
            }
        } else if (this.isValidRegionCode(string) && n2 == this.getCountryCodeForValidRegion(string)) {
            Phonemetadata.NumberFormat numberFormat = this.chooseFormattingPatternForNumber(phoneMetadata.numberFormats(), string3);
            if (numberFormat == null) {
                return string2;
            }
            Phonemetadata.NumberFormat numberFormat2 = new Phonemetadata.NumberFormat();
            numberFormat2.mergeFrom(numberFormat);
            numberFormat2.setPattern("(\\d+)(.*)");
            numberFormat2.setFormat("$1$2");
            return this.formatNsnUsingPattern(string2, numberFormat2, PhoneNumberFormat.NATIONAL);
        }
        String string4 = "";
        if (phoneMetadata != null) {
            charSequence = phoneMetadata.getInternationalPrefix();
            string4 = UNIQUE_INTERNATIONAL_PREFIX.matcher(charSequence).matches() ? charSequence : phoneMetadata.getPreferredInternationalPrefix();
        }
        charSequence = new StringBuilder(string2);
        String string5 = this.getRegionCodeForCountryCode(n2);
        Phonemetadata.PhoneMetadata phoneMetadata2 = this.getMetadataForRegionOrCallingCode(n2, string5);
        this.maybeAppendFormattedExtension(phoneNumber, phoneMetadata2, PhoneNumberFormat.INTERNATIONAL, (StringBuilder)charSequence);
        if (string4.length() > 0) {
            ((StringBuilder)charSequence).insert(0, " ").insert(0, n2).insert(0, " ").insert(0, string4);
        } else {
            this.prefixNumberWithCountryCallingCode(n2, PhoneNumberFormat.INTERNATIONAL, (StringBuilder)charSequence);
        }
        return ((StringBuilder)charSequence).toString();
    }

    public String getNationalSignificantNumber(Phonenumber.PhoneNumber phoneNumber) {
        StringBuilder stringBuilder = new StringBuilder(phoneNumber.isItalianLeadingZero() ? "0" : "");
        stringBuilder.append(phoneNumber.getNationalNumber());
        return stringBuilder.toString();
    }

    private void prefixNumberWithCountryCallingCode(int n, PhoneNumberFormat phoneNumberFormat, StringBuilder stringBuilder) {
        switch (phoneNumberFormat) {
            case E164: {
                stringBuilder.insert(0, n).insert(0, '+');
                return;
            }
            case INTERNATIONAL: {
                stringBuilder.insert(0, " ").insert(0, n).insert(0, '+');
                return;
            }
            case RFC3966: {
                stringBuilder.insert(0, "-").insert(0, n).insert(0, '+');
                return;
            }
        }
    }

    private String formatNsn(String string, Phonemetadata.PhoneMetadata phoneMetadata, PhoneNumberFormat phoneNumberFormat) {
        return this.formatNsn(string, phoneMetadata, phoneNumberFormat, null);
    }

    private String formatNsn(String string, Phonemetadata.PhoneMetadata phoneMetadata, PhoneNumberFormat phoneNumberFormat, String string2) {
        List<Phonemetadata.NumberFormat> list = phoneMetadata.intlNumberFormats();
        List<Phonemetadata.NumberFormat> list2 = list.size() == 0 || phoneNumberFormat == PhoneNumberFormat.NATIONAL ? phoneMetadata.numberFormats() : phoneMetadata.intlNumberFormats();
        Phonemetadata.NumberFormat numberFormat = this.chooseFormattingPatternForNumber(list2, string);
        return numberFormat == null ? string : this.formatNsnUsingPattern(string, numberFormat, phoneNumberFormat, string2);
    }

    private Phonemetadata.NumberFormat chooseFormattingPatternForNumber(List<Phonemetadata.NumberFormat> list, String string) {
        for (Phonemetadata.NumberFormat numberFormat : list) {
            Matcher matcher;
            int n = numberFormat.leadingDigitsPatternSize();
            if (n != 0 && !this.regexCache.getPatternForRegex(numberFormat.getLeadingDigitsPattern(n - 1)).matcher(string).lookingAt() || !(matcher = this.regexCache.getPatternForRegex(numberFormat.getPattern()).matcher(string)).matches()) continue;
            return numberFormat;
        }
        return null;
    }

    private String formatNsnUsingPattern(String string, Phonemetadata.NumberFormat numberFormat, PhoneNumberFormat phoneNumberFormat) {
        return this.formatNsnUsingPattern(string, numberFormat, phoneNumberFormat, null);
    }

    private String formatNsnUsingPattern(String string, Phonemetadata.NumberFormat numberFormat, PhoneNumberFormat phoneNumberFormat, String string2) {
        Object object;
        String string3 = numberFormat.getFormat();
        Matcher matcher = this.regexCache.getPatternForRegex(numberFormat.getPattern()).matcher(string);
        String string4 = "";
        if (phoneNumberFormat == PhoneNumberFormat.NATIONAL && string2 != null && string2.length() > 0 && numberFormat.getDomesticCarrierCodeFormattingRule().length() > 0) {
            object = numberFormat.getDomesticCarrierCodeFormattingRule();
            object = CC_PATTERN.matcher((CharSequence)object).replaceFirst(string2);
            string3 = FIRST_GROUP_PATTERN.matcher(string3).replaceFirst((String)object);
            string4 = matcher.replaceAll(string3);
        } else {
            object = numberFormat.getNationalPrefixFormattingRule();
            if (phoneNumberFormat == PhoneNumberFormat.NATIONAL && object != null && ((String)object).length() > 0) {
                Matcher matcher2 = FIRST_GROUP_PATTERN.matcher(string3);
                string4 = matcher.replaceAll(matcher2.replaceFirst((String)object));
            } else {
                string4 = matcher.replaceAll(string3);
            }
        }
        if (phoneNumberFormat == PhoneNumberFormat.RFC3966) {
            object = SEPARATOR_PATTERN.matcher(string4);
            if (((Matcher)object).lookingAt()) {
                string4 = ((Matcher)object).replaceFirst("");
            }
            string4 = ((Matcher)object).reset(string4).replaceAll("-");
        }
        return string4;
    }

    public Phonenumber.PhoneNumber getExampleNumber(String string) {
        return this.getExampleNumberForType(string, PhoneNumberType.FIXED_LINE);
    }

    public Phonenumber.PhoneNumber getExampleNumberForType(String string, PhoneNumberType phoneNumberType) {
        if (!this.isValidRegionCode(string)) {
            LOGGER.log(Level.WARNING, "Invalid or unknown region code provided: " + string);
            return null;
        }
        Phonemetadata.PhoneNumberDesc phoneNumberDesc = this.getNumberDescByType(this.getMetadataForRegion(string), phoneNumberType);
        try {
            if (phoneNumberDesc.hasExampleNumber()) {
                return this.parse(phoneNumberDesc.getExampleNumber(), string);
            }
        }
        catch (NumberParseException numberParseException) {
            LOGGER.log(Level.SEVERE, numberParseException.toString());
        }
        return null;
    }

    public Phonenumber.PhoneNumber getExampleNumberForNonGeoEntity(int n) {
        Phonemetadata.PhoneMetadata phoneMetadata = this.getMetadataForNonGeographicalRegion(n);
        if (phoneMetadata != null) {
            Phonemetadata.PhoneNumberDesc phoneNumberDesc = phoneMetadata.getGeneralDesc();
            try {
                if (phoneNumberDesc.hasExampleNumber()) {
                    return this.parse("+" + n + phoneNumberDesc.getExampleNumber(), UNKNOWN_REGION);
                }
            }
            catch (NumberParseException numberParseException) {
                LOGGER.log(Level.SEVERE, numberParseException.toString());
            }
        } else {
            LOGGER.log(Level.WARNING, "Invalid or unknown country calling code provided: " + n);
        }
        return null;
    }

    private void maybeAppendFormattedExtension(Phonenumber.PhoneNumber phoneNumber, Phonemetadata.PhoneMetadata phoneMetadata, PhoneNumberFormat phoneNumberFormat, StringBuilder stringBuilder) {
        if (phoneNumber.hasExtension() && phoneNumber.getExtension().length() > 0) {
            if (phoneNumberFormat == PhoneNumberFormat.RFC3966) {
                stringBuilder.append(RFC3966_EXTN_PREFIX).append(phoneNumber.getExtension());
            } else if (phoneMetadata.hasPreferredExtnPrefix()) {
                stringBuilder.append(phoneMetadata.getPreferredExtnPrefix()).append(phoneNumber.getExtension());
            } else {
                stringBuilder.append(DEFAULT_EXTN_PREFIX).append(phoneNumber.getExtension());
            }
        }
    }

    Phonemetadata.PhoneNumberDesc getNumberDescByType(Phonemetadata.PhoneMetadata phoneMetadata, PhoneNumberType phoneNumberType) {
        switch (phoneNumberType) {
            case PREMIUM_RATE: {
                return phoneMetadata.getPremiumRate();
            }
            case TOLL_FREE: {
                return phoneMetadata.getTollFree();
            }
            case MOBILE: {
                return phoneMetadata.getMobile();
            }
            case FIXED_LINE: 
            case FIXED_LINE_OR_MOBILE: {
                return phoneMetadata.getFixedLine();
            }
            case SHARED_COST: {
                return phoneMetadata.getSharedCost();
            }
            case VOIP: {
                return phoneMetadata.getVoip();
            }
            case PERSONAL_NUMBER: {
                return phoneMetadata.getPersonalNumber();
            }
            case PAGER: {
                return phoneMetadata.getPager();
            }
            case UAN: {
                return phoneMetadata.getUan();
            }
            case VOICEMAIL: {
                return phoneMetadata.getVoicemail();
            }
        }
        return phoneMetadata.getGeneralDesc();
    }

    public PhoneNumberType getNumberType(Phonenumber.PhoneNumber phoneNumber) {
        String string = this.getRegionCodeForNumber(phoneNumber);
        if (!this.isValidRegionCode(string) && !REGION_CODE_FOR_NON_GEO_ENTITY.equals(string)) {
            return PhoneNumberType.UNKNOWN;
        }
        String string2 = this.getNationalSignificantNumber(phoneNumber);
        Phonemetadata.PhoneMetadata phoneMetadata = this.getMetadataForRegionOrCallingCode(phoneNumber.getCountryCode(), string);
        return this.getNumberTypeHelper(string2, phoneMetadata);
    }

    private PhoneNumberType getNumberTypeHelper(String string, Phonemetadata.PhoneMetadata phoneMetadata) {
        Phonemetadata.PhoneNumberDesc phoneNumberDesc = phoneMetadata.getGeneralDesc();
        if (!phoneNumberDesc.hasNationalNumberPattern() || !this.isNumberMatchingDesc(string, phoneNumberDesc)) {
            return PhoneNumberType.UNKNOWN;
        }
        if (this.isNumberMatchingDesc(string, phoneMetadata.getPremiumRate())) {
            return PhoneNumberType.PREMIUM_RATE;
        }
        if (this.isNumberMatchingDesc(string, phoneMetadata.getTollFree())) {
            return PhoneNumberType.TOLL_FREE;
        }
        if (this.isNumberMatchingDesc(string, phoneMetadata.getSharedCost())) {
            return PhoneNumberType.SHARED_COST;
        }
        if (this.isNumberMatchingDesc(string, phoneMetadata.getVoip())) {
            return PhoneNumberType.VOIP;
        }
        if (this.isNumberMatchingDesc(string, phoneMetadata.getPersonalNumber())) {
            return PhoneNumberType.PERSONAL_NUMBER;
        }
        if (this.isNumberMatchingDesc(string, phoneMetadata.getPager())) {
            return PhoneNumberType.PAGER;
        }
        if (this.isNumberMatchingDesc(string, phoneMetadata.getUan())) {
            return PhoneNumberType.UAN;
        }
        if (this.isNumberMatchingDesc(string, phoneMetadata.getVoicemail())) {
            return PhoneNumberType.VOICEMAIL;
        }
        boolean bl = this.isNumberMatchingDesc(string, phoneMetadata.getFixedLine());
        if (bl) {
            if (phoneMetadata.isSameMobileAndFixedLinePattern()) {
                return PhoneNumberType.FIXED_LINE_OR_MOBILE;
            }
            if (this.isNumberMatchingDesc(string, phoneMetadata.getMobile())) {
                return PhoneNumberType.FIXED_LINE_OR_MOBILE;
            }
            return PhoneNumberType.FIXED_LINE;
        }
        if (!phoneMetadata.isSameMobileAndFixedLinePattern() && this.isNumberMatchingDesc(string, phoneMetadata.getMobile())) {
            return PhoneNumberType.MOBILE;
        }
        return PhoneNumberType.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Phonemetadata.PhoneMetadata getMetadataForRegion(String string) {
        if (!this.isValidRegionCode(string)) {
            return null;
        }
        Map<String, Phonemetadata.PhoneMetadata> map = this.regionToMetadataMap;
        synchronized (map) {
            if (!this.regionToMetadataMap.containsKey(string)) {
                this.loadMetadataFromFile(this.currentFilePrefix, string, 0);
            }
        }
        return this.regionToMetadataMap.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Phonemetadata.PhoneMetadata getMetadataForNonGeographicalRegion(int n) {
        Map<Integer, Phonemetadata.PhoneMetadata> map = this.countryCodeToNonGeographicalMetadataMap;
        synchronized (map) {
            if (!this.countryCallingCodeToRegionCodeMap.containsKey(n)) {
                return null;
            }
            if (!this.countryCodeToNonGeographicalMetadataMap.containsKey(n)) {
                this.loadMetadataFromFile(this.currentFilePrefix, REGION_CODE_FOR_NON_GEO_ENTITY, n);
            }
        }
        return this.countryCodeToNonGeographicalMetadataMap.get(n);
    }

    private boolean isNumberMatchingDesc(String string, Phonemetadata.PhoneNumberDesc phoneNumberDesc) {
        Matcher matcher = this.regexCache.getPatternForRegex(phoneNumberDesc.getPossibleNumberPattern()).matcher(string);
        Matcher matcher2 = this.regexCache.getPatternForRegex(phoneNumberDesc.getNationalNumberPattern()).matcher(string);
        return matcher.matches() && matcher2.matches();
    }

    public boolean isValidNumber(Phonenumber.PhoneNumber phoneNumber) {
        String string = this.getRegionCodeForNumber(phoneNumber);
        return this.isValidNumberForRegion(phoneNumber, string);
    }

    public boolean isValidNumberForRegion(Phonenumber.PhoneNumber phoneNumber, String string) {
        int n = phoneNumber.getCountryCode();
        Phonemetadata.PhoneMetadata phoneMetadata = this.getMetadataForRegionOrCallingCode(n, string);
        if (phoneMetadata == null || !REGION_CODE_FOR_NON_GEO_ENTITY.equals(string) && n != this.getCountryCodeForValidRegion(string)) {
            return false;
        }
        Phonemetadata.PhoneNumberDesc phoneNumberDesc = phoneMetadata.getGeneralDesc();
        String string2 = this.getNationalSignificantNumber(phoneNumber);
        if (!phoneNumberDesc.hasNationalNumberPattern()) {
            int n2 = string2.length();
            return n2 > 3 && n2 <= 16;
        }
        return this.getNumberTypeHelper(string2, phoneMetadata) != PhoneNumberType.UNKNOWN;
    }

    public String getRegionCodeForNumber(Phonenumber.PhoneNumber phoneNumber) {
        int n = phoneNumber.getCountryCode();
        List<String> list = this.countryCallingCodeToRegionCodeMap.get(n);
        if (list == null) {
            String string = this.getNationalSignificantNumber(phoneNumber);
            LOGGER.log(Level.WARNING, "Missing/invalid country_code (" + n + ") for number " + string);
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        return this.getRegionCodeForNumberFromRegionList(phoneNumber, list);
    }

    private String getRegionCodeForNumberFromRegionList(Phonenumber.PhoneNumber phoneNumber, List<String> list) {
        String string = this.getNationalSignificantNumber(phoneNumber);
        for (String string2 : list) {
            Phonemetadata.PhoneMetadata phoneMetadata = this.getMetadataForRegion(string2);
            if (!(phoneMetadata.hasLeadingDigits() ? this.regexCache.getPatternForRegex(phoneMetadata.getLeadingDigits()).matcher(string).lookingAt() : this.getNumberTypeHelper(string, phoneMetadata) != PhoneNumberType.UNKNOWN)) continue;
            return string2;
        }
        return null;
    }

    public String getRegionCodeForCountryCode(int n) {
        List<String> list = this.countryCallingCodeToRegionCodeMap.get(n);
        return list == null ? UNKNOWN_REGION : list.get(0);
    }

    public int getCountryCodeForRegion(String string) {
        if (!this.isValidRegionCode(string)) {
            LOGGER.log(Level.WARNING, "Invalid or missing region code (" + (string == null ? "null" : string) + ") provided.");
            return 0;
        }
        return this.getCountryCodeForValidRegion(string);
    }

    private int getCountryCodeForValidRegion(String string) {
        Phonemetadata.PhoneMetadata phoneMetadata = this.getMetadataForRegion(string);
        return phoneMetadata.getCountryCode();
    }

    public String getNddPrefixForRegion(String string, boolean bl) {
        if (!this.isValidRegionCode(string)) {
            LOGGER.log(Level.WARNING, "Invalid or missing region code (" + (string == null ? "null" : string) + ") provided.");
            return null;
        }
        Phonemetadata.PhoneMetadata phoneMetadata = this.getMetadataForRegion(string);
        String string2 = phoneMetadata.getNationalPrefix();
        if (string2.length() == 0) {
            return null;
        }
        if (bl) {
            string2 = string2.replace("~", "");
        }
        return string2;
    }

    public boolean isNANPACountry(String string) {
        return this.nanpaRegions.contains(string);
    }

    boolean isLeadingZeroPossible(int n) {
        Phonemetadata.PhoneMetadata phoneMetadata = this.getMetadataForRegion(this.getRegionCodeForCountryCode(n));
        if (phoneMetadata == null) {
            return false;
        }
        return phoneMetadata.isLeadingZeroPossible();
    }

    public boolean isAlphaNumber(String string) {
        if (!PhoneNumberUtil.isViablePhoneNumber(string)) {
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        this.maybeStripExtension(stringBuilder);
        return VALID_ALPHA_PHONE_PATTERN.matcher(stringBuilder).matches();
    }

    public boolean isPossibleNumber(Phonenumber.PhoneNumber phoneNumber) {
        return this.isPossibleNumberWithReason(phoneNumber) == ValidationResult.IS_POSSIBLE;
    }

    private ValidationResult testNumberLengthAgainstPattern(Pattern pattern, String string) {
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            return ValidationResult.IS_POSSIBLE;
        }
        if (matcher.lookingAt()) {
            return ValidationResult.TOO_LONG;
        }
        return ValidationResult.TOO_SHORT;
    }

    public ValidationResult isPossibleNumberWithReason(Phonenumber.PhoneNumber phoneNumber) {
        String string = this.getNationalSignificantNumber(phoneNumber);
        int n = phoneNumber.getCountryCode();
        if (!this.hasValidCountryCallingCode(n)) {
            return ValidationResult.INVALID_COUNTRY_CODE;
        }
        String string2 = this.getRegionCodeForCountryCode(n);
        Phonemetadata.PhoneMetadata phoneMetadata = this.getMetadataForRegionOrCallingCode(n, string2);
        Phonemetadata.PhoneNumberDesc phoneNumberDesc = phoneMetadata.getGeneralDesc();
        if (!phoneNumberDesc.hasNationalNumberPattern()) {
            LOGGER.log(Level.FINER, "Checking if number is possible with incomplete metadata.");
            int n2 = string.length();
            if (n2 < 3) {
                return ValidationResult.TOO_SHORT;
            }
            if (n2 > 16) {
                return ValidationResult.TOO_LONG;
            }
            return ValidationResult.IS_POSSIBLE;
        }
        Pattern pattern = this.regexCache.getPatternForRegex(phoneNumberDesc.getPossibleNumberPattern());
        return this.testNumberLengthAgainstPattern(pattern, string);
    }

    public boolean isPossibleNumber(String string, String string2) {
        try {
            return this.isPossibleNumber(this.parse(string, string2));
        }
        catch (NumberParseException numberParseException) {
            return false;
        }
    }

    public boolean truncateTooLongNumber(Phonenumber.PhoneNumber phoneNumber) {
        if (this.isValidNumber(phoneNumber)) {
            return true;
        }
        Phonenumber.PhoneNumber phoneNumber2 = new Phonenumber.PhoneNumber();
        phoneNumber2.mergeFrom(phoneNumber);
        long l = phoneNumber.getNationalNumber();
        do {
            phoneNumber2.setNationalNumber(l /= 10L);
            if (this.isPossibleNumberWithReason(phoneNumber2) != ValidationResult.TOO_SHORT && l != 0L) continue;
            return false;
        } while (!this.isValidNumber(phoneNumber2));
        phoneNumber.setNationalNumber(l);
        return true;
    }

    public AsYouTypeFormatter getAsYouTypeFormatter(String string) {
        return new AsYouTypeFormatter(string);
    }

    int extractCountryCode(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        if (stringBuilder.length() == 0 || stringBuilder.charAt(0) == '0') {
            return 0;
        }
        int n = stringBuilder.length();
        for (int i = 1; i <= 3 && i <= n; ++i) {
            int n2 = Integer.parseInt(stringBuilder.substring(0, i));
            if (!this.countryCallingCodeToRegionCodeMap.containsKey(n2)) continue;
            stringBuilder2.append(stringBuilder.substring(i));
            return n2;
        }
        return 0;
    }

    int maybeExtractCountryCode(String string, Phonemetadata.PhoneMetadata phoneMetadata, StringBuilder stringBuilder, boolean bl, Phonenumber.PhoneNumber phoneNumber) throws NumberParseException {
        if (string.length() == 0) {
            return 0;
        }
        StringBuilder stringBuilder2 = new StringBuilder(string);
        String string2 = "NonMatch";
        if (phoneMetadata != null) {
            string2 = phoneMetadata.getInternationalPrefix();
        }
        Phonenumber.PhoneNumber.CountryCodeSource countryCodeSource = this.maybeStripInternationalPrefixAndNormalize(stringBuilder2, string2);
        if (bl) {
            phoneNumber.setCountryCodeSource(countryCodeSource);
        }
        if (countryCodeSource != Phonenumber.PhoneNumber.CountryCodeSource.FROM_DEFAULT_COUNTRY) {
            if (stringBuilder2.length() < 3) {
                throw new NumberParseException(NumberParseException.ErrorType.TOO_SHORT_AFTER_IDD, "Phone number had an IDD, but after this was not long enough to be a viable phone number.");
            }
            int n = this.extractCountryCode(stringBuilder2, stringBuilder);
            if (n != 0) {
                phoneNumber.setCountryCode(n);
                return n;
            }
            throw new NumberParseException(NumberParseException.ErrorType.INVALID_COUNTRY_CODE, "Country calling code supplied was not recognised.");
        }
        if (phoneMetadata != null) {
            int n = phoneMetadata.getCountryCode();
            String string3 = String.valueOf(n);
            String string4 = stringBuilder2.toString();
            if (string4.startsWith(string3)) {
                StringBuilder stringBuilder3 = new StringBuilder(string4.substring(string3.length()));
                Phonemetadata.PhoneNumberDesc phoneNumberDesc = phoneMetadata.getGeneralDesc();
                Pattern pattern = this.regexCache.getPatternForRegex(phoneNumberDesc.getNationalNumberPattern());
                this.maybeStripNationalPrefixAndCarrierCode(stringBuilder3, phoneMetadata, null);
                Pattern pattern2 = this.regexCache.getPatternForRegex(phoneNumberDesc.getPossibleNumberPattern());
                if (!pattern.matcher(stringBuilder2).matches() && pattern.matcher(stringBuilder3).matches() || this.testNumberLengthAgainstPattern(pattern2, stringBuilder2.toString()) == ValidationResult.TOO_LONG) {
                    stringBuilder.append((CharSequence)stringBuilder3);
                    if (bl) {
                        phoneNumber.setCountryCodeSource(Phonenumber.PhoneNumber.CountryCodeSource.FROM_NUMBER_WITHOUT_PLUS_SIGN);
                    }
                    phoneNumber.setCountryCode(n);
                    return n;
                }
            }
        }
        phoneNumber.setCountryCode(0);
        return 0;
    }

    private boolean parsePrefixAsIdd(Pattern pattern, StringBuilder stringBuilder) {
        Matcher matcher = pattern.matcher(stringBuilder);
        if (matcher.lookingAt()) {
            String string;
            int n = matcher.end();
            Matcher matcher2 = CAPTURING_DIGIT_PATTERN.matcher(stringBuilder.substring(n));
            if (matcher2.find() && (string = PhoneNumberUtil.normalizeDigitsOnly(matcher2.group(1))).equals("0")) {
                return false;
            }
            stringBuilder.delete(0, n);
            return true;
        }
        return false;
    }

    Phonenumber.PhoneNumber.CountryCodeSource maybeStripInternationalPrefixAndNormalize(StringBuilder stringBuilder, String string) {
        if (stringBuilder.length() == 0) {
            return Phonenumber.PhoneNumber.CountryCodeSource.FROM_DEFAULT_COUNTRY;
        }
        Matcher matcher = PLUS_CHARS_PATTERN.matcher(stringBuilder);
        if (matcher.lookingAt()) {
            stringBuilder.delete(0, matcher.end());
            PhoneNumberUtil.normalize(stringBuilder);
            return Phonenumber.PhoneNumber.CountryCodeSource.FROM_NUMBER_WITH_PLUS_SIGN;
        }
        Pattern pattern = this.regexCache.getPatternForRegex(string);
        PhoneNumberUtil.normalize(stringBuilder);
        return this.parsePrefixAsIdd(pattern, stringBuilder) ? Phonenumber.PhoneNumber.CountryCodeSource.FROM_NUMBER_WITH_IDD : Phonenumber.PhoneNumber.CountryCodeSource.FROM_DEFAULT_COUNTRY;
    }

    boolean maybeStripNationalPrefixAndCarrierCode(StringBuilder stringBuilder, Phonemetadata.PhoneMetadata phoneMetadata, StringBuilder stringBuilder2) {
        int n = stringBuilder.length();
        String string = phoneMetadata.getNationalPrefixForParsing();
        if (n == 0 || string.length() == 0) {
            return false;
        }
        Matcher matcher = this.regexCache.getPatternForRegex(string).matcher(stringBuilder);
        if (matcher.lookingAt()) {
            Pattern pattern = this.regexCache.getPatternForRegex(phoneMetadata.getGeneralDesc().getNationalNumberPattern());
            boolean bl = pattern.matcher(stringBuilder).matches();
            int n2 = matcher.groupCount();
            String string2 = phoneMetadata.getNationalPrefixTransformRule();
            if (string2 == null || string2.length() == 0 || matcher.group(n2) == null) {
                if (bl && !pattern.matcher(stringBuilder.substring(matcher.end())).matches()) {
                    return false;
                }
                if (stringBuilder2 != null && n2 > 0 && matcher.group(n2) != null) {
                    stringBuilder2.append(matcher.group(1));
                }
                stringBuilder.delete(0, matcher.end());
                return true;
            }
            StringBuilder stringBuilder3 = new StringBuilder(stringBuilder);
            stringBuilder3.replace(0, n, matcher.replaceFirst(string2));
            if (bl && !pattern.matcher(stringBuilder3.toString()).matches()) {
                return false;
            }
            if (stringBuilder2 != null && n2 > 1) {
                stringBuilder2.append(matcher.group(1));
            }
            stringBuilder.replace(0, stringBuilder.length(), stringBuilder3.toString());
            return true;
        }
        return false;
    }

    String maybeStripExtension(StringBuilder stringBuilder) {
        Matcher matcher = EXTN_PATTERN.matcher(stringBuilder);
        if (matcher.find() && PhoneNumberUtil.isViablePhoneNumber(stringBuilder.substring(0, matcher.start()))) {
            int n = matcher.groupCount();
            for (int i = 1; i <= n; ++i) {
                if (matcher.group(i) == null) continue;
                String string = matcher.group(i);
                stringBuilder.delete(matcher.start(), stringBuilder.length());
                return string;
            }
        }
        return "";
    }

    private boolean checkRegionForParsing(String string, String string2) {
        return this.isValidRegionCode(string2) || string != null && string.length() != 0 && PLUS_CHARS_PATTERN.matcher(string).lookingAt();
    }

    public Phonenumber.PhoneNumber parse(String string, String string2) throws NumberParseException {
        Phonenumber.PhoneNumber phoneNumber = new Phonenumber.PhoneNumber();
        this.parse(string, string2, phoneNumber);
        return phoneNumber;
    }

    public void parse(String string, String string2, Phonenumber.PhoneNumber phoneNumber) throws NumberParseException {
        this.parseHelper(string, string2, false, true, phoneNumber);
    }

    public Phonenumber.PhoneNumber parseAndKeepRawInput(String string, String string2) throws NumberParseException {
        Phonenumber.PhoneNumber phoneNumber = new Phonenumber.PhoneNumber();
        this.parseAndKeepRawInput(string, string2, phoneNumber);
        return phoneNumber;
    }

    public void parseAndKeepRawInput(String string, String string2, Phonenumber.PhoneNumber phoneNumber) throws NumberParseException {
        this.parseHelper(string, string2, true, true, phoneNumber);
    }

    public Iterable<PhoneNumberMatch> findNumbers(CharSequence charSequence, String string) {
        return this.findNumbers(charSequence, string, Leniency.VALID, Long.MAX_VALUE);
    }

    public Iterable<PhoneNumberMatch> findNumbers(final CharSequence charSequence, final String string, final Leniency leniency, final long l) {
        return new Iterable<PhoneNumberMatch>(){

            @Override
            public Iterator<PhoneNumberMatch> iterator() {
                return new PhoneNumberMatcher(PhoneNumberUtil.this, charSequence, string, leniency, l);
            }
        };
    }

    private void parseHelper(String string, String string2, boolean bl, boolean bl2, Phonenumber.PhoneNumber phoneNumber) throws NumberParseException {
        int n;
        CharSequence charSequence;
        StringBuilder stringBuilder;
        String string3;
        if (string == null) {
            throw new NumberParseException(NumberParseException.ErrorType.NOT_A_NUMBER, "The phone number supplied was null.");
        }
        String string4 = PhoneNumberUtil.extractPossibleNumber(string);
        if (!PhoneNumberUtil.isViablePhoneNumber(string4)) {
            throw new NumberParseException(NumberParseException.ErrorType.NOT_A_NUMBER, "The string supplied did not seem to be a phone number.");
        }
        if (bl2 && !this.checkRegionForParsing(string4, string2)) {
            throw new NumberParseException(NumberParseException.ErrorType.INVALID_COUNTRY_CODE, "Missing or invalid default region.");
        }
        if (bl) {
            phoneNumber.setRawInput(string);
        }
        if ((string3 = this.maybeStripExtension(stringBuilder = new StringBuilder(string4))).length() > 0) {
            phoneNumber.setExtension(string3);
        }
        Phonemetadata.PhoneMetadata phoneMetadata = this.getMetadataForRegion(string2);
        StringBuilder stringBuilder2 = new StringBuilder();
        int n2 = 0;
        try {
            n2 = this.maybeExtractCountryCode(stringBuilder.toString(), phoneMetadata, stringBuilder2, bl, phoneNumber);
        }
        catch (NumberParseException numberParseException) {
            Matcher matcher = PLUS_CHARS_PATTERN.matcher(stringBuilder.toString());
            if (numberParseException.getErrorType() == NumberParseException.ErrorType.INVALID_COUNTRY_CODE && matcher.lookingAt()) {
                n2 = this.maybeExtractCountryCode(stringBuilder.substring(matcher.end()), phoneMetadata, stringBuilder2, bl, phoneNumber);
                if (n2 == 0) {
                    throw new NumberParseException(NumberParseException.ErrorType.INVALID_COUNTRY_CODE, "Could not interpret numbers after plus-sign.");
                }
            }
            throw new NumberParseException(numberParseException.getErrorType(), numberParseException.getMessage());
        }
        if (n2 != 0) {
            charSequence = this.getRegionCodeForCountryCode(n2);
            if (!((String)charSequence).equals(string2)) {
                phoneMetadata = this.getMetadataForRegionOrCallingCode(n2, (String)charSequence);
            }
        } else {
            PhoneNumberUtil.normalize(stringBuilder);
            stringBuilder2.append((CharSequence)stringBuilder);
            if (string2 != null) {
                n2 = phoneMetadata.getCountryCode();
                phoneNumber.setCountryCode(n2);
            } else if (bl) {
                phoneNumber.clearCountryCodeSource();
            }
        }
        if (stringBuilder2.length() < 3) {
            throw new NumberParseException(NumberParseException.ErrorType.TOO_SHORT_NSN, "The string supplied is too short to be a phone number.");
        }
        if (phoneMetadata != null) {
            charSequence = new StringBuilder();
            this.maybeStripNationalPrefixAndCarrierCode(stringBuilder2, phoneMetadata, (StringBuilder)charSequence);
            if (bl) {
                phoneNumber.setPreferredDomesticCarrierCode(((StringBuilder)charSequence).toString());
            }
        }
        if ((n = stringBuilder2.length()) < 3) {
            throw new NumberParseException(NumberParseException.ErrorType.TOO_SHORT_NSN, "The string supplied is too short to be a phone number.");
        }
        if (n > 16) {
            throw new NumberParseException(NumberParseException.ErrorType.TOO_LONG, "The string supplied is too long to be a phone number.");
        }
        if (stringBuilder2.charAt(0) == '0') {
            phoneNumber.setItalianLeadingZero(true);
        }
        phoneNumber.setNationalNumber(Long.parseLong(stringBuilder2.toString()));
    }

    public MatchType isNumberMatch(Phonenumber.PhoneNumber phoneNumber, Phonenumber.PhoneNumber phoneNumber2) {
        Phonenumber.PhoneNumber phoneNumber3 = new Phonenumber.PhoneNumber();
        phoneNumber3.mergeFrom(phoneNumber);
        Phonenumber.PhoneNumber phoneNumber4 = new Phonenumber.PhoneNumber();
        phoneNumber4.mergeFrom(phoneNumber2);
        phoneNumber3.clearRawInput();
        phoneNumber3.clearCountryCodeSource();
        phoneNumber3.clearPreferredDomesticCarrierCode();
        phoneNumber4.clearRawInput();
        phoneNumber4.clearCountryCodeSource();
        phoneNumber4.clearPreferredDomesticCarrierCode();
        if (phoneNumber3.hasExtension() && phoneNumber3.getExtension().length() == 0) {
            phoneNumber3.clearExtension();
        }
        if (phoneNumber4.hasExtension() && phoneNumber4.getExtension().length() == 0) {
            phoneNumber4.clearExtension();
        }
        if (phoneNumber3.hasExtension() && phoneNumber4.hasExtension() && !phoneNumber3.getExtension().equals(phoneNumber4.getExtension())) {
            return MatchType.NO_MATCH;
        }
        int n = phoneNumber3.getCountryCode();
        int n2 = phoneNumber4.getCountryCode();
        if (n != 0 && n2 != 0) {
            if (phoneNumber3.exactlySameAs(phoneNumber4)) {
                return MatchType.EXACT_MATCH;
            }
            if (n == n2 && this.isNationalNumberSuffixOfTheOther(phoneNumber3, phoneNumber4)) {
                return MatchType.SHORT_NSN_MATCH;
            }
            return MatchType.NO_MATCH;
        }
        phoneNumber3.setCountryCode(n2);
        if (phoneNumber3.exactlySameAs(phoneNumber4)) {
            return MatchType.NSN_MATCH;
        }
        if (this.isNationalNumberSuffixOfTheOther(phoneNumber3, phoneNumber4)) {
            return MatchType.SHORT_NSN_MATCH;
        }
        return MatchType.NO_MATCH;
    }

    private boolean isNationalNumberSuffixOfTheOther(Phonenumber.PhoneNumber phoneNumber, Phonenumber.PhoneNumber phoneNumber2) {
        String string;
        String string2 = String.valueOf(phoneNumber.getNationalNumber());
        return string2.endsWith(string = String.valueOf(phoneNumber2.getNationalNumber())) || string.endsWith(string2);
    }

    public MatchType isNumberMatch(String string, String string2) {
        try {
            Phonenumber.PhoneNumber phoneNumber = this.parse(string, UNKNOWN_REGION);
            return this.isNumberMatch(phoneNumber, string2);
        }
        catch (NumberParseException numberParseException) {
            block7: {
                if (numberParseException.getErrorType() == NumberParseException.ErrorType.INVALID_COUNTRY_CODE) {
                    try {
                        Phonenumber.PhoneNumber phoneNumber = this.parse(string2, UNKNOWN_REGION);
                        return this.isNumberMatch(phoneNumber, string);
                    }
                    catch (NumberParseException numberParseException2) {
                        if (numberParseException2.getErrorType() != NumberParseException.ErrorType.INVALID_COUNTRY_CODE) break block7;
                        try {
                            Phonenumber.PhoneNumber phoneNumber = new Phonenumber.PhoneNumber();
                            Phonenumber.PhoneNumber phoneNumber2 = new Phonenumber.PhoneNumber();
                            this.parseHelper(string, null, false, false, phoneNumber);
                            this.parseHelper(string2, null, false, false, phoneNumber2);
                            return this.isNumberMatch(phoneNumber, phoneNumber2);
                        }
                        catch (NumberParseException numberParseException3) {
                            // empty catch block
                        }
                    }
                }
            }
            return MatchType.NOT_A_NUMBER;
        }
    }

    public MatchType isNumberMatch(Phonenumber.PhoneNumber phoneNumber, String string) {
        try {
            Phonenumber.PhoneNumber phoneNumber2 = this.parse(string, UNKNOWN_REGION);
            return this.isNumberMatch(phoneNumber, phoneNumber2);
        }
        catch (NumberParseException numberParseException) {
            if (numberParseException.getErrorType() == NumberParseException.ErrorType.INVALID_COUNTRY_CODE) {
                String string2 = this.getRegionCodeForCountryCode(phoneNumber.getCountryCode());
                try {
                    if (!string2.equals(UNKNOWN_REGION)) {
                        Phonenumber.PhoneNumber phoneNumber3 = this.parse(string, string2);
                        MatchType matchType = this.isNumberMatch(phoneNumber, phoneNumber3);
                        if (matchType == MatchType.EXACT_MATCH) {
                            return MatchType.NSN_MATCH;
                        }
                        return matchType;
                    }
                    Phonenumber.PhoneNumber phoneNumber4 = new Phonenumber.PhoneNumber();
                    this.parseHelper(string, null, false, false, phoneNumber4);
                    return this.isNumberMatch(phoneNumber, phoneNumber4);
                }
                catch (NumberParseException numberParseException2) {
                    // empty catch block
                }
            }
            return MatchType.NOT_A_NUMBER;
        }
    }

    boolean canBeInternationallyDialled(Phonenumber.PhoneNumber phoneNumber) {
        String string = this.getRegionCodeForNumber(phoneNumber);
        if (!this.isValidRegionCode(string)) {
            return true;
        }
        Phonemetadata.PhoneMetadata phoneMetadata = this.getMetadataForRegion(string);
        String string2 = this.getNationalSignificantNumber(phoneNumber);
        return !this.isNumberMatchingDesc(string2, phoneMetadata.getNoInternationalDialling());
    }

    static {
        Object object = new HashMap<Character, Character>();
        ((HashMap)object).put(Character.valueOf('0'), Character.valueOf('0'));
        ((HashMap)object).put(Character.valueOf('1'), Character.valueOf('1'));
        ((HashMap)object).put(Character.valueOf('2'), Character.valueOf('2'));
        ((HashMap)object).put(Character.valueOf('3'), Character.valueOf('3'));
        ((HashMap)object).put(Character.valueOf('4'), Character.valueOf('4'));
        ((HashMap)object).put(Character.valueOf('5'), Character.valueOf('5'));
        ((HashMap)object).put(Character.valueOf('6'), Character.valueOf('6'));
        ((HashMap)object).put(Character.valueOf('7'), Character.valueOf('7'));
        ((HashMap)object).put(Character.valueOf('8'), Character.valueOf('8'));
        ((HashMap)object).put(Character.valueOf('9'), Character.valueOf('9'));
        Object object2 = new HashMap<Character, Character>(40);
        ((HashMap)object2).put(Character.valueOf('A'), Character.valueOf('2'));
        ((HashMap)object2).put(Character.valueOf('B'), Character.valueOf('2'));
        ((HashMap)object2).put(Character.valueOf('C'), Character.valueOf('2'));
        ((HashMap)object2).put(Character.valueOf('D'), Character.valueOf('3'));
        ((HashMap)object2).put(Character.valueOf('E'), Character.valueOf('3'));
        ((HashMap)object2).put(Character.valueOf('F'), Character.valueOf('3'));
        ((HashMap)object2).put(Character.valueOf('G'), Character.valueOf('4'));
        ((HashMap)object2).put(Character.valueOf('H'), Character.valueOf('4'));
        ((HashMap)object2).put(Character.valueOf('I'), Character.valueOf('4'));
        ((HashMap)object2).put(Character.valueOf('J'), Character.valueOf('5'));
        ((HashMap)object2).put(Character.valueOf('K'), Character.valueOf('5'));
        ((HashMap)object2).put(Character.valueOf('L'), Character.valueOf('5'));
        ((HashMap)object2).put(Character.valueOf('M'), Character.valueOf('6'));
        ((HashMap)object2).put(Character.valueOf('N'), Character.valueOf('6'));
        ((HashMap)object2).put(Character.valueOf('O'), Character.valueOf('6'));
        ((HashMap)object2).put(Character.valueOf('P'), Character.valueOf('7'));
        ((HashMap)object2).put(Character.valueOf('Q'), Character.valueOf('7'));
        ((HashMap)object2).put(Character.valueOf('R'), Character.valueOf('7'));
        ((HashMap)object2).put(Character.valueOf('S'), Character.valueOf('7'));
        ((HashMap)object2).put(Character.valueOf('T'), Character.valueOf('8'));
        ((HashMap)object2).put(Character.valueOf('U'), Character.valueOf('8'));
        ((HashMap)object2).put(Character.valueOf('V'), Character.valueOf('8'));
        ((HashMap)object2).put(Character.valueOf('W'), Character.valueOf('9'));
        ((HashMap)object2).put(Character.valueOf('X'), Character.valueOf('9'));
        ((HashMap)object2).put(Character.valueOf('Y'), Character.valueOf('9'));
        ((HashMap)object2).put(Character.valueOf('Z'), Character.valueOf('9'));
        ALPHA_MAPPINGS = Collections.unmodifiableMap(object2);
        HashMap<Character, Character> hashMap = new HashMap<Character, Character>(100);
        hashMap.putAll(ALPHA_MAPPINGS);
        hashMap.putAll((Map<Character, Character>)object);
        ALPHA_PHONE_MAPPINGS = Collections.unmodifiableMap(hashMap);
        HashMap<Character, Character> hashMap2 = new HashMap<Character, Character>();
        hashMap2.putAll((Map<Character, Character>)object);
        hashMap2.put(Character.valueOf('+'), Character.valueOf('+'));
        hashMap2.put(Character.valueOf('*'), Character.valueOf('*'));
        DIALLABLE_CHAR_MAPPINGS = Collections.unmodifiableMap(hashMap2);
        HashMap<Character, Character> hashMap3 = new HashMap<Character, Character>();
        for (char c : ALPHA_MAPPINGS.keySet()) {
            hashMap3.put(Character.valueOf(Character.toLowerCase(c)), Character.valueOf(c));
            hashMap3.put(Character.valueOf(c), Character.valueOf(c));
        }
        hashMap3.putAll((Map<Character, Character>)object);
        hashMap3.put(Character.valueOf('-'), Character.valueOf('-'));
        hashMap3.put(Character.valueOf('\uff0d'), Character.valueOf('-'));
        hashMap3.put(Character.valueOf('\u2010'), Character.valueOf('-'));
        hashMap3.put(Character.valueOf('\u2011'), Character.valueOf('-'));
        hashMap3.put(Character.valueOf('\u2012'), Character.valueOf('-'));
        hashMap3.put(Character.valueOf('\u2013'), Character.valueOf('-'));
        hashMap3.put(Character.valueOf('\u2014'), Character.valueOf('-'));
        hashMap3.put(Character.valueOf('\u2015'), Character.valueOf('-'));
        hashMap3.put(Character.valueOf('\u2212'), Character.valueOf('-'));
        hashMap3.put(Character.valueOf('/'), Character.valueOf('/'));
        hashMap3.put(Character.valueOf('\uff0f'), Character.valueOf('/'));
        hashMap3.put(Character.valueOf(' '), Character.valueOf(' '));
        hashMap3.put(Character.valueOf('\u3000'), Character.valueOf(' '));
        hashMap3.put(Character.valueOf('\u2060'), Character.valueOf(' '));
        hashMap3.put(Character.valueOf('.'), Character.valueOf('.'));
        hashMap3.put(Character.valueOf('\uff0e'), Character.valueOf('.'));
        ALL_PLUS_NUMBER_GROUPING_SYMBOLS = Collections.unmodifiableMap(hashMap3);
        UNIQUE_INTERNATIONAL_PREFIX = Pattern.compile("[\\d]+(?:[~\u2053\u223c\uff5e][\\d]+)?");
        VALID_ALPHA = Arrays.toString(ALPHA_MAPPINGS.keySet().toArray()).replaceAll("[, \\[\\]]", "") + Arrays.toString(ALPHA_MAPPINGS.keySet().toArray()).toLowerCase().replaceAll("[, \\[\\]]", "");
        PLUS_CHARS_PATTERN = Pattern.compile("[+\uff0b]+");
        SEPARATOR_PATTERN = Pattern.compile("[-x\u2010-\u2015\u2212\u30fc\uff0d-\uff0f \u00a0\u200b\u2060\u3000()\uff08\uff09\uff3b\uff3d.\\[\\]/~\u2053\u223c\uff5e]+");
        CAPTURING_DIGIT_PATTERN = Pattern.compile("(\\p{Nd})");
        VALID_START_CHAR_PATTERN = Pattern.compile(VALID_START_CHAR);
        SECOND_NUMBER_START_PATTERN = Pattern.compile(SECOND_NUMBER_START);
        UNWANTED_END_CHAR_PATTERN = Pattern.compile(UNWANTED_END_CHARS);
        VALID_ALPHA_PHONE_PATTERN = Pattern.compile("(?:.*?[A-Za-z]){3}.*");
        VALID_PHONE_NUMBER = "[+\uff0b]*(?:[-x\u2010-\u2015\u2212\u30fc\uff0d-\uff0f \u00a0\u200b\u2060\u3000()\uff08\uff09\uff3b\uff3d.\\[\\]/~\u2053\u223c\uff5e*]*\\p{Nd}){3,}[-x\u2010-\u2015\u2212\u30fc\uff0d-\uff0f \u00a0\u200b\u2060\u3000()\uff08\uff09\uff3b\uff3d.\\[\\]/~\u2053\u223c\uff5e*" + VALID_ALPHA + DIGITS + "]*";
        object = "x\uff58#\uff03~\uff5e";
        object2 = "," + (String)object;
        EXTN_PATTERNS_FOR_PARSING = PhoneNumberUtil.createExtnPattern((String)object2);
        EXTN_PATTERNS_FOR_MATCHING = PhoneNumberUtil.createExtnPattern((String)object);
        EXTN_PATTERN = Pattern.compile("(?:" + EXTN_PATTERNS_FOR_PARSING + ")$", 66);
        VALID_PHONE_NUMBER_PATTERN = Pattern.compile(VALID_PHONE_NUMBER + "(?:" + EXTN_PATTERNS_FOR_PARSING + ")?", 66);
        NON_DIGITS_PATTERN = Pattern.compile("(\\D+)");
        FIRST_GROUP_PATTERN = Pattern.compile("(\\$\\d)");
        NP_PATTERN = Pattern.compile("\\$NP");
        FG_PATTERN = Pattern.compile("\\$FG");
        CC_PATTERN = Pattern.compile("\\$CC");
        instance = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Leniency {
        POSSIBLE{

            boolean verify(Phonenumber.PhoneNumber phoneNumber, String string, PhoneNumberUtil phoneNumberUtil) {
                return phoneNumberUtil.isPossibleNumber(phoneNumber);
            }
        }
        ,
        VALID{

            boolean verify(Phonenumber.PhoneNumber phoneNumber, String string, PhoneNumberUtil phoneNumberUtil) {
                if (!phoneNumberUtil.isValidNumber(phoneNumber) || !Leniency.containsOnlyValidXChars(phoneNumber, string, phoneNumberUtil)) {
                    return false;
                }
                return Leniency.isNationalPrefixPresentIfRequired(phoneNumber, phoneNumberUtil);
            }
        }
        ,
        STRICT_GROUPING{

            boolean verify(Phonenumber.PhoneNumber phoneNumber, String string, PhoneNumberUtil phoneNumberUtil) {
                if (!phoneNumberUtil.isValidNumber(phoneNumber) || !Leniency.containsOnlyValidXChars(phoneNumber, string, phoneNumberUtil) || Leniency.containsMoreThanOneSlash(string) || !Leniency.isNationalPrefixPresentIfRequired(phoneNumber, phoneNumberUtil)) {
                    return false;
                }
                String[] stringArray = Leniency.getNationalNumberGroups(phoneNumberUtil, phoneNumber);
                StringBuilder stringBuilder = PhoneNumberUtil.normalizeDigits(string, true);
                int n = 0;
                for (int i = 0; i < stringArray.length; ++i) {
                    if ((n = stringBuilder.indexOf(stringArray[i], n)) < 0) {
                        return false;
                    }
                    if (i != 0 || (n += stringArray[i].length()) >= stringBuilder.length() || !Character.isDigit(stringBuilder.charAt(n))) continue;
                    String string2 = phoneNumberUtil.getNationalSignificantNumber(phoneNumber);
                    return stringBuilder.substring(n - stringArray[i].length()).startsWith(string2);
                }
                return stringBuilder.substring(n).contains(phoneNumber.getExtension());
            }
        }
        ,
        EXACT_GROUPING{

            boolean verify(Phonenumber.PhoneNumber phoneNumber, String string, PhoneNumberUtil phoneNumberUtil) {
                int n;
                if (!phoneNumberUtil.isValidNumber(phoneNumber) || !Leniency.containsOnlyValidXChars(phoneNumber, string, phoneNumberUtil) || Leniency.containsMoreThanOneSlash(string) || !Leniency.isNationalPrefixPresentIfRequired(phoneNumber, phoneNumberUtil)) {
                    return false;
                }
                StringBuilder stringBuilder = PhoneNumberUtil.normalizeDigits(string, true);
                String[] stringArray = NON_DIGITS_PATTERN.split(stringBuilder.toString());
                int n2 = n = phoneNumber.hasExtension() ? stringArray.length - 2 : stringArray.length - 1;
                if (stringArray.length == 1 || stringArray[n].contains(phoneNumberUtil.getNationalSignificantNumber(phoneNumber))) {
                    return true;
                }
                String[] stringArray2 = Leniency.getNationalNumberGroups(phoneNumberUtil, phoneNumber);
                for (int i = stringArray2.length - 1; i > 0 && n >= 0; --i, --n) {
                    if (stringArray[n].equals(stringArray2[i])) continue;
                    return false;
                }
                return n >= 0 && stringArray[n].endsWith(stringArray2[0]);
            }
        };


        private static String[] getNationalNumberGroups(PhoneNumberUtil phoneNumberUtil, Phonenumber.PhoneNumber phoneNumber) {
            String string = phoneNumberUtil.format(phoneNumber, PhoneNumberFormat.RFC3966);
            int n = string.indexOf(59);
            if (n < 0) {
                n = string.length();
            }
            int n2 = string.indexOf(45) + 1;
            return string.substring(n2, n).split("-");
        }

        private static boolean containsMoreThanOneSlash(String string) {
            int n = string.indexOf(47);
            return n > 0 && string.substring(n + 1).contains("/");
        }

        private static boolean containsOnlyValidXChars(Phonenumber.PhoneNumber phoneNumber, String string, PhoneNumberUtil phoneNumberUtil) {
            for (int i = 0; i < string.length() - 1; ++i) {
                char c;
                char c2 = string.charAt(i);
                if (c2 != 'x' && c2 != 'X' || !((c = string.charAt(i + 1)) == 'x' || c == 'X' ? phoneNumberUtil.isNumberMatch(phoneNumber, string.substring(++i)) != MatchType.NSN_MATCH : !PhoneNumberUtil.normalizeDigitsOnly(string.substring(i)).equals(phoneNumber.getExtension()))) continue;
                return false;
            }
            return true;
        }

        private static boolean isNationalPrefixPresentIfRequired(Phonenumber.PhoneNumber phoneNumber, PhoneNumberUtil phoneNumberUtil) {
            if (phoneNumber.getCountryCodeSource() != Phonenumber.PhoneNumber.CountryCodeSource.FROM_DEFAULT_COUNTRY) {
                return true;
            }
            String string = phoneNumberUtil.getRegionCodeForCountryCode(phoneNumber.getCountryCode());
            Phonemetadata.PhoneMetadata phoneMetadata = phoneNumberUtil.getMetadataForRegion(string);
            if (phoneMetadata == null) {
                return true;
            }
            String string2 = phoneNumberUtil.getNationalSignificantNumber(phoneNumber);
            Phonemetadata.NumberFormat numberFormat = phoneNumberUtil.chooseFormattingPatternForNumber(phoneMetadata.numberFormats(), string2);
            if (numberFormat != null && numberFormat.getNationalPrefixFormattingRule().length() > 0) {
                if (numberFormat.isNationalPrefixOptionalWhenFormatting()) {
                    return true;
                }
                String string3 = numberFormat.getNationalPrefixFormattingRule();
                string3 = string3.substring(0, string3.indexOf("$1"));
                if ((string3 = PhoneNumberUtil.normalizeDigitsOnly(string3)).length() == 0) {
                    return true;
                }
                String string4 = PhoneNumberUtil.normalizeDigitsOnly(phoneNumber.getRawInput());
                StringBuilder stringBuilder = new StringBuilder(string4);
                return phoneNumberUtil.maybeStripNationalPrefixAndCarrierCode(stringBuilder, phoneMetadata, null);
            }
            return true;
        }

        abstract boolean verify(Phonenumber.PhoneNumber var1, String var2, PhoneNumberUtil var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ValidationResult {
        IS_POSSIBLE,
        INVALID_COUNTRY_CODE,
        TOO_SHORT,
        TOO_LONG;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MatchType {
        NOT_A_NUMBER,
        NO_MATCH,
        SHORT_NSN_MATCH,
        NSN_MATCH,
        EXACT_MATCH;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PhoneNumberType {
        FIXED_LINE,
        MOBILE,
        FIXED_LINE_OR_MOBILE,
        TOLL_FREE,
        PREMIUM_RATE,
        SHARED_COST,
        VOIP,
        PERSONAL_NUMBER,
        PAGER,
        UAN,
        VOICEMAIL,
        UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PhoneNumberFormat {
        E164,
        INTERNATIONAL,
        NATIONAL,
        RFC3966;

    }
}

