/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers;

import java.io.Serializable;

public final class Phonenumber {
    private Phonenumber() {
    }

    public static class PhoneNumber
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private boolean hasCountryCode;
        private int countryCode_ = 0;
        private boolean hasNationalNumber;
        private long nationalNumber_ = 0L;
        private boolean hasExtension;
        private String extension_ = "";
        private boolean hasItalianLeadingZero;
        private boolean italianLeadingZero_ = false;
        private boolean hasRawInput;
        private String rawInput_ = "";
        private boolean hasCountryCodeSource;
        private CountryCodeSource countryCodeSource_ = CountryCodeSource.FROM_NUMBER_WITH_PLUS_SIGN;
        private boolean hasPreferredDomesticCarrierCode;
        private String preferredDomesticCarrierCode_ = "";

        public boolean hasCountryCode() {
            return this.hasCountryCode;
        }

        public int getCountryCode() {
            return this.countryCode_;
        }

        public PhoneNumber setCountryCode(int n) {
            this.hasCountryCode = true;
            this.countryCode_ = n;
            return this;
        }

        public PhoneNumber clearCountryCode() {
            this.hasCountryCode = false;
            this.countryCode_ = 0;
            return this;
        }

        public boolean hasNationalNumber() {
            return this.hasNationalNumber;
        }

        public long getNationalNumber() {
            return this.nationalNumber_;
        }

        public PhoneNumber setNationalNumber(long l) {
            this.hasNationalNumber = true;
            this.nationalNumber_ = l;
            return this;
        }

        public PhoneNumber clearNationalNumber() {
            this.hasNationalNumber = false;
            this.nationalNumber_ = 0L;
            return this;
        }

        public boolean hasExtension() {
            return this.hasExtension;
        }

        public String getExtension() {
            return this.extension_;
        }

        public PhoneNumber setExtension(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            this.hasExtension = true;
            this.extension_ = string;
            return this;
        }

        public PhoneNumber clearExtension() {
            this.hasExtension = false;
            this.extension_ = "";
            return this;
        }

        public boolean hasItalianLeadingZero() {
            return this.hasItalianLeadingZero;
        }

        public boolean isItalianLeadingZero() {
            return this.italianLeadingZero_;
        }

        public PhoneNumber setItalianLeadingZero(boolean bl) {
            this.hasItalianLeadingZero = true;
            this.italianLeadingZero_ = bl;
            return this;
        }

        public PhoneNumber clearItalianLeadingZero() {
            this.hasItalianLeadingZero = false;
            this.italianLeadingZero_ = false;
            return this;
        }

        public boolean hasRawInput() {
            return this.hasRawInput;
        }

        public String getRawInput() {
            return this.rawInput_;
        }

        public PhoneNumber setRawInput(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            this.hasRawInput = true;
            this.rawInput_ = string;
            return this;
        }

        public PhoneNumber clearRawInput() {
            this.hasRawInput = false;
            this.rawInput_ = "";
            return this;
        }

        public boolean hasCountryCodeSource() {
            return this.hasCountryCodeSource;
        }

        public CountryCodeSource getCountryCodeSource() {
            return this.countryCodeSource_;
        }

        public PhoneNumber setCountryCodeSource(CountryCodeSource countryCodeSource) {
            if (countryCodeSource == null) {
                throw new NullPointerException();
            }
            this.hasCountryCodeSource = true;
            this.countryCodeSource_ = countryCodeSource;
            return this;
        }

        public PhoneNumber clearCountryCodeSource() {
            this.hasCountryCodeSource = false;
            this.countryCodeSource_ = CountryCodeSource.FROM_NUMBER_WITH_PLUS_SIGN;
            return this;
        }

        public boolean hasPreferredDomesticCarrierCode() {
            return this.hasPreferredDomesticCarrierCode;
        }

        public String getPreferredDomesticCarrierCode() {
            return this.preferredDomesticCarrierCode_;
        }

        public PhoneNumber setPreferredDomesticCarrierCode(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            this.hasPreferredDomesticCarrierCode = true;
            this.preferredDomesticCarrierCode_ = string;
            return this;
        }

        public PhoneNumber clearPreferredDomesticCarrierCode() {
            this.hasPreferredDomesticCarrierCode = false;
            this.preferredDomesticCarrierCode_ = "";
            return this;
        }

        public final PhoneNumber clear() {
            this.clearCountryCode();
            this.clearNationalNumber();
            this.clearExtension();
            this.clearItalianLeadingZero();
            this.clearRawInput();
            this.clearCountryCodeSource();
            this.clearPreferredDomesticCarrierCode();
            return this;
        }

        public PhoneNumber mergeFrom(PhoneNumber phoneNumber) {
            if (phoneNumber.hasCountryCode()) {
                this.setCountryCode(phoneNumber.getCountryCode());
            }
            if (phoneNumber.hasNationalNumber()) {
                this.setNationalNumber(phoneNumber.getNationalNumber());
            }
            if (phoneNumber.hasExtension()) {
                this.setExtension(phoneNumber.getExtension());
            }
            if (phoneNumber.hasItalianLeadingZero()) {
                this.setItalianLeadingZero(phoneNumber.isItalianLeadingZero());
            }
            if (phoneNumber.hasRawInput()) {
                this.setRawInput(phoneNumber.getRawInput());
            }
            if (phoneNumber.hasCountryCodeSource()) {
                this.setCountryCodeSource(phoneNumber.getCountryCodeSource());
            }
            if (phoneNumber.hasPreferredDomesticCarrierCode()) {
                this.setPreferredDomesticCarrierCode(phoneNumber.getPreferredDomesticCarrierCode());
            }
            return this;
        }

        public boolean exactlySameAs(PhoneNumber phoneNumber) {
            if (phoneNumber == null) {
                return false;
            }
            if (this == phoneNumber) {
                return true;
            }
            return this.countryCode_ == phoneNumber.countryCode_ && this.nationalNumber_ == phoneNumber.nationalNumber_ && this.extension_.equals(phoneNumber.extension_) && this.italianLeadingZero_ == phoneNumber.italianLeadingZero_ && this.rawInput_.equals(phoneNumber.rawInput_) && this.countryCodeSource_ == phoneNumber.countryCodeSource_ && this.preferredDomesticCarrierCode_.equals(phoneNumber.preferredDomesticCarrierCode_) && this.hasPreferredDomesticCarrierCode() == phoneNumber.hasPreferredDomesticCarrierCode();
        }

        public boolean equals(Object object) {
            return object instanceof PhoneNumber && this.exactlySameAs((PhoneNumber)object);
        }

        public int hashCode() {
            int n = 41;
            n = 53 * n + this.getCountryCode();
            n = 53 * n + Long.valueOf(this.getNationalNumber()).hashCode();
            n = 53 * n + this.getExtension().hashCode();
            n = 53 * n + (this.isItalianLeadingZero() ? 1231 : 1237);
            n = 53 * n + this.getRawInput().hashCode();
            n = 53 * n + this.getCountryCodeSource().hashCode();
            n = 53 * n + this.getPreferredDomesticCarrierCode().hashCode();
            n = 53 * n + (this.hasPreferredDomesticCarrierCode() ? 1231 : 1237);
            return n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Country Code: ").append(this.countryCode_);
            stringBuilder.append(" National Number: ").append(this.nationalNumber_);
            if (this.hasItalianLeadingZero() && this.isItalianLeadingZero()) {
                stringBuilder.append(" Leading Zero: true");
            }
            if (this.hasExtension()) {
                stringBuilder.append(" Extension: ").append(this.extension_);
            }
            if (this.hasCountryCodeSource()) {
                stringBuilder.append(" Country Code Source: ").append((Object)this.countryCodeSource_);
            }
            if (this.hasPreferredDomesticCarrierCode()) {
                stringBuilder.append(" Preferred Domestic Carrier Code: ").append(this.preferredDomesticCarrierCode_);
            }
            return stringBuilder.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum CountryCodeSource {
            FROM_NUMBER_WITH_PLUS_SIGN,
            FROM_NUMBER_WITH_IDD,
            FROM_NUMBER_WITHOUT_PLUS_SIGN,
            FROM_DEFAULT_COUNTRY;

        }
    }
}

