/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers.geocoding;

import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import com.google.i18n.phonenumbers.geocoding.AreaCodeMapStorageStrategy;
import com.google.i18n.phonenumbers.geocoding.DefaultMapStorage;
import com.google.i18n.phonenumbers.geocoding.FlyweightMapStorage;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AreaCodeMap
implements Externalizable {
    private final PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();
    private static final Logger LOGGER = Logger.getLogger(AreaCodeMap.class.getName());
    private AreaCodeMapStorageStrategy areaCodeMapStorage;

    AreaCodeMapStorageStrategy getAreaCodeMapStorage() {
        return this.areaCodeMapStorage;
    }

    private static int getSizeOfAreaCodeMapStorage(AreaCodeMapStorageStrategy areaCodeMapStorageStrategy, SortedMap<Integer, String> sortedMap) throws IOException {
        areaCodeMapStorageStrategy.readFromSortedMap(sortedMap);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        areaCodeMapStorageStrategy.writeExternal(objectOutputStream);
        objectOutputStream.flush();
        int n = byteArrayOutputStream.size();
        objectOutputStream.close();
        return n;
    }

    private AreaCodeMapStorageStrategy createDefaultMapStorage() {
        return new DefaultMapStorage();
    }

    private AreaCodeMapStorageStrategy createFlyweightMapStorage() {
        return new FlyweightMapStorage();
    }

    AreaCodeMapStorageStrategy getSmallerMapStorage(SortedMap<Integer, String> sortedMap) {
        try {
            AreaCodeMapStorageStrategy areaCodeMapStorageStrategy = this.createFlyweightMapStorage();
            int n = AreaCodeMap.getSizeOfAreaCodeMapStorage(areaCodeMapStorageStrategy, sortedMap);
            AreaCodeMapStorageStrategy areaCodeMapStorageStrategy2 = this.createDefaultMapStorage();
            int n2 = AreaCodeMap.getSizeOfAreaCodeMapStorage(areaCodeMapStorageStrategy2, sortedMap);
            return n < n2 ? areaCodeMapStorageStrategy : areaCodeMapStorageStrategy2;
        }
        catch (IOException iOException) {
            LOGGER.severe(iOException.getMessage());
            return this.createFlyweightMapStorage();
        }
    }

    public void readAreaCodeMap(SortedMap<Integer, String> sortedMap) {
        this.areaCodeMapStorage = this.getSmallerMapStorage(sortedMap);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        boolean bl = objectInput.readBoolean();
        this.areaCodeMapStorage = bl ? new FlyweightMapStorage() : new DefaultMapStorage();
        this.areaCodeMapStorage.readExternal(objectInput);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeBoolean(this.areaCodeMapStorage instanceof FlyweightMapStorage);
        this.areaCodeMapStorage.writeExternal(objectOutput);
    }

    String lookup(Phonenumber.PhoneNumber phoneNumber) {
        int n = this.areaCodeMapStorage.getNumOfEntries();
        if (n == 0) {
            return null;
        }
        long l = Long.parseLong(phoneNumber.getCountryCode() + this.phoneUtil.getNationalSignificantNumber(phoneNumber));
        int n2 = n - 1;
        SortedSet<Integer> sortedSet = this.areaCodeMapStorage.getPossibleLengths();
        while (sortedSet.size() > 0) {
            Integer n3 = (Integer)sortedSet.last();
            String string = String.valueOf(l);
            if (string.length() > n3) {
                l = Long.parseLong(string.substring(0, n3));
            }
            if ((n2 = this.binarySearch(0, n2, l)) < 0) {
                return null;
            }
            int n4 = this.areaCodeMapStorage.getPrefix(n2);
            if (l == (long)n4) {
                return this.areaCodeMapStorage.getDescription(n2);
            }
            sortedSet = sortedSet.headSet(n3);
        }
        return null;
    }

    private int binarySearch(int n, int n2, long l) {
        int n3 = 0;
        while (n <= n2) {
            n3 = n + n2 >>> 1;
            int n4 = this.areaCodeMapStorage.getPrefix(n3);
            if ((long)n4 == l) {
                return n3;
            }
            if ((long)n4 > l) {
                n2 = --n3;
                continue;
            }
            n = n3 + 1;
        }
        return n3;
    }

    public String toString() {
        return this.areaCodeMapStorage.toString();
    }
}

