/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers.geocoding;

import com.google.i18n.phonenumbers.geocoding.AreaCodeMapStorageStrategy;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.SortedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultMapStorage
extends AreaCodeMapStorageStrategy {
    private int[] phoneNumberPrefixes;
    private String[] descriptions;

    @Override
    public int getPrefix(int n) {
        return this.phoneNumberPrefixes[n];
    }

    @Override
    public String getDescription(int n) {
        return this.descriptions[n];
    }

    @Override
    public void readFromSortedMap(SortedMap<Integer, String> sortedMap) {
        this.numOfEntries = sortedMap.size();
        this.phoneNumberPrefixes = new int[this.numOfEntries];
        this.descriptions = new String[this.numOfEntries];
        int n = 0;
        for (int n2 : sortedMap.keySet()) {
            this.phoneNumberPrefixes[n++] = n2;
            this.possibleLengths.add((int)Math.log10(n2) + 1);
        }
        sortedMap.values().toArray(this.descriptions);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        int n;
        this.numOfEntries = objectInput.readInt();
        if (this.phoneNumberPrefixes == null || this.phoneNumberPrefixes.length < this.numOfEntries) {
            this.phoneNumberPrefixes = new int[this.numOfEntries];
        }
        if (this.descriptions == null || this.descriptions.length < this.numOfEntries) {
            this.descriptions = new String[this.numOfEntries];
        }
        for (n = 0; n < this.numOfEntries; ++n) {
            this.phoneNumberPrefixes[n] = objectInput.readInt();
            this.descriptions[n] = objectInput.readUTF();
        }
        n = objectInput.readInt();
        this.possibleLengths.clear();
        for (int i = 0; i < n; ++i) {
            this.possibleLengths.add(objectInput.readInt());
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n;
        objectOutput.writeInt(this.numOfEntries);
        for (n = 0; n < this.numOfEntries; ++n) {
            objectOutput.writeInt(this.phoneNumberPrefixes[n]);
            objectOutput.writeUTF(this.descriptions[n]);
        }
        n = this.possibleLengths.size();
        objectOutput.writeInt(n);
        for (Integer n2 : this.possibleLengths) {
            objectOutput.writeInt(n2);
        }
    }
}

