/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers.geocoding;

import com.google.i18n.phonenumbers.geocoding.AreaCodeMapStorageStrategy;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FlyweightMapStorage
extends AreaCodeMapStorageStrategy {
    private static final int SHORT_NUM_BYTES = 2;
    private static final int INT_NUM_BYTES = 4;
    private int prefixSizeInBytes;
    private int descIndexSizeInBytes;
    private ByteBuffer phoneNumberPrefixes;
    private ByteBuffer descriptionIndexes;
    private String[] descriptionPool;

    FlyweightMapStorage() {
    }

    @Override
    public int getPrefix(int n) {
        return FlyweightMapStorage.readWordFromBuffer(this.phoneNumberPrefixes, this.prefixSizeInBytes, n);
    }

    @Override
    public String getDescription(int n) {
        int n2 = FlyweightMapStorage.readWordFromBuffer(this.descriptionIndexes, this.descIndexSizeInBytes, n);
        return this.descriptionPool[n2];
    }

    @Override
    public void readFromSortedMap(SortedMap<Integer, String> sortedMap) {
        TreeSet<String> treeSet = new TreeSet<String>();
        this.numOfEntries = sortedMap.size();
        this.prefixSizeInBytes = FlyweightMapStorage.getOptimalNumberOfBytesForValue(sortedMap.lastKey());
        this.phoneNumberPrefixes = ByteBuffer.allocate(this.numOfEntries * this.prefixSizeInBytes);
        int n = 0;
        for (Map.Entry<Integer, String> entry : sortedMap.entrySet()) {
            int n2 = entry.getKey();
            FlyweightMapStorage.storeWordInBuffer(this.phoneNumberPrefixes, this.prefixSizeInBytes, n, n2);
            this.possibleLengths.add((int)Math.log10(n2) + 1);
            treeSet.add(entry.getValue());
            ++n;
        }
        this.createDescriptionPool(treeSet, sortedMap);
    }

    private void createDescriptionPool(SortedSet<String> sortedSet, SortedMap<Integer, String> sortedMap) {
        this.descIndexSizeInBytes = FlyweightMapStorage.getOptimalNumberOfBytesForValue(sortedSet.size() - 1);
        this.descriptionIndexes = ByteBuffer.allocate(this.numOfEntries * this.descIndexSizeInBytes);
        this.descriptionPool = new String[sortedSet.size()];
        sortedSet.toArray(this.descriptionPool);
        int n = 0;
        for (int i = 0; i < this.numOfEntries; ++i) {
            int n2 = FlyweightMapStorage.readWordFromBuffer(this.phoneNumberPrefixes, this.prefixSizeInBytes, i);
            String string = (String)sortedMap.get(n2);
            int n3 = Arrays.binarySearch(this.descriptionPool, string);
            FlyweightMapStorage.storeWordInBuffer(this.descriptionIndexes, this.descIndexSizeInBytes, n, n3);
            ++n;
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        int n;
        this.prefixSizeInBytes = objectInput.readInt();
        this.descIndexSizeInBytes = objectInput.readInt();
        int n2 = objectInput.readInt();
        this.possibleLengths.clear();
        for (n = 0; n < n2; ++n) {
            this.possibleLengths.add(objectInput.readInt());
        }
        n = objectInput.readInt();
        if (this.descriptionPool == null || this.descriptionPool.length < n) {
            this.descriptionPool = new String[n];
        }
        for (int i = 0; i < n; ++i) {
            String string;
            this.descriptionPool[i] = string = objectInput.readUTF();
        }
        this.readEntries(objectInput);
    }

    private void readEntries(ObjectInput objectInput) throws IOException {
        this.numOfEntries = objectInput.readInt();
        if (this.phoneNumberPrefixes == null || this.phoneNumberPrefixes.capacity() < this.numOfEntries) {
            this.phoneNumberPrefixes = ByteBuffer.allocate(this.numOfEntries * this.prefixSizeInBytes);
        }
        if (this.descriptionIndexes == null || this.descriptionIndexes.capacity() < this.numOfEntries) {
            this.descriptionIndexes = ByteBuffer.allocate(this.numOfEntries * this.descIndexSizeInBytes);
        }
        for (int i = 0; i < this.numOfEntries; ++i) {
            FlyweightMapStorage.readExternalWord(objectInput, this.prefixSizeInBytes, this.phoneNumberPrefixes, i);
            FlyweightMapStorage.readExternalWord(objectInput, this.descIndexSizeInBytes, this.descriptionIndexes, i);
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.prefixSizeInBytes);
        objectOutput.writeInt(this.descIndexSizeInBytes);
        int n = this.possibleLengths.size();
        objectOutput.writeInt(n);
        for (Integer n2 : this.possibleLengths) {
            objectOutput.writeInt(n2);
        }
        objectOutput.writeInt(this.descriptionPool.length);
        for (String string : this.descriptionPool) {
            objectOutput.writeUTF(string);
        }
        objectOutput.writeInt(this.numOfEntries);
        for (int i = 0; i < this.numOfEntries; ++i) {
            FlyweightMapStorage.writeExternalWord(objectOutput, this.prefixSizeInBytes, this.phoneNumberPrefixes, i);
            FlyweightMapStorage.writeExternalWord(objectOutput, this.descIndexSizeInBytes, this.descriptionIndexes, i);
        }
    }

    private static int getOptimalNumberOfBytesForValue(int n) {
        return n <= Short.MAX_VALUE ? 2 : 4;
    }

    private static void readExternalWord(ObjectInput objectInput, int n, ByteBuffer byteBuffer, int n2) throws IOException {
        int n3 = n2 * n;
        if (n == 2) {
            byteBuffer.putShort(n3, objectInput.readShort());
        } else {
            byteBuffer.putInt(n3, objectInput.readInt());
        }
    }

    private static void writeExternalWord(ObjectOutput objectOutput, int n, ByteBuffer byteBuffer, int n2) throws IOException {
        int n3 = n2 * n;
        if (n == 2) {
            objectOutput.writeShort(byteBuffer.getShort(n3));
        } else {
            objectOutput.writeInt(byteBuffer.getInt(n3));
        }
    }

    private static int readWordFromBuffer(ByteBuffer byteBuffer, int n, int n2) {
        int n3 = n2 * n;
        return n == 2 ? byteBuffer.getShort(n3) : byteBuffer.getInt(n3);
    }

    private static void storeWordInBuffer(ByteBuffer byteBuffer, int n, int n2, int n3) {
        int n4 = n2 * n;
        if (n == 2) {
            byteBuffer.putShort(n4, (short)n3);
        } else {
            byteBuffer.putInt(n4, n3);
        }
    }
}

