/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers.geocoding;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingFileProvider
implements Externalizable {
    private int numOfEntries = 0;
    private int[] countryCallingCodes;
    private List<Set<String>> availableLanguages;
    private static final Map<String, String> LOCALE_NORMALIZATION_MAP;

    public void readFileConfigs(SortedMap<Integer, Set<String>> sortedMap) {
        this.numOfEntries = sortedMap.size();
        this.countryCallingCodes = new int[this.numOfEntries];
        this.availableLanguages = new ArrayList<Set<String>>(this.numOfEntries);
        int n = 0;
        for (int n2 : sortedMap.keySet()) {
            this.countryCallingCodes[n++] = n2;
            this.availableLanguages.add(new HashSet((Collection)sortedMap.get(n2)));
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        this.numOfEntries = objectInput.readInt();
        if (this.countryCallingCodes == null || this.countryCallingCodes.length < this.numOfEntries) {
            this.countryCallingCodes = new int[this.numOfEntries];
        }
        if (this.availableLanguages == null) {
            this.availableLanguages = new ArrayList<Set<String>>();
        }
        for (int i = 0; i < this.numOfEntries; ++i) {
            this.countryCallingCodes[i] = objectInput.readInt();
            int n = objectInput.readInt();
            HashSet<String> hashSet = new HashSet<String>();
            for (int j = 0; j < n; ++j) {
                hashSet.add(objectInput.readUTF());
            }
            this.availableLanguages.add(hashSet);
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.numOfEntries);
        for (int i = 0; i < this.numOfEntries; ++i) {
            objectOutput.writeInt(this.countryCallingCodes[i]);
            Set<String> set = this.availableLanguages.get(i);
            int n = set.size();
            objectOutput.writeInt(n);
            for (String string : set) {
                objectOutput.writeUTF(string);
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.numOfEntries; ++i) {
            stringBuilder.append(this.countryCallingCodes[i]);
            stringBuilder.append('|');
            TreeSet treeSet = new TreeSet(this.availableLanguages.get(i));
            for (String string : treeSet) {
                stringBuilder.append(string);
                stringBuilder.append(',');
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    String getFileName(int n, String string, String string2, String string3) {
        String string4;
        if (string.length() == 0) {
            return "";
        }
        int n2 = Arrays.binarySearch(this.countryCallingCodes, n);
        if (n2 < 0) {
            return "";
        }
        Set<String> set = this.availableLanguages.get(n2);
        if (set.size() > 0 && (string4 = this.findBestMatchingLanguageCode(set, string, string2, string3)).length() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(n).append('_').append(string4);
            return stringBuilder.toString();
        }
        return "";
    }

    private String findBestMatchingLanguageCode(Set<String> set, String string, String string2, String string3) {
        StringBuilder stringBuilder = this.constructFullLocale(string, string2, string3);
        String string4 = stringBuilder.toString();
        String string5 = LOCALE_NORMALIZATION_MAP.get(string4);
        if (string5 != null && set.contains(string5)) {
            return string5;
        }
        if (set.contains(string4)) {
            return string4;
        }
        if (this.onlyOneOfScriptOrRegionIsEmpty(string2, string3)) {
            if (set.contains(string)) {
                return string;
            }
        } else if (string2.length() > 0 && string3.length() > 0) {
            StringBuilder stringBuilder2 = new StringBuilder(string).append('_').append(string2);
            String string6 = stringBuilder2.toString();
            if (set.contains(string6)) {
                return string6;
            }
            StringBuilder stringBuilder3 = new StringBuilder(string).append('_').append(string3);
            String string7 = stringBuilder3.toString();
            if (set.contains(string7)) {
                return string7;
            }
            if (set.contains(string)) {
                return string;
            }
        }
        return "";
    }

    private boolean onlyOneOfScriptOrRegionIsEmpty(String string, String string2) {
        return string.length() == 0 && string2.length() > 0 || string2.length() == 0 && string.length() > 0;
    }

    private StringBuilder constructFullLocale(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder(string);
        this.appendSubsequentLocalePart(string2, stringBuilder);
        this.appendSubsequentLocalePart(string3, stringBuilder);
        return stringBuilder;
    }

    private void appendSubsequentLocalePart(String string, StringBuilder stringBuilder) {
        if (string.length() > 0) {
            stringBuilder.append('_').append(string);
        }
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("zh_TW", "zh_Hant");
        hashMap.put("zh_HK", "zh_Hant");
        hashMap.put("zh_MO", "zh_Hant");
        LOCALE_NORMALIZATION_MAP = Collections.unmodifiableMap(hashMap);
    }
}

