/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers.geocoding;

import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import com.google.i18n.phonenumbers.geocoding.AreaCodeMap;
import com.google.i18n.phonenumbers.geocoding.MappingFileProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PhoneNumberOfflineGeocoder {
    private static PhoneNumberOfflineGeocoder instance = null;
    private static final String MAPPING_DATA_DIRECTORY = "/com/google/i18n/phonenumbers/geocoding/data/";
    private static final Logger LOGGER = Logger.getLogger(PhoneNumberOfflineGeocoder.class.getName());
    private final PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();
    private final String phonePrefixDataDirectory;
    private MappingFileProvider mappingFileProvider = new MappingFileProvider();
    private Map<String, AreaCodeMap> availablePhonePrefixMaps = new HashMap<String, AreaCodeMap>();

    PhoneNumberOfflineGeocoder(String string) {
        this.phonePrefixDataDirectory = string;
        this.loadMappingFileProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMappingFileProvider() {
        InputStream inputStream = PhoneNumberOfflineGeocoder.class.getResourceAsStream(this.phonePrefixDataDirectory + "config");
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(inputStream);
            this.mappingFileProvider.readExternal(objectInputStream);
        }
        catch (IOException iOException) {
            try {
                LOGGER.log(Level.WARNING, iOException.toString());
            }
            catch (Throwable throwable) {
                PhoneNumberOfflineGeocoder.close(objectInputStream);
                throw throwable;
            }
            PhoneNumberOfflineGeocoder.close(objectInputStream);
        }
        PhoneNumberOfflineGeocoder.close(objectInputStream);
    }

    private AreaCodeMap getPhonePrefixDescriptions(int n, String string, String string2, String string3) {
        String string4 = this.mappingFileProvider.getFileName(n, string, string2, string3);
        if (string4.length() == 0) {
            return null;
        }
        if (!this.availablePhonePrefixMaps.containsKey(string4)) {
            this.loadAreaCodeMapFromFile(string4);
        }
        return this.availablePhonePrefixMaps.get(string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAreaCodeMapFromFile(String string) {
        InputStream inputStream = PhoneNumberOfflineGeocoder.class.getResourceAsStream(this.phonePrefixDataDirectory + string);
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(inputStream);
            AreaCodeMap areaCodeMap = new AreaCodeMap();
            areaCodeMap.readExternal(objectInputStream);
            this.availablePhonePrefixMaps.put(string, areaCodeMap);
        }
        catch (IOException iOException) {
            try {
                LOGGER.log(Level.WARNING, iOException.toString());
            }
            catch (Throwable throwable) {
                PhoneNumberOfflineGeocoder.close(objectInputStream);
                throw throwable;
            }
            PhoneNumberOfflineGeocoder.close(objectInputStream);
        }
        PhoneNumberOfflineGeocoder.close(objectInputStream);
    }

    private static void close(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, iOException.toString());
            }
        }
    }

    public static synchronized PhoneNumberOfflineGeocoder getInstance() {
        if (instance == null) {
            instance = new PhoneNumberOfflineGeocoder(MAPPING_DATA_DIRECTORY);
        }
        return instance;
    }

    private String getCountryNameForNumber(Phonenumber.PhoneNumber phoneNumber, Locale locale) {
        String string = this.phoneUtil.getRegionCodeForNumber(phoneNumber);
        return this.getRegionDisplayName(string, locale);
    }

    private String getRegionDisplayName(String string, Locale locale) {
        return string == null || string.equals("ZZ") ? "" : new Locale("", string).getDisplayCountry(locale);
    }

    public String getDescriptionForValidNumber(Phonenumber.PhoneNumber phoneNumber, Locale locale) {
        String string;
        String string2;
        String string3 = locale.getLanguage();
        String string4 = this.getAreaDescriptionForNumber(phoneNumber, string3, string2 = "", string = locale.getCountry());
        return string4.length() > 0 ? string4 : this.getCountryNameForNumber(phoneNumber, locale);
    }

    public String getDescriptionForValidNumber(Phonenumber.PhoneNumber phoneNumber, Locale locale, String string) {
        String string2 = this.phoneUtil.getRegionCodeForNumber(phoneNumber);
        if (string.equals(string2)) {
            return this.getDescriptionForValidNumber(phoneNumber, locale);
        }
        return this.getRegionDisplayName(string2, locale);
    }

    public String getDescriptionForNumber(Phonenumber.PhoneNumber phoneNumber, Locale locale) {
        if (!this.phoneUtil.isValidNumber(phoneNumber)) {
            return "";
        }
        return this.getDescriptionForValidNumber(phoneNumber, locale);
    }

    public String getDescriptionForNumber(Phonenumber.PhoneNumber phoneNumber, Locale locale, String string) {
        if (!this.phoneUtil.isValidNumber(phoneNumber)) {
            return "";
        }
        return this.getDescriptionForValidNumber(phoneNumber, locale, string);
    }

    private String getAreaDescriptionForNumber(Phonenumber.PhoneNumber phoneNumber, String string, String string2, String string3) {
        String string4;
        int n = phoneNumber.getCountryCode();
        int n2 = n != 1 ? n : 1000 + (int)(phoneNumber.getNationalNumber() / 10000000L);
        AreaCodeMap areaCodeMap = this.getPhonePrefixDescriptions(n2, string, string2, string3);
        String string5 = string4 = areaCodeMap != null ? areaCodeMap.lookup(phoneNumber) : null;
        if ((string4 == null || string4.length() == 0) && this.mayFallBackToEnglish(string)) {
            AreaCodeMap areaCodeMap2 = this.getPhonePrefixDescriptions(n2, "en", "", "");
            if (areaCodeMap2 == null) {
                return "";
            }
            string4 = areaCodeMap2.lookup(phoneNumber);
        }
        return string4 != null ? string4 : "";
    }

    private boolean mayFallBackToEnglish(String string) {
        return !string.equals("zh") && !string.equals("ja") && !string.equals("ko");
    }
}

