/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate;

import au.com.ordermate.util.file.FileUtils;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import ordermate.OrderMate;
import ordermate.startup.LoggerSetupTask;
import ordermate.startup.LoggerWithParentFolderSetupTask;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;

public class OMLogUtil {
    private static List<String> restrictedLogFileNames = Arrays.asList("CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9");

    public static void setLogRoot() {
        System.setProperty("java.net.preferIPv4Stack", "true");
        System.setProperty("log4j2.enable.threadlocals", "true");
        System.setProperty("log4j2.enable.direct.encoders", "true");
        System.setProperty("log4j2.isWebapp", "false");
        System.setProperty("log4j2.disable.jmx", "true");
        System.setProperty("log4j2.contextSelector", "org.apache.logging.log4j.core.async.AsyncLoggerContextSelector");
        System.setProperty("log4j2.asyncLoggerRingBufferSize", "1024");
        System.setProperty("log4j2.formatMsgNoLookups", "true");
        System.setProperty("Log4jContextSelector", "org.apache.logging.log4j.core.async.AsyncLoggerContextSelector");
        if (FileUtils.isOSLinux()) {
            System.setProperty("log.root", "/OM-Logs/");
        } else {
            System.setProperty("log.root", "C:\\OM-Logs\\");
        }
    }

    public static String getDeviceParentFolder() {
        return System.getProperty("log.root") + "Printing" + File.separator + "RawOutput" + File.separator;
    }

    public static String getOutputPortParentFolder() {
        return System.getProperty("log.root") + "Printing" + File.separator;
    }

    public static String getDatamateParentFolder() {
        return System.getProperty("log.root") + "Printing" + File.separator;
    }

    public static String getServermateClientParentFolder() {
        return "ServerMate\\UI-Client\\";
    }

    public static Logger createRootLogger(String loggerName) {
        OMLogUtil.setLogRoot();
        new LoggerSetupTask(loggerName).run();
        OrderMate.LOG = LoggerContext.getContext((boolean)false).getLogger(loggerName);
        return LoggerContext.getContext((boolean)false).getLogger(loggerName);
    }

    public static Logger createRootLoggerWithParentDirectory(String parentFolder, String logFileName) {
        OMLogUtil.setLogRoot();
        new LoggerWithParentFolderSetupTask(parentFolder, logFileName).run();
        return LoggerContext.getContext((boolean)false).getLogger(logFileName);
    }

    public static String adjustLogFileName(String name) {
        if (restrictedLogFileNames.contains(name)) {
            return "Port-" + name;
        }
        return name;
    }
}

