/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate;

import au.com.ordermate.OMLogUtil;
import java.io.File;
import java.util.Iterator;
import ordermate.OrderMate;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AsyncAppender;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.RollingRandomAccessFileAppender;
import org.apache.logging.log4j.core.appender.rolling.CompositeTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TimeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.action.Action;
import org.apache.logging.log4j.core.appender.rolling.action.DeleteAction;
import org.apache.logging.log4j.core.appender.rolling.action.Duration;
import org.apache.logging.log4j.core.appender.rolling.action.IfAccumulatedFileCount;
import org.apache.logging.log4j.core.appender.rolling.action.IfAccumulatedFileSize;
import org.apache.logging.log4j.core.appender.rolling.action.IfAny;
import org.apache.logging.log4j.core.appender.rolling.action.IfFileName;
import org.apache.logging.log4j.core.appender.rolling.action.IfLastModified;
import org.apache.logging.log4j.core.appender.rolling.action.PathCondition;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class OrderMateLog {
    public static Logger LOG = LoggerContext.getContext((boolean)false).getLogger("OrderMate");
    private static final String DEFAULT_PATTERN = "%6p %d{dd MMM HH:mm:ss} [%t] %c %x %m%n";
    public static final String LOG_SIZE_STR = "10MB";
    public static final int MAX_LOG_NUM = 4;

    private static String getFileName(String logName, String directory) {
        String testLogs = System.getProperty("java.LOG.testing") == null ? "" : System.getProperty("java.LOG.testing");
        String fileName = "";
        if (testLogs.equals("true")) {
            OrderMate.LOG.info("Testing Logs enabled location changed to test-logs");
            System.out.println("\nTesting Logs enabled location changed to test-logs");
            fileName = "test-logs/" + logName + ".log";
        } else {
            fileName = directory == null || directory.isEmpty() ? OrderMate.LOG_DIR + logName + "/" + logName + ".log" : directory + File.separator + logName + ".log";
        }
        return fileName;
    }

    private static String createArchivedFilesPattern(String baseDirectory, String logName, String pattern) {
        String computedPattern = null;
        computedPattern = pattern == null ? baseDirectory + "\\Older\\%d{yyyy-MMMM-dd}\\" + logName + "-%d{yyyy-MMMM-dd}-%i.log.gz" : "C:\\OM-Logs\\" + logName + "\\" + logName + pattern;
        return computedPattern;
    }

    private static DeleteAction createDeleteAction(String logFileName, String baseDirectory, Configuration config) {
        Duration duration = Duration.parse((CharSequence)"P30D");
        IfAccumulatedFileSize ifAccumulatedFileSize = IfAccumulatedFileSize.createFileSizeCondition((String)"20MB", (PathCondition[])new PathCondition[0]);
        IfAccumulatedFileCount ifAccumulatedFileCount = IfAccumulatedFileCount.createFileCountCondition((int)60, null);
        IfLastModified ifLastModified = IfLastModified.createAgeCondition((Duration)duration, null);
        PathCondition[] pathConditions = new PathCondition[]{ifLastModified, ifAccumulatedFileSize, ifAccumulatedFileCount};
        IfAny ifAny = IfAny.createOrCondition((PathCondition[])pathConditions);
        IfFileName ifFileName = IfFileName.createNameCondition((String)("**/" + logFileName + "*.gz"), null, (PathCondition[])new PathCondition[]{ifAny});
        PathCondition[] deletePathCondition = new PathCondition[]{ifFileName};
        return DeleteAction.createDeleteAction((String)baseDirectory, (boolean)false, (int)5, (boolean)false, null, (PathCondition[])deletePathCondition, null, (Configuration)config);
    }

    public static Appender getDailyFileAppender(String logName, int numLogBackups, String baseDirectory, String pattern) {
        String logPattern = pattern == null ? DEFAULT_PATTERN : pattern;
        String computedPattern = OrderMateLog.createArchivedFilesPattern(baseDirectory, logName, null);
        LoggerContext loggerContext = LoggerContext.getContext((boolean)false);
        Configuration configuration = loggerContext.getConfiguration();
        PatternLayout patternLayout = PatternLayout.newBuilder().withPattern(logPattern).build();
        TimeBasedTriggeringPolicy timeBasedTriggeringPolicy = new TimeBasedTriggeringPolicy.Builder().withInterval(1).withModulate(false).build();
        SizeBasedTriggeringPolicy sizeBasedTriggeringPolicy = SizeBasedTriggeringPolicy.createPolicy((String)LOG_SIZE_STR);
        CompositeTriggeringPolicy compositeTriggeringPolicy = CompositeTriggeringPolicy.createPolicy((TriggeringPolicy[])new TriggeringPolicy[]{timeBasedTriggeringPolicy, sizeBasedTriggeringPolicy});
        DeleteAction deleteAction = OrderMateLog.createDeleteAction(logName, baseDirectory, configuration);
        Action[] customActions = new Action[]{deleteAction};
        DefaultRolloverStrategy rolloverStrategy = DefaultRolloverStrategy.newBuilder().withFileIndex("min").withMax(String.valueOf(4)).withMin("1").withCompressionLevelStr("9").withCustomActions(customActions).build();
        RollingRandomAccessFileAppender rollingRandomAccessFileAppender = RollingRandomAccessFileAppender.createAppender((String)OrderMateLog.getFileName(logName, baseDirectory), (String)computedPattern, (String)"true", (String)("RollingFileAppender" + logName), (String)"false", (String)"1024", (TriggeringPolicy)compositeTriggeringPolicy, (RolloverStrategy)rolloverStrategy, (Layout)patternLayout, null, (String)"true", null, null, (Configuration)configuration);
        rollingRandomAccessFileAppender.start();
        return rollingRandomAccessFileAppender;
    }

    private static ConsoleAppender createConsoleAppender(String name) {
        String consoleAppenderName = "ConsoleAppender" + name;
        PatternLayout patternLayout = PatternLayout.newBuilder().withPattern(DEFAULT_PATTERN).build();
        ConsoleAppender consoleAppender = ConsoleAppender.createAppender((Layout)patternLayout, null, (ConsoleAppender.Target)ConsoleAppender.Target.SYSTEM_OUT, (String)consoleAppenderName, (boolean)false, (boolean)false, (boolean)true);
        consoleAppender.start();
        return consoleAppender;
    }

    private static Appender createRollingFileAppender(String name, String parentLogFolder, String pattern) {
        Appender rollingFileAppender = null;
        rollingFileAppender = pattern == null ? OrderMateLog.getDailyFileAppender(name, 4, parentLogFolder, null) : OrderMateLog.getDailyFileAppender(name, 4, parentLogFolder, pattern);
        return rollingFileAppender;
    }

    private static Logger checkAndGetLogger(String loggerName) {
        Iterator allLoggers = LoggerContext.getContext((boolean)false).getLoggers().iterator();
        LoggerContext.getContext((boolean)false).getRootLogger().getAppenders();
        while (allLoggers.hasNext()) {
            Logger logger = (Logger)allLoggers.next();
            if (!loggerName.equals(logger.getName())) continue;
            return logger;
        }
        return null;
    }

    public static Logger createLogger(String parentLogFolder, String name, String pattern) {
        name = OMLogUtil.adjustLogFileName(name);
        String asyncAppenderName = "ASYNC" + name;
        Logger loggerWithSameName = OrderMateLog.checkAndGetLogger(asyncAppenderName);
        if (loggerWithSameName != null) {
            return loggerWithSameName;
        }
        OrderMate.LOG.info("Creating Logger with Name : " + name);
        LoggerContext loggerContext = LoggerContext.getContext((boolean)false);
        Configuration configuration = loggerContext.getConfiguration();
        ConsoleAppender consoleAppender = OrderMateLog.createConsoleAppender(name);
        Appender rollingFileAppender = OrderMateLog.createRollingFileAppender(name, parentLogFolder, pattern);
        configuration.addAppender((Appender)consoleAppender);
        configuration.addAppender(rollingFileAppender);
        AppenderRef ref1 = AppenderRef.createAppenderRef((String)rollingFileAppender.getName(), null, null);
        AppenderRef ref2 = AppenderRef.createAppenderRef((String)consoleAppender.getName(), null, null);
        AppenderRef[] refs = new AppenderRef[]{ref1, ref2};
        AsyncAppender asyncAppender = AsyncAppender.newBuilder().setBufferSize(1024).setBlocking(true).setAppenderRefs(refs).setConfiguration(configuration).setIncludeLocation(false).setName(asyncAppenderName).build();
        asyncAppender.start();
        configuration.addAppender((Appender)asyncAppender);
        AppenderRef asyncRef = AppenderRef.createAppenderRef((String)asyncAppenderName, null, null);
        AppenderRef[] asyncRefs = new AppenderRef[]{asyncRef};
        LoggerConfig loggerConfig = LoggerConfig.createLogger((boolean)false, (Level)Level.ALL, (String)asyncAppenderName, (String)"false", (AppenderRef[])asyncRefs, null, (Configuration)configuration, null);
        loggerConfig.addAppender((Appender)asyncAppender, Level.ALL, null);
        configuration.addLogger(asyncAppenderName, loggerConfig);
        loggerContext.updateLoggers();
        return loggerContext.getLogger(asyncAppenderName);
    }

    public static Logger createLogger(String parentLogFolder, String name) {
        return OrderMateLog.createLogger(parentLogFolder, name, null);
    }

    public static Logger createAppenderForLogger(String loggerName, String deviceParentFolder, String appenderName) {
        loggerName = OMLogUtil.adjustLogFileName(loggerName);
        String asyncAppenderName = "ASYNC" + loggerName;
        Appender appender = OrderMateLog.createRollingFileAppender(appenderName, deviceParentFolder, null);
        LoggerContext loggerContext = LoggerContext.getContext((boolean)false);
        Configuration configuration = loggerContext.getConfiguration();
        configuration.addAppender(appender);
        configuration.getLoggerConfig(asyncAppenderName).addAppender(appender, Level.INFO, null);
        loggerContext.updateLoggers();
        return loggerContext.getLogger(asyncAppenderName);
    }
}

