/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.assertion;

import au.com.ordermate.assertion.OMAssertion;
import au.com.ordermate.assertion.OMCheckedAssertion;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.Collection;
import junit.framework.Assert;

public class UTAssertions {
    public static OMAssertion objectsEqual(final Object obj1, final Object obj2) {
        return new OMCheckedAssertion(){

            @Override
            public void check() {
                if (obj1 != null && obj2 != null && !obj1.getClass().isAssignableFrom(obj2.getClass()) && !obj2.getClass().isAssignableFrom(obj1.getClass())) {
                    throw new IllegalArgumentException("Classes are of incompatible types : " + obj1.getClass() + " and :" + obj2.getClass());
                }
                Assert.assertEquals((Object)obj1, (Object)obj2);
            }
        };
    }

    public static OMAssertion collectionEmpty(final Collection collection) {
        return new OMCheckedAssertion(){

            @Override
            public void check() {
                Assert.assertTrue((boolean)collection.isEmpty());
            }
        };
    }

    public static OMAssertion collectionHasSize(final Collection collection, final int size) {
        return new OMCheckedAssertion(){

            @Override
            public void check() {
                Assert.assertEquals((int)collection.size(), (int)size);
            }
        };
    }

    public static <T> OMAssertion propertyEquals(final PropertiedObject p, final PropertiedObject.Property<T> prop, final Object value) {
        return new OMCheckedAssertion(){

            @Override
            public void check() {
                Assert.assertEquals(p.getPropertyValue(prop), (Object)value);
            }
        };
    }
}

