/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.configuration;

import au.com.ordermate.util.GuiUtils;
import au.com.ordermate.util.StringUtils;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URL;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import ordermate.OrderMate;
import ordermate.encryption.BlowfishEasy;

public class Config {
    private static Hashtable theConfig = null;
    private static BlowfishEasy blowfish;
    private static Boolean isDebugging;

    public static String decryptString(String cypherText) {
        if (blowfish == null) {
            blowfish = new BlowfishEasy("CUSTOMIS TAKING THE WORLD HEAD ON!");
        }
        String plainText = blowfish.decryptString(cypherText);
        return plainText;
    }

    public static boolean isDebuging() {
        if (isDebugging == null) {
            if (!Config.isConfigSetup()) {
                return false;
            }
            isDebugging = Config.getBooleanValue("debug");
        }
        return isDebugging;
    }

    public static synchronized String getStringValue(String key) {
        Config.checkConfigured();
        if (theConfig.get(key) instanceof String) {
            return (String)theConfig.get(key);
        }
        return "";
    }

    public static synchronized List<String> getStringListValue(String key) {
        Config.checkConfigured();
        if (theConfig.get(key) instanceof String) {
            return StringUtils.splitToList((String)theConfig.get(key), ",");
        }
        return Collections.emptyList();
    }

    public static synchronized String getDecryptedStringValue(String key) {
        String cypherText = Config.getStringValue(key);
        return Config.decryptString(cypherText);
    }

    public static synchronized int getIntValue(String key) {
        Config.checkConfigured();
        if (theConfig.get(key) instanceof String) {
            return Config.toInt((String)theConfig.get(key));
        }
        return 0;
    }

    public static synchronized Color getColorValue(String key) {
        Config.checkConfigured();
        if (theConfig.get(key) instanceof String) {
            return GuiUtils.makeColor(theConfig.get(key).toString());
        }
        return null;
    }

    public static synchronized double getDoubleValue(String key) {
        Config.checkConfigured();
        if (theConfig.get(key) instanceof String) {
            try {
                return Double.parseDouble((String)theConfig.get(key));
            }
            catch (NumberFormatException e) {
                OrderMate.LOG.warn("Error converting to double ...", (Throwable)e);
                return 0.0;
            }
        }
        return 0.0;
    }

    public static synchronized boolean getBooleanValue(String key) {
        Config.checkConfigured();
        String value = Config.getStringValue(key);
        if (value.length() > 0) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    public static synchronized void readConfigData(String fileName) throws IOException {
        theConfig = Config.readConfigData(Config.openConfigFile(fileName), theConfig);
    }

    public static synchronized Hashtable readConfigData(String fileName, Hashtable cfg) throws IOException {
        return Config.readConfigData(Config.openConfigFile(fileName), cfg);
    }

    public static synchronized Hashtable readConfigData(BufferedReader reader, Hashtable cfg) throws IOException {
        cfg = new Hashtable<String, String>();
        String theData = "";
        while ((theData = reader.readLine()) != null) {
            if ((theData = theData.trim()).startsWith("#") || theData.length() == 0) continue;
            int index = theData.indexOf("=");
            if (index > 0) {
                String key = theData.substring(0, index);
                String value = theData.substring(index + 1, theData.length());
                cfg.put(key, "" + value);
                continue;
            }
            OrderMate.LOG.error("Error in Config Format.." + theData, (Throwable)new IOException("Error in Config Format.." + theData));
        }
        return cfg;
    }

    private static void checkConfigured() {
        if (theConfig == null) {
            throw new IllegalStateException("Must call Config.readConfigData before config values can be read");
        }
    }

    public static boolean isConfigSetup() {
        return theConfig != null;
    }

    private static BufferedReader openConfigFile(String configFile) throws IOException {
        BufferedReader bufferedInput = null;
        try {
            FileInputStream fileInput = new FileInputStream(configFile);
            InputStreamReader dataInput = new InputStreamReader(fileInput);
            bufferedInput = new BufferedReader(dataInput);
        }
        catch (IOException e) {
            OrderMate.LOG.info("Couldn't open config file, trying from jar");
            InputStream fileInput = Config.class.getClassLoader().getResourceAsStream(configFile);
            if (fileInput == null) {
                URL url;
                try {
                    Class<?> serverManagerClass = Class.forName("javax.jnlp.ServiceManager");
                    Method lookupMethod = serverManagerClass.getMethod("lookup", String.class);
                    Object basicService = lookupMethod.invoke(null, "javax.jnlp.BasicService");
                    Method getCodeBaseMethod = basicService.getClass().getMethod("getCodeBase", new Class[0]);
                    URL codeBase = (URL)getCodeBaseMethod.invoke(basicService, new Object[0]);
                    url = new URL(codeBase.toExternalForm() + configFile);
                }
                catch (Exception e1) {
                    String hostname = InetAddress.getLocalHost().getHostName();
                    url = new URL("http://" + hostname + "/Webstart/" + configFile);
                }
                OrderMate.LOG.info("Couldn't open config file, trying from " + url);
                bufferedInput = Config.openReader(url);
            }
            InputStreamReader dataInput = new InputStreamReader(fileInput);
            bufferedInput = new BufferedReader(dataInput);
        }
        return bufferedInput;
    }

    private static BufferedReader openReader(URL url) throws IOException {
        int SLEEP_TIME = 1000;
        int MAX_ATTEMPTS = 60;
        int attempts = 0;
        while (true) {
            try {
                return new BufferedReader(new InputStreamReader(url.openStream()));
            }
            catch (IOException ioEx) {
                block6: {
                    if (attempts < 60) {
                        ++attempts;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException iEx) {
                            Thread.currentThread().interrupt();
                            break block6;
                        }
                        continue;
                    }
                }
                throw ioEx;
            }
            break;
        }
    }

    private static int toInt(String theData) {
        try {
            int theInt = new Integer(theData);
            return theInt;
        }
        catch (Exception e) {
            OrderMate.LOG.warn("Error converting to int ...", (Throwable)e);
            return 0;
        }
    }

    public static Hashtable getTheConfig() {
        return theConfig;
    }

    public static void setTheConfig(Hashtable theConfig) {
        Config.theConfig = theConfig;
    }
}

