/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.database;

import au.com.ordermate.database.DatabaseMaintenanceService;
import au.com.ordermate.guicore.task.TaskInterrupter;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.ObjectQuerySQLAdapter;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.DBConnectionInterface;
import ordermate.dbconnection.AbstractDatabaseConnection;

public class DatabaseMaintenanceServiceImpl
extends UnicastRemoteObject
implements DatabaseMaintenanceService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean checkDatabase(TaskInterrupter interrupter) throws RemoteException {
        boolean dbOK = true;
        DBConnectionInterface dc = this.createConnection();
        try {
            Iterator<String> it = this.getAllDatabaseTables(dc).iterator();
            while (it.hasNext() && dbOK && (interrupter == null || !interrupter.isInterrupt())) {
                String table = it.next();
                ResultSet result = null;
                try {
                    result = dc.executeQuery("CHECK TABLE " + table + " QUICK");
                    while (result.next() && dbOK) {
                        if (!result.getString("Msg_type").equals("error")) continue;
                        dbOK = false;
                    }
                }
                catch (Throwable throwable) {
                    dc.release(result);
                    throw throwable;
                    return dbOK;
                }
                dc.release(result);
            }
        }
        catch (SQLException e) {
            this.handleSQLError(e);
            return dbOK;
        }
        finally {
            this.closeConnection(dc);
        }
    }

    private void handleSQLError(SQLException e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean optimizeDatabase() throws RemoteException {
        DBConnectionInterface dc = this.createConnection();
        boolean dbOK = true;
        try {
            Iterator<String> it = this.getAllDatabaseTables(dc).iterator();
            while (it.hasNext() && dbOK) {
                String table = it.next();
                this.optimizeTable(table);
            }
        }
        catch (SQLException e) {
            this.handleSQLError(e);
        }
        finally {
            this.closeConnection(dc);
        }
        return dbOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void repair(TaskInterrupter interrupter) throws RemoteException {
        DBConnectionInterface dc = this.createConnection();
        try {
            ArrayList<String> tableNames = new ArrayList<String>();
            ResultSet rs = dc.executeQuery(this.getGetAllTablesQuery().toString());
            while (rs.next() && (interrupter == null || !interrupter.isInterrupt())) {
                tableNames.add(rs.getString(1));
            }
            dc.release(rs);
            Iterator it = tableNames.iterator();
            while (it.hasNext() && (interrupter == null || !interrupter.isInterrupt())) {
                String table = (String)it.next();
                dc.execute("REPAIR TABLE " + table);
            }
        }
        catch (SQLException e) {
            this.handleSQLError(e);
        }
        finally {
            this.closeConnection(dc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void repairAndOptimise(TaskInterrupter interrupter) throws RemoteException {
        DBConnectionInterface dc = this.createConnection();
        try {
            Iterator<String> it = this.getAllDatabaseTables(dc).iterator();
            while (it.hasNext() && (interrupter == null || !interrupter.isInterrupt())) {
                String table = it.next();
                dc.execute("REPAIR TABLE " + table);
                dc.execute("OPTIMIZE  TABLE " + table);
                dc.execute("ANALYZE TABLE " + table);
            }
        }
        catch (SQLException e) {
            this.handleSQLError(e);
        }
        finally {
            this.closeConnection(dc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean optimizeTable(String table) {
        block13: {
            result = null;
            dbOk = false;
            dc = this.createConnection();
            try {
                result = dc.executeQuery("OPTIMIZE TABLE " + table);
                while (result.next()) {
                    if (result.getString("Msg_type").equals("error")) {
                        dbOk = false;
                        continue;
                    }
                    dbOk = true;
                }
                dc.execute("ANALYZE TABLE " + table);
                ** try [egrp 1[TRYBLOCK] [0 : 98->109)] { 
            }
            catch (SQLException ex) {
                this.handleSQLError(ex);
                break block13;
            }
            finally {
                try {
                    dc.release(result);
                }
                catch (SQLException ex) {
                    OrderMate.LOG.warn("Error closing result set", (Throwable)ex);
                }
                this.closeConnection(dc);
            }
lbl-1000:
            // 1 sources

            {
                dc.release(result);
            }
lbl16:
            // 1 sources

            catch (SQLException ex) {
                OrderMate.LOG.warn("Error closing result set", (Throwable)ex);
            }
            this.closeConnection(dc);
        }
        return dbOk;
    }

    private DBConnectionInterface createConnection() {
        return AbstractDatabaseConnection.getDBConnectionInterface();
    }

    private void closeConnection(DBConnectionInterface dc) {
        dc.closeConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getAllDatabaseTables(DBConnectionInterface dc) throws SQLException {
        if (dc == null) {
            throw new IllegalStateException("Cannot use DBConnectionInterface if null, call createConnection() first.");
        }
        ArrayList<String> tableNames = new ArrayList<String>();
        ResultSet rs = null;
        try {
            rs = dc.executeQuery(this.getGetAllTablesQuery().toString());
            while (rs.next()) {
                tableNames.add(rs.getString(1));
            }
        }
        catch (Throwable throwable) {
            dc.release(rs);
            throw throwable;
        }
        dc.release(rs);
        return tableNames;
    }

    private ObjectQuery getGetAllTablesQuery() {
        return new ObjectQuerySQLAdapter("SHOW TABLES");
    }
}

