/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.dockets;

import au.com.ordermate.dockets.CharacterProcessor;
import au.com.ordermate.dockets.CommandSet;
import au.com.ordermate.dockets.PrintCommanderInterface;
import au.com.ordermate.dockets.PrinterBuffer;
import java.awt.image.RenderedImage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractPrintCommander
implements PrintCommanderInterface,
Serializable {
    public static final String ALIGN_ATTR = "align";
    public static final String LEFT_ATTR = "left";
    public static final String RIGHT_ATTR = "right";
    public static final String CENTER_ATTR = "center";
    public static final String CENTRE_ATTR = "centre";
    public static final String COLOR_ATTR = "color";
    public static final String RED_ATTR = "red";
    public static final String WEIGHT_ATTR = "weight";
    public static final String TALL_ATTR = "tall";
    public static final String BIG_ATTR = "big";
    public static final String WIDE_ATTR = "wide";
    public static final String INVERTED_ATTR = "inverted";
    public static final String INVERTED_TRUE = "true";
    public static final String UNDERLINE_ATTR = "underline";
    public static final String UNDERLINE_THIN = "thin";
    public static final String UNDERLINE_THICK = "thick";
    private static final int INITIAL_CAPACITY = 500;
    private final int lineWidth;
    private final CharacterProcessor characterProcessor;
    protected boolean supportsGraphics;
    private final int emptyLinesAtEnd;
    private Integer lastColWidth;
    private PrinterBuffer lineContentBuffer;
    private StringBuffer commandBuffer = new StringBuffer(500);
    private int lineOption;
    private String underlineOption;
    private String lineName;
    private int lineAlignment;
    private boolean lineInverted;
    private final List<String> columns = new ArrayList<String>();
    private final StringBuilder column = new StringBuilder(60);
    private boolean isBuildingColumn = false;

    protected AbstractPrintCommander(int width) {
        this(width, false, 14, null);
    }

    protected AbstractPrintCommander(int width, boolean printerSupportsGraphics, int linesAtEnd) {
        this(width, printerSupportsGraphics, linesAtEnd, null);
    }

    protected AbstractPrintCommander(int width, boolean printerSupportsGraphics, int linesAtEnd, CharacterProcessor cp) {
        this.lineWidth = width;
        this.supportsGraphics = printerSupportsGraphics;
        this.emptyLinesAtEnd = linesAtEnd;
        this.characterProcessor = cp;
    }

    protected void initBuffer() {
        this.lineContentBuffer = new PrinterBuffer(this.characterProcessor, this.getCommandsSet());
    }

    @Override
    public String getCommands() {
        return this.commandBuffer.toString();
    }

    @Override
    public void clear() {
        this.commandBuffer.delete(0, this.commandBuffer.length());
        this.lineContentBuffer.clear();
        this.column.delete(0, this.column.length());
        this.columns.clear();
        this.isBuildingColumn = false;
    }

    @Override
    public void startLine(Map attributes) {
        this.lineOption = this.getOptionCode(attributes);
        this.lineName = (String)attributes.get("name");
        this.lineAlignment = this.getAlignment(attributes);
        this.lineInverted = INVERTED_TRUE.equals(attributes.get(INVERTED_ATTR));
        this.underlineOption = (String)attributes.get(UNDERLINE_ATTR);
        this.printLineFormatting();
    }

    @Override
    public void endLine() {
        this.printNCol();
        this.flushLineBuffer();
    }

    @Override
    public void appendSpace() {
        this.append(this.getCommandsSet().getSpaceChar());
    }

    @Override
    public void append(String text) {
        if (this.isBuildingColumn) {
            this.column.append(text);
        } else {
            this.lineContentBuffer.append(text);
        }
    }

    @Override
    public void append(char aChar) {
        if (this.isBuildingColumn) {
            this.column.append(aChar);
        } else {
            this.lineContentBuffer.append(aChar);
        }
    }

    protected void appendPrinterCommand(String command) {
        this.lineContentBuffer.appendPrinterCommand(command);
    }

    @Override
    public void startText(Map attributes) {
    }

    @Override
    public void endText() {
    }

    @Override
    public void startColumn() {
        this.isBuildingColumn = true;
    }

    @Override
    public void endColumn() {
        this.isBuildingColumn = false;
        this.columns.add(this.column.toString());
        this.column.delete(0, this.column.length());
    }

    @Override
    public boolean supportsGraphics() {
        return this.supportsGraphics;
    }

    @Override
    public void setKanjiEnabled(boolean enabled) {
        this.commandBuffer.append(this.getCommandsSet().getEnableKanji(enabled));
    }

    @Override
    public void selectInternationalCharset(int charset) {
        this.commandBuffer.append(this.getCommandsSet().getSelectInternationalCharset(charset));
    }

    @Override
    public void selectCharacterTable(int tableCode) {
        this.commandBuffer.append(this.getCommandsSet().getSelectCharacterTable(tableCode));
    }

    @Override
    public void beep(String volume, String pause) {
        this.commandBuffer.append(this.getCommandsSet().getBeep(volume, pause));
    }

    @Override
    public void cutFull() {
        for (int i = 0; i < this.emptyLinesAtEnd; ++i) {
            this.commandBuffer.append(this.getCommandsSet().getBlankLine());
        }
        this.commandBuffer.append(this.getCommandsSet().getFullCut());
    }

    @Override
    public void cutHalf() {
        for (int i = 0; i < this.emptyLinesAtEnd; ++i) {
            this.commandBuffer.append('\n');
        }
        this.commandBuffer.append(this.getCommandsSet().getPartialCut());
    }

    @Override
    public void reset() {
        this.commandBuffer.append(this.getCommandsSet().reset());
    }

    @Override
    public void printHorizRule() {
        this.commandBuffer.append(this.getCommandsSet().getLineSeparator());
    }

    public CharacterProcessor getCharacterProcessor() {
        return this.characterProcessor;
    }

    public int getLineAlignment() {
        return this.lineAlignment;
    }

    public boolean isLineInverted() {
        return this.lineInverted;
    }

    public String getLineName() {
        return this.lineName;
    }

    public int getLineOption() {
        return this.lineOption;
    }

    public String getUnderlineOption() {
        return this.underlineOption;
    }

    public int getEmptyLinesAtEnd() {
        return this.emptyLinesAtEnd;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    @Override
    public void printBarcode(String value) {
        CommandSet commandsSet = this.getCommandsSet();
        if (commandsSet == null || commandsSet.getBarcode().isEmpty()) {
            return;
        }
        this.appendPrinterCommand(this.getCommandsSet().barcode);
        this.appendPrinterCommand(value);
        this.appendPrinterCommand(String.valueOf('\u0000'));
    }

    protected StringBuffer getCommandBuffer() {
        return this.commandBuffer;
    }

    protected List<String> getColumns() {
        return this.columns;
    }

    protected static boolean isOptionNormalSize(int options) {
        return (options & 4) == 0 && (options & 8) == 0;
    }

    protected static boolean isOptionWide(int options) {
        return (options & 4) != 0;
    }

    protected static boolean isOptionTall(int options) {
        return (options & 8) != 0;
    }

    protected static boolean isOptionColor(int options) {
        return (options & 2) != 0;
    }

    protected static boolean isOptionNone(int options) {
        return options == 0;
    }

    protected static boolean isThickUnderline(String option) {
        return UNDERLINE_THICK.equals(option);
    }

    protected static boolean isThinUnderline(String option) {
        return UNDERLINE_THIN.equals(option);
    }

    protected void flushLineBuffer() {
        this.commandBuffer.append(this.lineContentBuffer.toData());
        this.lineContentBuffer.clear();
    }

    protected abstract void printLineFormatting();

    @Override
    public abstract CommandSet getCommandsSet();

    protected String padColumns() {
        StringBuilder returnString = new StringBuilder();
        int totalChars = this.getLineWidth();
        int charsPerColumn = totalChars / this.columns.size();
        for (String currentColumn : this.columns) {
            if (currentColumn.length() >= charsPerColumn) {
                currentColumn = currentColumn.substring(0, charsPerColumn - 1);
            }
            int colLength = currentColumn.length();
            if (currentColumn.contains("\n")) {
                colLength -= currentColumn.lastIndexOf("\n");
            }
            returnString.append(currentColumn);
            int spacesToFill = charsPerColumn - colLength;
            for (int j = 0; j < spacesToFill; ++j) {
                returnString.append(this.getCommandsSet().getSpaceChar());
            }
        }
        return returnString.toString();
    }

    protected void padRight(String str, int charOffset, boolean isWide) {
        int lWidth;
        int padSpaces;
        int offset = charOffset;
        int strWidth = str.length();
        if (str.contains("\n")) {
            strWidth -= str.lastIndexOf("\n");
        }
        if ((padSpaces = (lWidth = !isWide ? this.lineWidth : this.lineWidth / 2) - strWidth - (offset %= lWidth)) < 0) {
            this.flushLineBuffer();
            this.append(this.getCommandsSet().getBlankLine());
            this.printLineFormatting();
            if (strWidth < lWidth) {
                this.padRight(str, 0, isWide);
            }
        } else {
            for (int i = 0; i < padSpaces; ++i) {
                this.append(this.getCommandsSet().getSpaceChar());
            }
        }
    }

    protected void printNCol() {
        if (!this.columns.isEmpty()) {
            String padded = this.padColumns();
            this.columns.clear();
            this.append(padded);
        }
    }

    private int getOptionCode(Map attributes) {
        String color;
        int options = 0;
        String weightStr = (String)attributes.get(WEIGHT_ATTR);
        if (weightStr != null) {
            if (TALL_ATTR.equalsIgnoreCase(weightStr)) {
                options |= 8;
            } else if (WIDE_ATTR.equalsIgnoreCase(weightStr)) {
                options |= 4;
            } else if (BIG_ATTR.equalsIgnoreCase(weightStr)) {
                options |= 8;
                options |= 4;
            }
        }
        if ((color = (String)attributes.get(COLOR_ATTR)) == null || color.length() == 0) {
            color = (String)attributes.get("colour");
        }
        if (color != null && RED_ATTR.equals(color)) {
            options |= 2;
        }
        return options;
    }

    private int getAlignment(Map lineNode) {
        int alignment = 0;
        String alignStr = (String)lineNode.get(ALIGN_ATTR);
        if (alignStr != null) {
            if (LEFT_ATTR.equals(alignStr)) {
                alignment = 0;
            } else if (RIGHT_ATTR.equals(alignStr)) {
                alignment = 2;
            } else if (CENTER_ATTR.equals(alignStr) || CENTRE_ATTR.equals(alignStr)) {
                alignment = 1;
            }
        }
        return alignment;
    }

    @Override
    public void setLastColWidth(Integer width) {
        this.lastColWidth = width;
    }

    @Override
    public Integer getLastColWidth() {
        return this.lastColWidth;
    }

    @Override
    public void printImage(RenderedImage image, boolean highDef) {
    }
}

