/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.dockets;

import au.com.ordermate.dockets.AbstractPrintCommander;
import au.com.ordermate.dockets.CBMCommandSet;
import au.com.ordermate.dockets.CharacterProcessor;
import au.com.ordermate.dockets.CommandSet;

public class CBMCommander
extends AbstractPrintCommander {
    private CBMCommandSet commandsSet = new CBMCommandSet();

    public CBMCommander(int width) {
        this(width, 14, null);
    }

    public CBMCommander(int width, int linesAtEnd, CharacterProcessor cp) {
        super(width, false, linesAtEnd, cp);
        this.initBuffer();
    }

    @Override
    public void printHorizRule() {
        this.getCommandBuffer().append(this.commandsSet.getBlackColourPrint());
        int width = this.getLineWidth();
        for (int i = 0; i < width; ++i) {
            this.getCommandBuffer().append('-');
        }
        this.getCommandBuffer().append('\n');
    }

    @Override
    public void printImage(int imageNum) {
    }

    @Override
    public void setKanjiEnabled(boolean enabled) {
    }

    @Override
    public void selectInternationalCharset(int nationCode) {
    }

    protected static boolean isOptionTall(int options) {
        return (options & 4) != 0 || (options & 8) != 0;
    }

    protected static boolean isOptionWide(int options) {
        return (options & 4) != 0 || (options & 8) != 0;
    }

    @Override
    public void selectCharacterTable(int tableCode) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void printLineFormatting() {
        if (CBMCommander.isOptionWide(this.getLineOption())) {
            this.appendPrinterCommand(this.commandsSet.getDoubleHeightWidthChar());
        }
        if (CBMCommander.isOptionColor(this.getLineOption())) {
            this.appendPrinterCommand(this.commandsSet.getRedColourPrint());
        }
    }

    @Override
    public CommandSet getCommandsSet() {
        return this.commandsSet;
    }

    @Override
    public void endLine() {
        super.endLine();
        this.getCommandBuffer().append(this.getCommandsSet().getBlankLine());
    }

    @Override
    protected void printNCol() {
        if (this.getColumns().size() == 2) {
            this.printDoubleCol();
        } else {
            super.printNCol();
        }
    }

    protected void printDoubleCol() {
        String col1 = this.getColumns().get(0);
        String col2 = this.getColumns().get(1);
        this.getColumns().clear();
        boolean wide = CBMCommander.isOptionWide(this.getLineOption());
        String[] lines = CBMCommander.getAsLines(col1, this.getLineWidth(), wide);
        for (int i = 0; i < lines.length; ++i) {
            this.printLineFormatting();
            this.append(lines[i]);
        }
        int lastLineLength = lines[lines.length - 1].length();
        lines = CBMCommander.getAsLines(col2, this.getLineWidth(), wide);
        for (int i = 0; i < lines.length; ++i) {
            this.printLineFormatting();
            this.padRight(lines[i], lastLineLength, wide);
            this.printLineFormatting();
            this.append(lines[i]);
            lastLineLength = 0;
        }
        this.append(this.getCommandsSet().getBlankLine());
    }

    private static String[] getAsLines(String text, int lineWidth, boolean wide) {
        int textLength = text.length();
        int lWidth = !wide ? lineWidth : lineWidth / 2;
        int numLines = textLength / lWidth;
        if (textLength % lWidth != 0) {
            ++numLines;
        }
        String[] retval = new String[numLines];
        for (int i = 0; i < numLines; ++i) {
            int startIndex = i * lWidth;
            if (startIndex >= textLength) continue;
            int endIndex = startIndex + lWidth;
            if (endIndex > textLength) {
                endIndex = textLength;
            }
            retval[i] = text.substring(startIndex, endIndex);
        }
        return retval;
    }

    @Override
    public void printQrCode(String value) {
    }

    @Override
    public void printBarcodeImage(String value, int width, int height) {
    }
}

