/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.dockets;

import au.com.ordermate.dockets.AbstractPrintCommander;
import au.com.ordermate.dockets.CommandSet;
import java.awt.image.RenderedImage;

public class DebugCommander
extends AbstractPrintCommander {
    private CommandSet commandSet = new DebugCommandSet();

    public DebugCommander(int width) {
        this(width, 14);
    }

    public DebugCommander(int width, int linesAtEnd) {
        super(width, false, linesAtEnd);
        this.initBuffer();
    }

    @Override
    public void printHorizRule() {
        for (int i = 0; i < this.getLineWidth(); ++i) {
            this.getCommandBuffer().append('-');
        }
        this.getCommandBuffer().append('\n');
    }

    @Override
    public void printImage(int imageNum) {
        this.getCommandBuffer().append("(IMAGE" + imageNum + ")\n");
    }

    @Override
    protected void printLineFormatting() {
        this.printAlign(this.getLineAlignment());
        this.printLineOption();
        this.append(' ');
    }

    @Override
    public CommandSet getCommandsSet() {
        return this.commandSet;
    }

    @Override
    protected void printNCol() {
        if (this.getColumns().size() == 2) {
            String column1 = this.getColumns().get(0);
            String column2 = this.getColumns().get(1);
            this.getColumns().clear();
            this.append(column1);
            this.endLine();
            this.printLineFormatting();
            this.append(column2);
            this.endLine();
        } else {
            super.printNCol();
        }
    }

    @Override
    public void endLine() {
        super.endLine();
        this.getCommandBuffer().append(this.getCommandsSet().getBlankLine());
    }

    private void printLineOption() {
        int options = this.getLineOption();
        if (DebugCommander.isOptionColor(options)) {
            this.append("(COLOR)");
        }
        if (DebugCommander.isOptionTall(options)) {
            this.append("(TALL)");
        }
        if (DebugCommander.isOptionWide(options)) {
            this.append("(WIDE)");
        }
        if (DebugCommander.isOptionNone(options)) {
            this.append("(NONE)");
        }
        if (this.isLineInverted()) {
            this.append("(INV)");
        }
        if (DebugCommander.isThickUnderline(this.getUnderlineOption())) {
            this.append("(UND_THICK)");
        } else if (DebugCommander.isThinUnderline(this.getUnderlineOption())) {
            this.append("(UND_THIN)");
        }
    }

    private void printAlign(int align) {
        if (align == 1) {
            this.append("\t\t");
        } else if (align == 2) {
            this.append("\t\t\t\t");
        }
    }

    @Override
    public void printQrCode(String value) {
        this.append("[QR]" + value + "[QR]\r\n");
    }

    @Override
    public void printBarcodeImage(String value, int width, int height) {
        this.append("[IMGBARCODE]" + value + "[IMGBARCODE]\r\n");
    }

    @Override
    public void printImage(RenderedImage image, boolean highDef) {
        this.append("[IMAGE]" + image.getHeight() + " x " + image.getWidth() + "[IMAGE]");
    }

    public void setCanSupportGraphics(boolean b) {
        this.supportsGraphics = b;
    }

    private static class DebugCommandSet
    extends CommandSet {
        public DebugCommandSet() {
            this.barcode = "(BARCODE)";
        }

        @Override
        public String getSetLineSpacing(int lineSpacing) {
            return "";
        }

        @Override
        public String getBeep(String volume, String pause) {
            return "";
        }

        @Override
        public String getEnableKanji(boolean enabled) {
            return "(KANJI=" + (enabled ? "enabled" : "disabled") + ")\n";
        }

        @Override
        public String getFullCut() {
            return "(CUT FULL)\n";
        }

        @Override
        public String getPartialCut() {
            return "(CUT HALF)\n";
        }

        @Override
        public String reset() {
            return "(RESET)\n";
        }

        @Override
        public String getSelectCharacterTable(int table) {
            return "(SELECT CHARACTER SET=" + table + ")\n";
        }

        @Override
        public String getSelectInternationalCharset(int nationCode) {
            return "(SELECT INTERNATIONAL CHARSET=" + nationCode + ")\n";
        }
    }
}

