/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.dockets;

import au.com.ordermate.dockets.CommandSet;
import au.com.ordermate.util.image.ImageHelper;
import java.awt.Image;
import java.awt.image.RenderedImage;

public class ESCPOSCommandSet
extends CommandSet {
    public static final int CHARSET_USA = 0;
    public static final int CHARSET_FRANCE = 1;
    public static final int CHARSET_GERMANY = 2;
    public static final int CHARSET_UK = 3;
    public static final int CHARSET_DENMARK1 = 4;
    public static final int CHARSET_SWEDEN = 5;
    public static final int CHARSET_ITALY = 6;
    public static final int CHARSET_SPAIN1 = 7;
    public static final int CHARSET_JAPAN = 8;
    public static final int CHARSET_NORWAY = 9;
    public static final int CHARSET_DENMARK2 = 10;
    public static final int CHARSET_SPAIN2 = 11;
    public static final int CHARSET_LATIN_AMERICA = 12;
    public static final int CHARSET_KOREA = 13;
    public static final int CHARSET_SLOVENIA_CROATIA = 14;
    public static final int CHARSET_CHINA = 15;
    private static final char QUIET = '2';
    private static final char LOUD = '\u00ff';
    private static final char SHORT = '2';
    private static final char LONG = '\u00ff';
    private static final char MEDIUM = '\u0096';
    private static final int BARCODE_MIN_WIDTH = 2;
    private static final int BARCODE_MAX_WIDTH = 6;
    private static final char BARCODE_WIDTH_CHAR = 'w';
    private static final int BARCODE_MIN_HEIGHT = 1;
    private static final int BARCODE_MAX_HEIGHT = 255;
    private static final char BARCODE_HEIGHT_CHAR = 'h';
    private static final int BARCODE_DEFAULT_HEIGHT = 80;
    private static final int BARCODE_MIN_PRINT_POS = 0;
    private static final int BARCODE_PRINT_POS_DEFAULT = 2;
    private static final int BARCODE_MAX_PRINT_POS = 3;
    private static final char BARCODE_PRINT_POS_CHAR = 'H';
    private static final int BARCODE_TYPE_RANGE_A_MIN = 0;
    private static final int BARCODE_TYPE_RANGE_A_MAX = 6;
    private static final int BARCODE_TYPE_RANGE_B_MIN = 65;
    private static final int BARCODE_TYPE_RANGE_B_MAX = 78;
    private static final char BARCODE_TYPE_CHAR = 'k';
    private static final int BARCODE_TYPE_DEFAULT = 74;
    private static final int MAX_GRAPHICS_WIDTH = 255;

    public ESCPOSCommandSet() {
        this.setESCPOS();
    }

    private void setESCPOS() {
        this.FullCut = "\u001bi";
        this.PartialCut = "\u001bm";
        this.PageLengthSet = "\u001bC\f";
        this.FormFeed = "\u001bf\u0001";
        this.SkipLines = "\u001bN\f";
        this.CancelSkip = "\u001bO";
        this.LineSeparator = "---------------------------------";
        this.headerImage = "\u001cp\u0001\u0000";
        this.separatorImage = "\u001cp\u0002\u0000";
        this.footerImage = "\u001cp\u0003\u0000";
        this.RedColourPrint = "\u001br\u0001";
        this.BlackColourPrint = "\u001br\u0000";
        this.Emphasized = "\u001b!\b";
        this.WidthChar = "\u001b!\u0000";
        this.DoubleWidthChar = "\u001b! ";
        this.DoubleHeightChar = "\u001b!\u0010";
        this.UnderlineThinChar = "\u001b-\u0001";
        this.UnderlineThickChar = "\u001b-\u0002";
        this.NormalWidthChar = "\u001b!\u0000";
        this.DoubleHeightWidthChar = "\u001b!0";
        this.CharSizeBig = "G!";
        this.CharSizeSmall = "G!\u0000";
        this.ReverseBRon = "GB\u0001";
        this.ReverseBRoff = "GB\u0002";
        this.LeftAlign = "\u001ba\u0000";
        this.CenterAlign = "\u001ba\u0001";
        this.RightAlign = "\u001ba\u0002";
        this.invertedEnabled = "\u001dB\u0001";
        this.invertedDisabled = "\u001dB\u0000";
        this.barcode = this.CenterAlign + '\u001d' + 'w' + '\u0004' + '\u001d' + 'h' + '\u0080' + '\u001d' + 'H' + '\u0000' + '\u001d' + 'k' + '\u0002';
        this.enableKanji = "\u001c&";
        this.cancelKanji = "\u001c.";
        this.bigKanji = "\u001cW\u0001";
        this.littleKanji = "\u001cW\u0000";
        this.MaxWidth = 37;
        this.CrAfterItem = false;
        this.initialise = "\u001b@";
    }

    @Override
    public String getSetLineSpacing(int lineSpacing) {
        return "\u001b3" + (char)lineSpacing;
    }

    @Override
    public String getSetDefaultLineSpacing() {
        return "\u001b2";
    }

    @Override
    public String getBeep(String volume, String pause) {
        char vol = volume.equalsIgnoreCase("quiet") ? (char)'2' : (volume.equalsIgnoreCase("medium") ? (char)'\u0096' : '\u00ff');
        char pau = pause.equalsIgnoreCase("short") ? (char)'2' : (pause.equalsIgnoreCase("medium") ? (char)'\u0096' : '\u00ff');
        return "\u001bp\u0000" + vol + pau;
    }

    public String renderImage(RenderedImage toRender, boolean highDef) {
        boolean asRaster = false;
        if (asRaster) {
            return this.renderImageAsRaster(toRender, highDef);
        }
        return this.renderImageByBands(toRender, highDef);
    }

    public String renderImageByBands(RenderedImage toRender, boolean highDef) {
        ImageHelper helper = new ImageHelper();
        Image image = (Image)((Object)toRender);
        StringBuilder SB = new StringBuilder();
        int width = image.getWidth(null);
        int m = 0;
        if (highDef) {
            m = 33;
        }
        int numCols = width;
        int nh = numCols / 256;
        int nl = numCols % 256;
        SB.append('\u001b').append('3').append('0');
        byte[][] bytes = highDef ? helper.asTwoToneByteArrayByteBanded((RenderedImage)((Object)image), 3) : helper.asTwoToneByteArrayByteBanded((RenderedImage)((Object)image));
        for (byte[] nextRow : bytes) {
            SB.append('\u001b').append('*').append((char)m).append((char)nl).append((char)nh);
            SB.append(new String(nextRow));
            SB.append('\n');
        }
        return SB.toString();
    }

    public String renderImageAsRaster(RenderedImage toRender, boolean highDef) {
        StringBuilder SB = new StringBuilder();
        ImageHelper helper = new ImageHelper();
        Image image = helper.fitImageTo((Image)((Object)toRender), 512, 1024);
        int height = image.getHeight(null);
        char[] bytes = helper.asTwoToneByteArray((RenderedImage)((Object)image));
        int width = 8 * bytes.length / height;
        System.out.println(height + "x" + width + "=" + width * height + " vs " + bytes.length * 8);
        int m = 48;
        int fn = 112;
        int a = 48;
        int pl = (10 + bytes.length) % 256;
        int ph = (10 + bytes.length) / 256;
        boolean bx = true;
        boolean by = true;
        int c = 49;
        int xl = width % 256;
        int xh = width / 256;
        int yl = height % 256;
        int yh = height / 256;
        System.out.println("pl:" + pl + " ph:" + ph + " xl:" + xl + " xh:" + xh + " yl:" + yl + " yh:" + yh);
        SB.append('\u001d').append('(').append('L').append((char)pl).append((char)ph).append((char)m).append((char)fn).append((char)a).append((char)(bx ? 1 : 0)).append((char)(by ? 1 : 0)).append((char)c).append((char)xl).append((char)xh).append((char)yl).append((char)yh).append(new String(bytes));
        SB.append('\u001d').append('(').append('L').append('\u0002').append('\u0000').append('0').append('2');
        return SB.toString();
    }

    @Override
    public String getGenericBarcodeCommand(String value, int width, int height, int position, int barcodeType) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.CenterAlign);
        sb.append('\u001d');
        this.appendWidth(width, sb);
        sb.append('\u001d');
        this.appendHeight(height, sb);
        sb.append('\u001d');
        this.appendPrintPos(position, sb);
        sb.append('\u001d');
        this.appendBarcodeType(value, barcodeType, sb);
        return sb.toString();
    }

    private void appendBarcodeType(String value, int barcodeType, StringBuilder sb) {
        int theBarcodeType = barcodeType;
        if (!(barcodeType >= 0 && barcodeType <= 6 || barcodeType >= 65 && barcodeType <= 78)) {
            theBarcodeType = 74;
        }
        sb.append('k').append((char)theBarcodeType);
        if (theBarcodeType >= 65) {
            sb.append((char)value.length());
        }
    }

    private void appendPrintPos(int position, StringBuilder sb) {
        if (position < 0 || position > 3) {
            sb.append('H').append('\u0002');
        } else {
            sb.append('H').append((char)position);
        }
    }

    private void appendHeight(int height, StringBuilder sb) {
        if (height < 1 || height > 255) {
            sb.append('h').append('P');
        } else {
            sb.append('h').append((char)height);
        }
    }

    private void appendWidth(int width, StringBuilder sb) {
        if (width < 2 || width > 6) {
            sb.append('w').append('\u0002');
        } else {
            sb.append('w').append((char)width);
        }
    }
}

