/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.dockets;

import au.com.ordermate.dockets.AbstractPrintCommander;
import au.com.ordermate.dockets.CharacterProcessor;
import au.com.ordermate.dockets.CommandSet;
import au.com.ordermate.dockets.ESCPOSCommandSet;
import au.com.ordermate.util.image.BarcodeImageHelper;
import au.com.ordermate.util.image.ImageHelper;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.List;

public class ESCPOSCommander
extends AbstractPrintCommander {
    private ESCPOSCommandSet commandsSet;
    private boolean bigChinese = false;
    private List<String> leftColumn = new ArrayList<String>();
    private static final int BARCODE_WIDTH_DEFAULT = 160;
    private static final int BARCODE_HEIGHT_DEFAULT = 40;

    public ESCPOSCommander(int width) {
        this(width, false, 14, null);
    }

    public ESCPOSCommander(int width, boolean supportsGraphics, int linesAtEnd, CharacterProcessor cp) {
        super(width, supportsGraphics, linesAtEnd, cp);
        this.commandsSet = new ESCPOSCommandSet();
        this.initBuffer();
    }

    public void setBigChinese(boolean value) {
        this.bigChinese = value;
    }

    public boolean getBigChinese() {
        return this.bigChinese;
    }

    @Override
    public CommandSet getCommandsSet() {
        return this.commandsSet;
    }

    @Override
    public void printHorizRule() {
        if (!this.supportsGraphics()) {
            this.appendPrinterCommand(this.commandsSet.getNormalWidthChar());
            this.appendPrinterCommand(this.commandsSet.getBlackColourPrint());
            this.appendPrinterCommand(this.commandsSet.getCenterAlign());
            int width = this.getLineWidth();
            StringBuilder SB = new StringBuilder();
            for (int i = 0; i < width; ++i) {
                SB.append("-");
            }
            this.appendPrinterCommand(SB.toString());
            this.appendPrinterCommand(this.getCommandsSet().getBlankLine());
        } else {
            this.printImage(2);
        }
    }

    @Override
    public void printImage(int imageNum) {
        this.appendPrinterCommand(this.commandsSet.getLeftAlign());
        if (this.supportsGraphics()) {
            switch (imageNum) {
                case 1: {
                    this.appendPrinterCommand(this.commandsSet.getHeaderImage());
                    break;
                }
                case 2: {
                    this.appendPrinterCommand(this.commandsSet.getSeparatorImage());
                    break;
                }
                case 3: {
                    this.appendPrinterCommand(this.commandsSet.getFooterImage());
                }
            }
        }
    }

    @Override
    protected void printLineFormatting() {
        this.printLineOptions(this.getLineOption());
        this.printUnderlineOption(this.getUnderlineOption());
        this.printAlignment(this.getLineAlignment());
        if (this.isLineInverted()) {
            this.printInverted(true);
        }
        if (this.bigChinese) {
            this.appendPrinterCommand(this.commandsSet.getKanjiSize(true));
        }
    }

    @Override
    public void endLine() {
        super.endLine();
        if (this.isLineInverted()) {
            this.printInverted(false);
        }
        this.getCommandBuffer().append(this.getCommandsSet().getBlankLine());
    }

    @Override
    protected void printNCol() {
        if (this.getColumns().size() == 2) {
            this.printDoubleCol();
        } else {
            super.printNCol();
        }
    }

    protected void printDoubleCol() {
        int i;
        String[] lineSplit;
        String col1 = this.getColumns().get(0);
        String col2 = this.getColumns().get(1);
        this.getColumns().clear();
        this.leftColumn.clear();
        Integer lastColWidth = this.getLastColWidth();
        if (lastColWidth == null) {
            lastColWidth = 0;
        }
        int col1MaxWidth = this.getLineWidth() - lastColWidth;
        for (String nextSplit : lineSplit = col1.split("\r\n")) {
            if (nextSplit.length() <= col1MaxWidth) {
                this.leftColumn.add(nextSplit);
                continue;
            }
            String[] col1Split = nextSplit.split(" ");
            StringBuilder toAdd = new StringBuilder();
            for (int i2 = 0; i2 < col1Split.length; ++i2) {
                if (toAdd.length() + col1Split[i2].length() + 1 >= col1MaxWidth) {
                    this.leftColumn.add(toAdd.toString());
                    toAdd = new StringBuilder();
                }
                toAdd.append(col1Split[i2]);
                if (i2 >= col1Split.length) continue;
                toAdd.append(" ");
            }
            if (toAdd.length() <= 0) continue;
            this.leftColumn.add(toAdd.toString());
        }
        for (i = 0; i < this.leftColumn.size(); ++i) {
            if (!this.leftColumn.get(i).contains("\r\n")) continue;
            String[] splits = this.leftColumn.get(i).split("\r\n");
            this.leftColumn.set(i, splits[0]);
            for (int j = 1; j < splits.length; ++j) {
                this.leftColumn.add(i + j, splits[j]);
            }
            i += splits.length;
        }
        if (!this.leftColumn.isEmpty()) {
            this.append(this.leftColumn.get(0));
            this.padRight(col2, this.leftColumn.get(0).length(), ESCPOSCommander.isOptionWide(this.getLineOption()));
            this.append(col2);
            this.leftColumn.remove(0);
            if (!this.leftColumn.isEmpty()) {
                this.append("\r\n");
            }
            for (i = 0; i < this.leftColumn.size(); ++i) {
                this.append(this.leftColumn.get(i));
                if (i >= this.leftColumn.size() - 1) continue;
                this.append("\r\n");
            }
        } else {
            this.padRight(col2, 0, ESCPOSCommander.isOptionWide(this.getLineOption()));
            this.append(col2);
        }
    }

    private void printAlignment(int align) {
        if (align == 0) {
            this.appendPrinterCommand(this.commandsSet.getLeftAlign());
        } else if (align == 2) {
            this.appendPrinterCommand(this.commandsSet.getRightAlign());
        } else if (align == 1) {
            this.appendPrinterCommand(this.commandsSet.getCenterAlign());
        }
    }

    private void printInverted(boolean value) {
        this.appendPrinterCommand(this.commandsSet.getInverted(value));
    }

    private void printLineOptions(int options) {
        if (ESCPOSCommander.isOptionNormalSize(options)) {
            this.appendPrinterCommand(this.commandsSet.getNormalWidthChar());
        } else if (ESCPOSCommander.isOptionWide(options) && ESCPOSCommander.isOptionTall(options)) {
            this.appendPrinterCommand(this.commandsSet.getDoubleHeightWidthChar());
        } else if (ESCPOSCommander.isOptionWide(options)) {
            this.appendPrinterCommand(this.commandsSet.getDoubleWidthChar());
        } else if (ESCPOSCommander.isOptionTall(options)) {
            this.appendPrinterCommand(this.commandsSet.getDoubleHeightChar());
        }
        if (ESCPOSCommander.isOptionColor(options)) {
            this.appendPrinterCommand(this.commandsSet.getRedColourPrint());
        } else {
            this.appendPrinterCommand(this.commandsSet.getBlackColourPrint());
        }
    }

    private void printUnderlineOption(String option) {
        if (option != null) {
            if (ESCPOSCommander.isThickUnderline(option)) {
                this.appendPrinterCommand(this.commandsSet.getUnderlineThickChar());
            } else if (ESCPOSCommander.isThinUnderline(option)) {
                this.appendPrinterCommand(this.commandsSet.getUnderlineThinChar());
            }
        }
    }

    @Override
    public void printImage(RenderedImage image, boolean highDef) {
        if (image != null && this.supportsGraphics()) {
            this.appendPrinterCommand(this.commandsSet.renderImage(image, highDef));
        }
    }

    @Override
    public void printQrCode(String value) {
        ImageHelper helper = new ImageHelper();
        this.appendPrinterCommand(this.commandsSet.getCenterAlign());
        BufferedImage qrCode = new BarcodeImageHelper().makeQrCode(value, 160, 160);
        qrCode = (BufferedImage)helper.tintImage(qrCode, new Color(255, 0, 0, 255), 0.5f);
        this.printImage(qrCode, false);
        this.appendPrinterCommand("\n" + value + "\n");
        this.endLine();
    }

    @Override
    public void printBarcodeImage(String value, int width, int height) {
        ImageHelper helper = new ImageHelper();
        this.appendPrinterCommand(this.commandsSet.getCenterAlign());
        BufferedImage barcodeImg = new BarcodeImageHelper().makeCode128Barcode(value, this.getBarcodeWidth(width), this.getBarcodeHeight(height));
        barcodeImg = (BufferedImage)helper.tintImage(barcodeImg, new Color(255, 0, 0, 255), 0.5f);
        this.printImage(barcodeImg, false);
        this.appendPrinterCommand("\n" + value + "\n");
        this.endLine();
    }

    private int getBarcodeWidth(int width) {
        return width != -1 ? width : 160;
    }

    private int getBarcodeHeight(int height) {
        return height != -1 ? height : 40;
    }
}

