/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.dockets;

import au.com.ordermate.dockets.AbstractPrintCommander;
import au.com.ordermate.dockets.CommandSet;
import java.awt.image.RenderedImage;
import java.util.Iterator;
import java.util.Map;

public class HtmlCommander
extends AbstractPrintCommander {
    private static final String DOCKET_PREFIX = "<html><body style='font-family: Courier New; font-size: 11px;'>";
    private static final String DOCKET_SUFFIX = "</body></html>";
    private CommandSet commandSet = new HtmlCommandSet();
    private boolean spanOpened;
    static final String BARCODE_DEFAULT_COMMAND = "|  ||||| || | ||| | | |||  |<br>";
    static final String QRCODE_DEFAULT_CHAR = "#";
    static final String QRCODE_EMPTY_CHAR = "_";

    @Override
    public void printImage(int imNum) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public HtmlCommander(int width) {
        this(width, 14);
    }

    public HtmlCommander(int width, int linesAtEnd) {
        super(width, false, linesAtEnd);
        this.initBuffer();
        this.getCommandBuffer().append(DOCKET_PREFIX);
    }

    @Override
    public String getCommands() {
        return super.getCommands() + DOCKET_SUFFIX;
    }

    @Override
    protected void printLineFormatting() {
        StringBuilder style = new StringBuilder();
        this.buildSizeStyle(this.getLineOption(), style);
        this.buildAlignStyle(this.getLineAlignment(), style);
        this.buildBGStyle(this.isLineInverted(), style);
        this.buildUnderlineStyle(this.getUnderlineOption(), style);
        this.append("<div");
        if (this.getLineName() != null && !this.getLineName().isEmpty()) {
            this.append(" id='");
            this.append(this.getLineName());
            this.append("'");
        }
        if (style.length() > 0) {
            this.append(" style='");
            this.append(style.toString());
            this.append("'");
        }
        this.append(">");
    }

    @Override
    public void endLine() {
        this.printNCol();
        this.append("</div>\n");
        this.flushLineBuffer();
    }

    @Override
    public void startText(Map attributes) {
        String name = (String)attributes.get("name");
        if (name != null && !name.isEmpty()) {
            this.append("<span id='");
            this.append(name);
            this.append("'>");
            this.spanOpened = true;
        }
    }

    @Override
    public void endText() {
        if (this.spanOpened) {
            this.spanOpened = false;
            this.append("</span>");
        }
    }

    @Override
    public CommandSet getCommandsSet() {
        return this.commandSet;
    }

    private void buildAlignStyle(int align, StringBuilder style) {
        if (align == 1) {
            style.append(this.commandSet.getCenterAlign());
        } else if (align == 2) {
            style.append(this.commandSet.getRightAlign());
        } else if (align == 0) {
            style.append(this.commandSet.getLeftAlign());
        }
    }

    private void buildSizeStyle(int options, StringBuilder style) {
        if (HtmlCommander.isOptionColor(options)) {
            style.append(this.commandSet.getRedColourPrint());
        }
        if (HtmlCommander.isOptionTall(options) && !HtmlCommander.isOptionWide(options)) {
            style.append(this.commandSet.getDoubleHeightChar());
        } else if (HtmlCommander.isOptionTall(options) && HtmlCommander.isOptionWide(options)) {
            style.append(this.commandSet.getDoubleHeightWidthChar());
        } else if (!HtmlCommander.isOptionTall(options) && HtmlCommander.isOptionWide(options)) {
            style.append(this.commandSet.getDoubleWidthChar());
        }
    }

    private void buildBGStyle(boolean isInverted, StringBuilder style) {
        if (isInverted) {
            style.append(" background-color:#000000 ; color:#ffffff; ");
        }
    }

    private void buildUnderlineStyle(String underline, StringBuilder style) {
        if (HtmlCommander.isThickUnderline(underline) || HtmlCommander.isThinUnderline(underline)) {
            style.append(" text-decoration: underline ; ");
        }
    }

    @Override
    public void printBarcode(String value) {
        this.appendPrinterCommand(BARCODE_DEFAULT_COMMAND + value);
    }

    @Override
    protected void printNCol() {
        if (this.getColumns().size() > 0) {
            this.append("<table width='100%'><tr>");
            Iterator<String> i = this.getColumns().iterator();
            while (i.hasNext()) {
                this.append("<td>");
                this.append(i.next());
                this.append("</td>");
            }
            this.append("</tr></table>");
            this.getColumns().clear();
        }
    }

    @Override
    public void printQrCode(String value) {
        StringBuilder SB = new StringBuilder();
        for (int i = 0; i < 5; ++i) {
            SB.append("|");
            for (int j = 0; j < 5; ++j) {
                SB.append(Math.random() > 0.5 ? QRCODE_DEFAULT_CHAR : QRCODE_EMPTY_CHAR);
            }
            SB.append("|");
            SB.append("\n<br>");
        }
        SB.append(value);
        this.appendPrinterCommand(SB.toString());
    }

    @Override
    public void printBarcodeImage(String value, int width, int height) {
        this.printBarcode(value);
    }

    @Override
    public void printImage(RenderedImage image, boolean highDef) {
        this.appendPrinterCommand("[Image " + image.getWidth() + " x " + image.getHeight() + "]");
    }

    public static class HtmlCommandSet
    extends CommandSet {
        private static final String RESET = "<sub>(RESET)</sub>\n";
        private static final String NEW_LINE = "<br/>\n";
        private static final String RED_STYLE = " color: Red;";
        private static final String NORMAL_STYLE = " font-family: Courier New; font-size: 11px;";
        private static final String BIG_STYLE = " font-family: Courier New; font-size: 22px;";
        private static final String TALL_STYLE = " font-family: Courier Tall; font-size: 11px;";
        private static final String LARGE_STYLE = " font-family: Courier Wide; font-size: 11px;";
        private static final String CUT_FULL = "<hr style='height: 5px; color: Red; background-color: Red;'/>\n";
        private static final String CUT_HALF = "<hr style='height: 2px; color: WhiteSmoke; background-color: WhiteSmoke;'/>\n";
        private static final String HR = "<hr style='height: 3px;'/>\n";
        private static final String TEXT_ALIGN_LEFT = " text-align: left;";
        private static final String TEXT_ALIGN_CENTER = " text-align: center;";
        private static final String TEXT_ALIGN_RIGHT = " text-align: right;";
        private static final String HEADER_IMAGE = "<img src='http://www.ordermate.com.au/images/top_logo.gif'>\n";
        private static final String KANJI_ENABLED = "<sub>(KANJI)</sub>\n";
        private static final String SPACE_CHAR = "&nbsp;";

        @Override
        public String getBlankLine() {
            return NEW_LINE;
        }

        @Override
        public String getCenterAlign() {
            return TEXT_ALIGN_CENTER;
        }

        @Override
        public String getDoubleHeightChar() {
            return TALL_STYLE;
        }

        @Override
        public String getDoubleHeightWidthChar() {
            return BIG_STYLE;
        }

        @Override
        public String getDoubleWidthChar() {
            return LARGE_STYLE;
        }

        @Override
        public String getFullCut() {
            return CUT_FULL;
        }

        @Override
        public String getLeftAlign() {
            return TEXT_ALIGN_LEFT;
        }

        @Override
        public String getLineSeparator() {
            return HR;
        }

        @Override
        public String getNormalWidthChar() {
            return NORMAL_STYLE;
        }

        @Override
        public String getPartialCut() {
            return CUT_HALF;
        }

        @Override
        public String getRedColourPrint() {
            return RED_STYLE;
        }

        @Override
        public String getRightAlign() {
            return TEXT_ALIGN_RIGHT;
        }

        @Override
        public String reset() {
            return "<sub>(RESET)</sub>\n<br/>\n";
        }

        @Override
        public String getSetLineSpacing(int lineSpacing) {
            return "";
        }

        @Override
        public String getBeep(String volume, String pause) {
            return "";
        }

        @Override
        public String getSelectCharacterTable(int table) {
            return "<sub>(SELECT CHARACTER SET=" + table + ")</sub>" + NEW_LINE;
        }

        @Override
        public String getSelectInternationalCharset(int nationCode) {
            return "<sub>(SELECT INTERNATIONAL CHARSET=" + nationCode + ")</sub>" + NEW_LINE;
        }

        @Override
        public String getHeaderImage() {
            return HEADER_IMAGE;
        }

        @Override
        public String getEnableKanji(boolean enabled) {
            return "<sub>(KANJI)</sub>\n<br/>\n";
        }

        @Override
        public String getSpaceChar() {
            return SPACE_CHAR;
        }
    }
}

