/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.dockets;

import au.com.ordermate.dockets.AbstractPrintCommander;
import au.com.ordermate.dockets.CommandSet;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.Map;
import javax.swing.ImageIcon;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.misc.SystemCurrentInfo;

public class HtmlReceiptCommander
extends AbstractPrintCommander {
    private static final String DOCKET_PREFIX = "<html style='max-width: 500px; margin: auto; min-width: 280px;'><style> table { font-family: Inter, sans-serif; } .hide {display: none;}</style><table style='width: 100%;'><tr><td/><td style='max-width: 500px; width: 500px; min-width: 280px;'><table style='width: 100%;'>";
    private static final String DOCKET_SUFFIX = "</table></td><td/></tr></table></html>";
    private HtmlCommandSet commandSet = new HtmlCommandSet();
    private boolean spanOpened;
    static final String BARCODE_DEFAULT_COMMAND = "|  ||||| || | ||| | | |||  |<br>";
    static final String QRCODE_DEFAULT_CHAR = "#";
    static final String QRCODE_EMPTY_CHAR = "_";

    @Override
    public void printImage(int imNum) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public HtmlReceiptCommander(int width) {
        this(width, 14);
    }

    public HtmlReceiptCommander(int width, int linesAtEnd) {
        super(width, false, linesAtEnd);
        this.initBuffer();
        this.getCommandBuffer().append(DOCKET_PREFIX);
        this.getCommandBuffer().append(this.getBusinessLogoImage());
        this.getCommandBuffer().append(this.getTopMessage());
    }

    public String getTopMessage() {
        return "<tr><td style='font-size: x-large; text-align: center; padding-bottom: 20px; padding-top: 20px;'>Thank you for visiting " + BusinessInfo.getInstance().getName() + "!</td></tr>";
    }

    public String getBusinessLogoImage() {
        String businessImage = "<tr><td style='text-align: center; padding: 20px 0 20px 0; font-size: xx-large;'>";
        String businessLogo = BusinessInfo.getInstance().getName();
        try {
            String logPath = BusinessInfo.getInstance().getLogo();
            if (StringUtils.isEmpty(logPath)) {
                String[] urlSplit = logPath.split("/");
                String fileName = urlSplit[urlSplit.length - 1];
                long redbackId = SystemCurrentInfo.getInstance().getRedbackId();
                fileName = fileName.replace(".", "-" + redbackId + ".");
                ImageIcon imageIcon = IconLoader.get(logPath);
                float height = imageIcon.getIconHeight();
                float width = imageIcon.getIconWidth();
                int newHeight = Math.round(height / width * 200.0f);
                businessLogo = "<img width='200' height='" + newHeight + "' src='cid:" + fileName + "' alt='" + BusinessInfo.getInstance().getName() + "'/>";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        businessImage = businessImage + businessLogo + "</td></tr>";
        return businessImage;
    }

    public static BufferedImage convertToBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bi = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D graphics2D = bi.createGraphics();
        graphics2D.drawImage(img, 0, 0, null);
        graphics2D.dispose();
        return bi;
    }

    @Override
    public String getCommands() {
        return super.getCommands() + DOCKET_SUFFIX;
    }

    @Override
    protected void printLineFormatting() {
        StringBuilder style = new StringBuilder();
        this.buildAlignStyle(this.getLineAlignment(), style);
        this.buildBGStyle(this.isLineInverted(), style);
        this.buildUnderlineStyle(this.getUnderlineOption(), style);
        this.append("<tr><td");
        if (this.getLineName() != null && !this.getLineName().isEmpty()) {
            this.append(" id='");
            this.append(this.getLineName());
            this.append("'");
        }
        if (style.length() > 0) {
            this.append(" style='");
            if (this.getLineName() != null && !this.getLineName().isEmpty()) {
                String temp = this.getLineName();
                if (this.getLineName().equals("totalcomponent price")) {
                    this.append("float: right; ");
                }
                if (this.getLineName().equals("business name") || this.getLineName().equals("business message")) {
                    this.append("display: none; ");
                }
                if (this.getLineName().equals("date time") || this.getLineName().equals("invoice num footer")) {
                    this.append("color: #673AB6; ");
                }
            }
            this.append(style.toString());
            this.append("'");
        }
        this.append(">");
    }

    @Override
    public void endLine() {
        this.printNCol();
        this.append("</td></tr>\n");
        this.flushLineBuffer();
    }

    @Override
    public void startText(Map attributes) {
        String name = (String)attributes.get("name");
        if (name != null && !name.isEmpty()) {
            this.append("<span id='");
            this.append(name);
            this.append("'>");
            this.spanOpened = true;
        }
    }

    @Override
    public void endText() {
        if (this.spanOpened) {
            this.spanOpened = false;
            this.append("</span>");
        }
    }

    @Override
    public CommandSet getCommandsSet() {
        return this.commandSet;
    }

    private void buildAlignStyle(int align, StringBuilder style) {
        if (align == 1) {
            style.append(this.commandSet.getCenterAlign());
        } else if (align == 2) {
            style.append(this.commandSet.getRightAlign());
        } else if (align == 0) {
            style.append(this.commandSet.getLeftAlign());
        }
    }

    private void buildSizeStyle(int options, StringBuilder style) {
        if (HtmlReceiptCommander.isOptionColor(options)) {
            // empty if block
        }
        if (!HtmlReceiptCommander.isOptionTall(options) || HtmlReceiptCommander.isOptionWide(options)) {
            if (HtmlReceiptCommander.isOptionTall(options) && HtmlReceiptCommander.isOptionWide(options)) {
                style.append(this.commandSet.getDoubleHeightWidthChar());
            } else if (HtmlReceiptCommander.isOptionTall(options) || HtmlReceiptCommander.isOptionWide(options)) {
                // empty if block
            }
        }
    }

    private void buildBGStyle(boolean isInverted, StringBuilder style) {
        if (isInverted) {
            style.append(" background-color:#000000 ; color:#ffffff; ");
        }
    }

    private void buildUnderlineStyle(String underline, StringBuilder style) {
        if (HtmlReceiptCommander.isThickUnderline(underline) || HtmlReceiptCommander.isThinUnderline(underline)) {
            style.append(" text-decoration: underline ; ");
        }
    }

    @Override
    public void printBarcode(String value) {
        this.appendPrinterCommand(BARCODE_DEFAULT_COMMAND + value);
    }

    @Override
    protected void printNCol() {
        if (this.getColumns().size() > 0) {
            this.append("<table width='100%'><tr>");
            for (String value : this.getColumns()) {
                String style = "padding: 0 5px 0 5px;";
                if (value.contains("totalcomponent")) {
                    style = style + " text-align: right;";
                    value = value.replace("&nbsp;", "");
                } else {
                    value = value.replaceFirst("&nbsp;", "");
                }
                this.append("<td style='" + style + "'>");
                this.append(value);
                this.append("</td>");
            }
            this.append("</tr></table>");
            this.getColumns().clear();
        }
    }

    @Override
    public void printQrCode(String value) {
        StringBuilder SB = new StringBuilder();
        for (int i = 0; i < 5; ++i) {
            SB.append("|");
            for (int j = 0; j < 5; ++j) {
                SB.append(Math.random() > 0.5 ? QRCODE_DEFAULT_CHAR : QRCODE_EMPTY_CHAR);
            }
            SB.append("|");
            SB.append("\n<br>");
        }
        SB.append(value);
        this.appendPrinterCommand(SB.toString());
    }

    @Override
    public void printBarcodeImage(String value, int width, int height) {
        this.printBarcode(value);
    }

    @Override
    public void printImage(RenderedImage image, boolean highDef) {
        this.appendPrinterCommand("[Image " + image.getWidth() + " x " + image.getHeight() + "]");
    }

    public static class HtmlCommandSet
    extends CommandSet {
        private static final String RESET = "";
        private static final String NEW_LINE = "";
        private static final String RED_STYLE = " color: Red;";
        private static final String PURPLE_STYLE = " color: #673AB6;";
        private static final String NORMAL_STYLE = " font-family: Inter, sans-serif;";
        private static final String BIG_STYLE = " font-size: 22px;";
        private static final String TALL_STYLE = " font-size: 11px;";
        private static final String LARGE_STYLE = " font-size: 11px;";
        private static final String CUT_FULL = "<tr><td><hr/></td></tr>\n";
        private static final String CUT_HALF = "<tr><td><hr style='height: 2px; color: WhiteSmoke; background-color: WhiteSmoke;'/></td></tr>\n";
        private static final String HR = "<tr><td><hr/></td></tr>\n";
        private static final String TEXT_ALIGN_LEFT = " text-align: left;";
        private static final String TEXT_ALIGN_CENTER = " text-align: center;";
        private static final String TEXT_ALIGN_RIGHT = " text-align: right;";
        private static final String HEADER_IMAGE = "";
        private static final String KANJI_ENABLED = "<sub>(KANJI)</sub>\n";
        private static final String SPACE_CHAR = "&nbsp;";

        @Override
        public String getBlankLine() {
            return "";
        }

        @Override
        public String getCenterAlign() {
            return TEXT_ALIGN_CENTER;
        }

        @Override
        public String getDoubleHeightChar() {
            return " font-size: 11px;";
        }

        @Override
        public String getDoubleHeightWidthChar() {
            return BIG_STYLE;
        }

        @Override
        public String getDoubleWidthChar() {
            return " font-size: 11px;";
        }

        @Override
        public String getFullCut() {
            return "<tr><td><hr/></td></tr>\n";
        }

        @Override
        public String getLeftAlign() {
            return TEXT_ALIGN_LEFT;
        }

        @Override
        public String getLineSeparator() {
            return "<tr><td><hr/></td></tr>\n";
        }

        @Override
        public String getNormalWidthChar() {
            return NORMAL_STYLE;
        }

        @Override
        public String getPartialCut() {
            return CUT_HALF;
        }

        @Override
        public String getRedColourPrint() {
            return RED_STYLE;
        }

        public String getPurpleColourPrint() {
            return PURPLE_STYLE;
        }

        @Override
        public String getRightAlign() {
            return TEXT_ALIGN_RIGHT;
        }

        @Override
        public String reset() {
            return "";
        }

        @Override
        public String getSetLineSpacing(int lineSpacing) {
            return "";
        }

        @Override
        public String getBeep(String volume, String pause) {
            return "";
        }

        @Override
        public String getSelectCharacterTable(int table) {
            return "<sub>(SELECT CHARACTER SET=" + table + ")</sub>" + "";
        }

        @Override
        public String getSelectInternationalCharset(int nationCode) {
            return "<sub>(SELECT INTERNATIONAL CHARSET=" + nationCode + ")</sub>" + "";
        }

        @Override
        public String getHeaderImage() {
            return "";
        }

        @Override
        public String getEnableKanji(boolean enabled) {
            return KANJI_ENABLED;
        }

        @Override
        public String getSpaceChar() {
            return SPACE_CHAR;
        }
    }
}

