/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.dockets;

import au.com.ordermate.dockets.CharacterProcessor;
import au.com.ordermate.dockets.CommandSet;
import java.io.Serializable;

public class PrinterBuffer
implements Serializable {
    public static final int CENTER_BUFFER = 0;
    public static final int SUBSCRIPT_BUFFER = 1;
    public static final int SUPERSCRIPT_BUFFER = 2;
    private final StringBuffer[] lineBuffers;
    private final CharacterProcessor charProcessor;
    private int visibleCharsSoFar = 0;
    private char lastProcessedChar;
    private final CommandSet commandsSet;

    public CharacterProcessor getCharProcessor() {
        return this.charProcessor;
    }

    public PrinterBuffer(CharacterProcessor processor, CommandSet cs) {
        if (cs == null) {
            throw new IllegalArgumentException("The command set cannot be set to null.");
        }
        this.charProcessor = processor;
        this.commandsSet = cs;
        this.lineBuffers = new StringBuffer[3];
        for (int i = 0; i < this.lineBuffers.length; ++i) {
            this.lineBuffers[i] = new StringBuffer();
        }
    }

    public void append(char ch) {
        if (this.isMultiPassEnabled()) {
            this.appendMultiPass(ch);
        } else {
            this.getCenterBuffer().append(ch);
        }
    }

    public void append(String str) {
        if (this.isMultiPassEnabled()) {
            for (int i = 0; i < str.length(); ++i) {
                this.appendMultiPass(str.charAt(i));
            }
        } else {
            this.getCenterBuffer().append(str);
        }
    }

    public void append(PrinterBuffer buffer) {
        if (this.isMultiPassEnabled()) {
            for (int i = 0; i < this.lineBuffers.length; ++i) {
                this.lineBuffers[i].append(buffer.lineBuffers[i]);
            }
        } else {
            buffer.getCenterBuffer().append(buffer.getCenterBuffer());
        }
    }

    public void appendPrinterCommand(String str) {
        this.getCenterBuffer().append(str);
        if (this.isMultiPassEnabled()) {
            for (int i = 0; i < str.length(); ++i) {
                this.getSuperScriptBuffer().append('\u0000');
                this.getSubScriptBuffer().append('\u0000');
            }
        }
    }

    public int length() {
        return this.getCenterBuffer().length();
    }

    private final void appendMultiPass(char ch) {
        StringBuffer supers = this.getSuperScriptBuffer();
        StringBuffer subs = this.getSubScriptBuffer();
        int bufferIndex = this.charProcessor.getBufferForChar(ch);
        char processed = this.charProcessor.processChar(ch, this.lastProcessedChar);
        this.lastProcessedChar = ch;
        switch (bufferIndex) {
            case 0: {
                boolean visible;
                boolean bl = visible = processed >= ' ';
                if (visible) {
                    ++this.visibleCharsSoFar;
                }
                this.getCenterBuffer().append(processed);
                char addToMinorBuffers = visible ? (char)' ' : '\u0000';
                supers.append(addToMinorBuffers);
                subs.append(addToMinorBuffers);
                break;
            }
            case 2: {
                if (supers.length() <= 0) break;
                supers.setCharAt(supers.length() - 1, processed);
                break;
            }
            case 1: {
                if (subs.length() <= 0) break;
                subs.setCharAt(subs.length() - 1, processed);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid buffer id: " + bufferIndex);
            }
        }
    }

    public void clear() {
        for (int i = 0; i < this.lineBuffers.length; ++i) {
            this.lineBuffers[i].delete(0, this.lineBuffers[i].length());
        }
        this.visibleCharsSoFar = 0;
        this.lastProcessedChar = '\u0000';
    }

    public String toData() {
        StringBuffer center = this.getCenterBuffer();
        if (this.isMultiPassEnabled()) {
            StringBuffer supers = this.getSuperScriptBuffer();
            StringBuffer subs = this.getSubScriptBuffer();
            boolean hasSupers = PrinterBuffer.hasDisplayableCharacters(supers);
            boolean hasSubs = PrinterBuffer.hasDisplayableCharacters(subs);
            for (int i = 0; i < center.length(); ++i) {
                if (supers.charAt(i) != '\u0000' && center.charAt(i) != '\n') continue;
                supers.setCharAt(i, center.charAt(i));
                subs.setCharAt(i, center.charAt(i));
            }
            StringBuilder sb = new StringBuilder(this.length() * 3);
            if (hasSupers || hasSubs) {
                sb.append(this.commandsSet.getSetLineSpacing(15));
            } else {
                sb.append(this.commandsSet.getSetDefaultLineSpacing());
            }
            if (hasSupers) {
                sb.append(supers);
                sb.append(this.commandsSet.getBlankLine());
            }
            sb.append(center);
            sb.append(this.commandsSet.getBlankLine());
            if (hasSubs) {
                sb.append(subs);
                sb.append(this.commandsSet.getBlankLine());
            }
            return sb.toString();
        }
        String result = this.getCenterBuffer().toString();
        return result;
    }

    private static boolean hasDisplayableCharacters(StringBuffer buffer) {
        for (int i = 0; i < buffer.length(); ++i) {
            if (buffer.charAt(i) <= ' ') continue;
            return true;
        }
        return false;
    }

    public boolean isMultiPassEnabled() {
        return this.charProcessor != null;
    }

    private StringBuffer getCenterBuffer() {
        return this.lineBuffers[0];
    }

    private StringBuffer getSubScriptBuffer() {
        return this.lineBuffers[1];
    }

    private StringBuffer getSuperScriptBuffer() {
        return this.lineBuffers[2];
    }
}

