/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.dockets;

import au.com.ordermate.dockets.CharacterProcessor;
import java.io.Serializable;

public class ThaiCharacterProcessor
implements CharacterProcessor,
Serializable {
    public static final char UNICODE_SARA_U = '\u0e38';
    public static final char UNICODE_SARA_UU = '\u0e39';
    public static final char UNICODE_PINTHU = '\u0e3a';
    public static final char TIS620_SARA_U = '\u00d8';
    public static final char TIS620_SARA_UU = '\u00d9';
    public static final char TIS620_PINTHU = '\u00da';
    public static final char UNICODE_MAI_HAN_AKAT = '\u0e31';
    public static final char UNICODE_SARA_I = '\u0e34';
    public static final char UNICODE_SARA_II = '\u0e35';
    public static final char UNICODE_SARA_UE = '\u0e36';
    public static final char UNICODE_SARA_UEE = '\u0e37';
    public static final char UNICODE_MAITAIKHU = '\u0e47';
    public static final char UNICODE_THANTHAKHAT = '\u0e4c';
    public static final char UNICODE_NIKHAHIT = '\u0e4d';
    public static final char UNICODE_YAMAKKAN = '\u0e4e';
    public static final char TIS620_MAI_HAN_AKAT = '\u00d1';
    public static final char TIS620_SARA_I = '\u00d4';
    public static final char TIS620_SARA_II = '\u00d5';
    public static final char TIS620_SARA_UE = '\u00d6';
    public static final char TIS620_SARA_UEE = '\u00d7';
    public static final char TIS620_MAITAIKHU = '\u00e7';
    public static final char TIS620_THANTHAKHAT = '\u00ec';
    public static final char TIS620_NIKHAHIT = '\u00ed';
    public static final char TIS620_YAMAKKAN = '\u00ee';
    public static final char UNICODE_MAI_EK = '\u0e48';
    public static final char UNICODE_MAI_THO = '\u0e49';
    public static final char UNICODE_MAI_TRI = '\u0e4a';
    public static final char UNICODE_MAI_CHATTAWA = '\u0e4b';
    public static final char TIS620_MAI_EK = '\u00e8';
    public static final char TIS620_MAI_THO = '\u00e9';
    public static final char TIS620_MAI_TRI = '\u00ea';
    public static final char TIS620_MAI_CHATTAWA = '\u00eb';

    @Override
    public char processChar(char thisChar, char lastProcessedChar) {
        char toReturn = thisChar;
        if (ThaiCharacterProcessor.isUnicodeThai(thisChar)) {
            char tisChar = ThaiCharacterProcessor.convertUnicodeToTIS620(thisChar);
            char tisLastChar = ThaiCharacterProcessor.convertUnicodeToTIS620(lastProcessedChar);
            toReturn = tisChar;
            if (ThaiCharacterProcessor.isUnicodeThaiSuperscript(thisChar) && ThaiCharacterProcessor.isUnicodeThaiSuperscript(lastProcessedChar)) {
                char tone = '\u0000';
                char vowel = '\u0000';
                boolean combine = false;
                if (ThaiCharacterProcessor.isTIS620Character_CombinableTone(tisChar) && ThaiCharacterProcessor.isTIS620Character_CombinableSuperscriptVowel(tisLastChar)) {
                    tone = tisChar;
                    vowel = tisLastChar;
                    combine = true;
                } else if (ThaiCharacterProcessor.isTIS620Character_CombinableSuperscriptVowel(tisChar) && ThaiCharacterProcessor.isTIS620Character_CombinableTone(tisLastChar)) {
                    tone = tisLastChar;
                    vowel = tisChar;
                    combine = true;
                }
                if (tone == '\u00ec' && vowel != '\u00d4') {
                    combine = false;
                }
                if (combine) {
                    toReturn = this.getCombinedChar(tone, vowel);
                }
            }
        }
        return toReturn;
    }

    private static boolean isTIS620Character_CombinableTone(char tis620Char) {
        return tis620Char >= '\u00e8' && tis620Char <= '\u00ec';
    }

    private static boolean isTIS620Character_CombinableSuperscriptVowel(char tis620Char) {
        return tis620Char == '\u00d1' || tis620Char >= '\u00d4' && tis620Char <= '\u00d7' || tis620Char == '\u00ed';
    }

    private char getCombinedChar(char tone, char vowel) {
        char combinedChar;
        int toneOffset;
        if (tone == '\u00ec' && vowel == '\u00d4') {
            return '\u0088';
        }
        switch (tone) {
            case '\u00e8': {
                toneOffset = 0;
                break;
            }
            case '\u00e9': {
                toneOffset = 1;
                break;
            }
            case '\u00ea': {
                toneOffset = 2;
                break;
            }
            case '\u00eb': {
                toneOffset = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid tone character 0x" + Integer.toHexString(tone));
            }
        }
        switch (vowel) {
            case '\u00d1': {
                combinedChar = (char)(128 + toneOffset);
                break;
            }
            case '\u00d4': {
                combinedChar = (char)(132 + toneOffset);
                break;
            }
            case '\u00d5': {
                combinedChar = (char)(137 + toneOffset);
                break;
            }
            case '\u00d6': {
                combinedChar = (char)(141 + toneOffset);
                break;
            }
            case '\u00d7': {
                combinedChar = (char)(145 + toneOffset);
                break;
            }
            case '\u00ed': {
                combinedChar = (char)(149 + toneOffset);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid vowel character 0x" + Integer.toHexString(vowel));
            }
        }
        return combinedChar;
    }

    @Override
    public int getBufferForChar(char ch) {
        int buffer = 0;
        if (ThaiCharacterProcessor.isUnicodeThai(ch)) {
            if (ThaiCharacterProcessor.isUnicodeThaiSuperscript(ch)) {
                buffer = 2;
            } else if (ThaiCharacterProcessor.isUnicodeThaiSubscript(ch)) {
                buffer = 1;
            }
        }
        return buffer;
    }

    private static char convertUnicodeToTIS620(char thaiUnicodeChar) {
        int codePoint = thaiUnicodeChar;
        return (char)(codePoint -= 3424);
    }

    private static boolean isUnicodeThaiSuperscript(char unicodeChar) {
        return unicodeChar == '\u0e31' || unicodeChar >= '\u0e34' && unicodeChar <= '\u0e37' || unicodeChar >= '\u0e47' && unicodeChar <= '\u0e4e';
    }

    private static boolean isUnicodeThaiSubscript(char unicodeChar) {
        return unicodeChar >= '\u0e38' && unicodeChar <= '\u0e3a';
    }

    private static boolean isUnicodeThai(char unicodeChar) {
        return unicodeChar >= '\u0e00' && unicodeChar <= '\u0e7f';
    }
}

