/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.dockets;

import au.com.ordermate.dockets.DocketImageFinder;
import au.com.ordermate.dockets.PrintCommanderInterface;
import au.com.ordermate.util.Pair;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.Stringifier;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import ordermate.OrderMate;
import ordermate.database.misc.SystemProperty;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLDocketScanner {
    private static final String DOCKET = "docket";
    private static final String NCOL = "ncol";
    private static final String DCOL = "dcol";
    private static final String LINE = "line";
    private static final String HR = "hr";
    private static final String IMAGE = "image";
    private final PrintCommanderInterface printer;
    private String timeFormat = "12h";
    private boolean ignoreVisible = false;
    private static DocumentBuilderFactory builder = DocumentBuilderFactory.newInstance();
    private Stringifier<String> stringifier;

    public XMLDocketScanner(PrintCommanderInterface printCommander) {
        this.printer = printCommander;
    }

    public void setStringifier(Stringifier<String> stringifier) {
        this.stringifier = stringifier;
    }

    public void setTimeFormat(String format) {
        this.timeFormat = format;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public boolean isIgnoreVisible() {
        return this.ignoreVisible;
    }

    public void setIgnoreVisible(boolean ignoreVisible) {
        this.ignoreVisible = ignoreVisible;
    }

    public String visitDocument(Document document, boolean isReprint) {
        Element element = document.getDocumentElement();
        if (element != null && DOCKET.equals(element.getTagName())) {
            this.visitElementDocket(element, isReprint);
        }
        String commands = this.printer.getCommands();
        this.printer.clear();
        return commands;
    }

    public String visitDocument(String xml, boolean isReprint) throws ParserConfigurationException, SAXException, IOException {
        InputSource is = new InputSource(new StringReader(xml));
        Document document = builder.newDocumentBuilder().parse(is);
        Element element = document.getDocumentElement();
        if (element != null && DOCKET.equals(element.getTagName())) {
            this.visitElementDocket(element, isReprint);
        }
        String commands = this.printer.getCommands();
        this.printer.clear();
        return commands;
    }

    void visitElementDocket(Element element, boolean isReprint) {
        this.printer.reset();
        NodeList nodes = element.getChildNodes();
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block4;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (nodeElement.getTagName().equals("beep")) {
                        this.visitElementBeep(nodeElement);
                        continue block4;
                    }
                    if (nodeElement.getTagName().equals("chartable")) {
                        this.visitElementChartable(nodeElement);
                        continue block4;
                    }
                    if (nodeElement.getTagName().equals("charset")) {
                        this.visitElementCharset(nodeElement);
                        continue block4;
                    }
                    if (nodeElement.getTagName().equals("cut")) {
                        this.visitElementCut(nodeElement);
                        continue block4;
                    }
                    if (HR.equals(nodeElement.getTagName())) {
                        this.visitElementHr(nodeElement);
                        continue block4;
                    }
                    if (IMAGE.equals(nodeElement.getTagName())) {
                        this.visitElementImage(nodeElement);
                        continue block4;
                    }
                    if (nodeElement.getTagName().equals("kanji")) {
                        this.visitElementKanji(nodeElement);
                        continue block4;
                    }
                    if (LINE.equals(nodeElement.getTagName())) {
                        this.visitElementLine(nodeElement);
                        continue block4;
                    }
                    if (nodeElement.getTagName().equals("noimage")) {
                        this.visitElementNoimage(nodeElement);
                        continue block4;
                    }
                    if (nodeElement.getTagName().equals("printImage")) {
                        this.visitElementPrintImage(nodeElement);
                        continue block4;
                    }
                    if (nodeElement.getTagName().equals("reprint") && isReprint) {
                        this.visitElementReprint(nodeElement);
                        continue block4;
                    }
                    if (DCOL.equals(nodeElement.getTagName())) {
                        this.visitElementDcol(nodeElement);
                        continue block4;
                    }
                    if (NCOL.equals(nodeElement.getTagName())) {
                        this.visitElementNcol(nodeElement);
                        continue block4;
                    }
                    if (nodeElement.getTagName().equals("barcode")) {
                        this.visitElementBarcode(nodeElement);
                        continue block4;
                    }
                    if (nodeElement.getTagName().equals("qr")) {
                        this.visitElementQr(nodeElement);
                        continue block4;
                    }
                    if (!nodeElement.getTagName().equals("imgbarcode")) continue block4;
                    this.visitElementBarcodeImage(nodeElement);
                    continue block4;
                }
            }
        }
        if (!element.getAttribute("cut").isEmpty()) {
            this.cut(element.getAttribute("cut"));
        }
    }

    void visitElementBeep(Element element) {
        String visible = element.getAttribute("visible");
        if (this.ignoreVisible || !visible.equals("false")) {
            String volume = element.getAttribute("volume");
            String pause = element.getAttribute("pause");
            this.printer.beep(volume, pause);
        }
    }

    void visitElementChartable(Element element) {
        String code = element.getAttribute("code");
        try {
            int tableCode = Integer.parseInt(code);
            this.printer.selectCharacterTable(tableCode);
        }
        catch (NumberFormatException e) {
            OrderMate.LOG.warn("<chartable> attribute \"code\" is an invalid number: '" + code + "'", (Throwable)e);
        }
    }

    void visitElementCharset(Element element) {
        String nation = element.getAttribute("nation");
        if (nation.equalsIgnoreCase("china")) {
            this.printer.selectInternationalCharset(15);
        } else if (nation.equalsIgnoreCase("usa")) {
            this.printer.selectInternationalCharset(0);
        } else {
            OrderMate.LOG.info("Charset ignored for " + nation);
        }
    }

    void visitElementCut(Element element) {
        String mode = element.getAttribute("mode");
        this.cut(mode);
    }

    void visitElementHr(Element element) {
        String visible = element.getAttribute("visible");
        if (this.ignoreVisible || !visible.equals("false")) {
            this.printer.printHorizRule();
        }
    }

    void visitElementImage(Element element) {
        String visible = element.getAttribute("visible");
        if (!visible.equalsIgnoreCase("false") && this.printer.supportsGraphics()) {
            int imNum = 1;
            String imNumStr = element.getAttribute("num");
            if (imNumStr.length() > 0) {
                try {
                    imNum = Integer.parseInt(imNumStr);
                }
                catch (NumberFormatException nfe) {
                    OrderMate.LOG.warn("Invalid image number " + imNumStr, (Throwable)nfe);
                }
            }
            this.printer.printImage(imNum);
        }
    }

    void visitElementPrintImage(Element element) {
        String visible = element.getAttribute("visible");
        if (!visible.equalsIgnoreCase("false") && this.printer.supportsGraphics()) {
            String group = element.getAttribute("group");
            String label = element.getAttribute("label");
            if (group != null && !group.isEmpty()) {
                RenderedImage image = DocketImageFinder.getInstance().findImage(group + "::" + label);
                String hiDef = element.getAttribute("hiDef");
                this.printer.printImage(image, "true".equals(hiDef));
            }
        }
    }

    void visitElementKanji(Element element) {
        boolean enabled;
        String enabledStr = element.getAttribute("enabled");
        if (enabledStr.equals("true")) {
            enabled = true;
        } else if (enabledStr.equals("false")) {
            enabled = false;
        } else {
            OrderMate.LOG.warn("Invalid kanji attribute value fro enabled " + enabledStr);
            return;
        }
        this.printer.setKanjiEnabled(enabled);
    }

    private boolean checkLineHasPrintableChild(Element line) {
        NodeList nodes = line.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element childElement;
            String elementNodeVisible;
            Node node = nodes.item(i);
            if (!(node.getNodeType() == 1 ? (elementNodeVisible = (childElement = (Element)node).getAttribute("visible")).equalsIgnoreCase("true") : node.getNodeType() == 3 && !node.getNodeValue().trim().isEmpty())) continue;
            return true;
        }
        return false;
    }

    private boolean checkCanPrintLine(Element line) {
        String visible = line.getAttribute("visible");
        String empty = line.getAttribute("empty");
        if (this.ignoreVisible) {
            return true;
        }
        if (!visible.equalsIgnoreCase("false")) {
            if (empty.equalsIgnoreCase("false")) {
                return this.checkLineHasPrintableChild(line);
            }
            return true;
        }
        return false;
    }

    void visitElementLine(Element element) {
        if (this.checkCanPrintLine(element)) {
            this.printer.startLine(this.getAttributes(element));
            NodeList nodes = element.getChildNodes();
            block6: for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                switch (node.getNodeType()) {
                    case 4: {
                        continue block6;
                    }
                    case 1: {
                        Element nodeElement = (Element)node;
                        if (nodeElement.getTagName().equals("sp")) {
                            this.visitElementSp(nodeElement);
                        }
                        if (nodeElement.getTagName().equals("tab")) {
                            this.visitElementTab(nodeElement);
                        }
                        if (nodeElement.getTagName().equals("pre")) {
                            this.visitElementPre(nodeElement);
                        }
                        if (nodeElement.getTagName().equals("time")) {
                            this.visitElementTime(nodeElement);
                        }
                        if (nodeElement.getTagName().equals("date")) {
                            this.visitElementDate(nodeElement);
                        }
                        if (nodeElement.getTagName().equals("barcode")) {
                            this.visitElementBarcode(nodeElement);
                            continue block6;
                        }
                        if (nodeElement.getTagName().equals("qr")) {
                            this.visitElementQr(nodeElement);
                            continue block6;
                        }
                        if (!nodeElement.getTagName().equals("imgbarcode")) continue block6;
                        this.visitElementBarcodeImage(nodeElement);
                        continue block6;
                    }
                    case 7: {
                        continue block6;
                    }
                    case 3: {
                        String nodeValue = this.extractValue(node, node);
                        if (nodeValue.trim().isEmpty()) continue block6;
                        this.printer.append(nodeValue);
                    }
                }
            }
            this.printer.endLine();
        }
    }

    void visitElementNoimage(Element element) {
        if (!this.printer.supportsGraphics()) {
            NodeList nodes = element.getChildNodes();
            block4: for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                switch (node.getNodeType()) {
                    case 4: {
                        continue block4;
                    }
                    case 1: {
                        Element nodeElement = (Element)node;
                        if (HR.equals(nodeElement.getTagName())) {
                            this.visitElementHr(nodeElement);
                        }
                        if (LINE.equals(nodeElement.getTagName())) {
                            this.visitElementLine(nodeElement);
                        }
                        if (DCOL.equals(nodeElement.getTagName())) {
                            this.visitElementDcol(nodeElement);
                        }
                        if (!NCOL.equals(nodeElement.getTagName())) continue block4;
                        this.visitElementNcol(nodeElement);
                        continue block4;
                    }
                }
            }
        }
    }

    void visitElementReprint(Element element) {
        NodeList nodes = element.getChildNodes();
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block4;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (HR.equals(nodeElement.getTagName())) {
                        this.visitElementHr(nodeElement);
                    }
                    if (LINE.equals(nodeElement.getTagName())) {
                        this.visitElementLine(nodeElement);
                    }
                    if (DCOL.equals(nodeElement.getTagName())) {
                        this.visitElementDcol(nodeElement);
                    }
                    if (!NCOL.equals(nodeElement.getTagName())) continue block4;
                    this.visitElementNcol(nodeElement);
                    continue block4;
                }
            }
        }
    }

    void visitElementDcol(Element element) {
        String visible = element.getAttribute("visible");
        String lastColWidth = element.getAttribute("lastColWidth");
        if (lastColWidth != null && !lastColWidth.isEmpty()) {
            Integer width = Integer.valueOf(lastColWidth);
            this.printer.setLastColWidth(width);
        }
        if (this.ignoreVisible || !visible.equals("false")) {
            this.printer.startLine(this.getAttributes(element));
            NodeList nodes = element.getChildNodes();
            block4: for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                switch (node.getNodeType()) {
                    case 4: {
                        continue block4;
                    }
                    case 1: {
                        Element nodeElement = (Element)node;
                        if (!nodeElement.getTagName().equals("col")) continue block4;
                        this.visitElementCol(nodeElement);
                        continue block4;
                    }
                }
            }
            this.printer.endLine();
        }
    }

    void visitElementNcol(Element element) {
        String visible = element.getAttribute("visible");
        if (this.ignoreVisible || !visible.equals("false")) {
            this.printer.startLine(this.getAttributes(element));
            NodeList nodes = element.getChildNodes();
            block4: for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                switch (node.getNodeType()) {
                    case 4: {
                        continue block4;
                    }
                    case 1: {
                        Element nodeElement = (Element)node;
                        if (!nodeElement.getTagName().equals("col")) continue block4;
                        this.visitElementCol(nodeElement);
                        continue block4;
                    }
                }
            }
            this.printer.endLine();
        }
    }

    void visitElementCol(Element element) {
        this.printer.startColumn();
        NodeList nodes = element.getChildNodes();
        block6: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: {
                    continue block6;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    if (nodeElement.getTagName().equals("sp")) {
                        this.visitElementSp(nodeElement);
                    }
                    if (nodeElement.getTagName().equals("tab")) {
                        this.visitElementTab(nodeElement);
                    }
                    if (nodeElement.getTagName().equals("pre")) {
                        this.visitElementPre(nodeElement);
                    }
                    if (nodeElement.getTagName().equals("time")) {
                        this.visitElementTime(nodeElement);
                    }
                    if (nodeElement.getTagName().equals("date")) {
                        this.visitElementDate(nodeElement);
                        continue block6;
                    }
                    if (!nodeElement.getTagName().equals("barcode")) continue block6;
                    this.visitElementBarcode(nodeElement);
                    continue block6;
                }
                case 7: {
                    continue block6;
                }
                case 3: {
                    String text = this.extractValue(element, node);
                    if (text.trim().isEmpty()) continue block6;
                    this.printer.append(text);
                }
            }
        }
        this.printer.endColumn();
    }

    void visitElementSp(Element element) {
        String visible = element.getAttribute("visible");
        if (this.ignoreVisible || !visible.equals("false")) {
            this.printer.appendSpace();
        }
    }

    void visitElementTab(Element element) {
        int numSpaces = 4;
        String sp = element.getAttribute("sp");
        if (sp.length() > 0) {
            try {
                numSpaces = Integer.parseInt(sp);
            }
            catch (NumberFormatException nfe) {
                OrderMate.LOG.info("Invalid space number for the <tab>", (Throwable)nfe);
            }
        }
        for (int i = 0; i < numSpaces; ++i) {
            this.printer.appendSpace();
        }
    }

    void visitElementPre(Element element) {
        String visible = element.getAttribute("visible");
        if (this.ignoreVisible || !visible.equals("false")) {
            this.printer.startText(this.getAttributes(element));
            NodeList nodes = element.getChildNodes();
            block6: for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                switch (node.getNodeType()) {
                    case 4: {
                        continue block6;
                    }
                    case 1: {
                        continue block6;
                    }
                    case 7: {
                        continue block6;
                    }
                    case 3: {
                        String nodeValue = this.extractValue(element, node);
                        if (nodeValue.trim().isEmpty()) continue block6;
                        this.printer.append(nodeValue);
                        continue block6;
                    }
                }
            }
            this.printer.endText();
        }
    }

    private String extractValue(Node element, Node node) {
        String nodeValue = node.getNodeValue();
        if (!nodeValue.trim().isEmpty()) {
            String replace = null;
            if (element instanceof Element) {
                replace = ((Element)element).getAttribute("replace");
            }
            if (StringUtils.isEmpty(replace)) {
                replace = ((Element)element.getParentNode()).getAttribute("replace");
            }
            if (!StringUtils.isEmpty(replace)) {
                nodeValue = this.performReplace(nodeValue, replace);
            }
            if (this.stringifier != null) {
                nodeValue = this.stringifier.stringify(nodeValue);
            }
            if (SystemProperty.getInstance().getSplitChinese()) {
                Pair<Character, Character> ignoreMarkers = null;
                String ignoreString = SystemProperty.getInstance().getIgnoreSplitChinese();
                if (ignoreString != null && ignoreString.length() > 1) {
                    ignoreMarkers = new Pair<Character, Character>(Character.valueOf(ignoreString.charAt(0)), Character.valueOf(ignoreString.charAt(1)));
                }
                nodeValue = StringUtils.splitForeignChars(nodeValue, "\r\n", ignoreMarkers);
            }
        }
        return nodeValue;
    }

    void visitElementBarcode(Element element) {
        String visible = element.getAttribute("visible");
        if (this.ignoreVisible || !visible.equals("false")) {
            NodeList nodes = element.getChildNodes();
            if (nodes == null || nodes.getLength() == 0) {
                return;
            }
            Node node = nodes.item(0);
            try {
                this.printer.printBarcode(node.getNodeValue());
            }
            catch (NumberFormatException ex) {
                OrderMate.LOG.warn("Cannot print barcode, number invalid:" + node.getNodeValue(), (Throwable)ex);
            }
        }
    }

    void visitElementBarcodeImage(Element element) {
        String visible = element.getAttribute("visible");
        if (this.ignoreVisible || !visible.equals("false")) {
            NodeList nodes = element.getChildNodes();
            if (nodes == null || nodes.getLength() == 0) {
                return;
            }
            Node node = nodes.item(0);
            try {
                this.printer.printBarcodeImage(node.getNodeValue(), this.convertToInt(element.getAttribute("width")), this.convertToInt(element.getAttribute("height")));
            }
            catch (NumberFormatException ex) {
                OrderMate.LOG.warn("Cannot print barcode image, number invalid:" + node.getNodeValue(), (Throwable)ex);
            }
        }
    }

    private int convertToInt(String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (Exception e) {
            return -1;
        }
    }

    void visitElementQr(Element element) {
        String visible = element.getAttribute("visible");
        if (this.ignoreVisible || !visible.equals("false")) {
            NodeList nodes = element.getChildNodes();
            if (nodes == null || nodes.getLength() == 0) {
                return;
            }
            Node node = nodes.item(0);
            try {
                this.printer.printQrCode(node.getNodeValue());
            }
            catch (NumberFormatException ex) {
                OrderMate.LOG.warn("Cannot print barcode, number invalid:" + node.getNodeValue(), (Throwable)ex);
            }
        }
    }

    void visitElementTime(Element element) {
        String visible = element.getAttribute("visible");
        if (this.ignoreVisible || !visible.equals("false")) {
            this.printer.startText(this.getAttributes(element));
            SimpleDateFormat formatter = this.timeFormat.equals("12h") ? new SimpleDateFormat("h:mm a") : new SimpleDateFormat("kk:mm:ss");
            this.printer.append(formatter.format(new Date()));
        }
    }

    void visitElementDate(Element element) {
        String visible = element.getAttribute("visible");
        if (this.ignoreVisible || !visible.equals("false")) {
            this.printer.startText(this.getAttributes(element));
            Calendar cal = Calendar.getInstance();
            String dayString = String.valueOf(cal.get(5));
            String monthString = String.valueOf(cal.get(2) + 1);
            if (dayString.length() == 1) {
                dayString = '0' + dayString;
            }
            if (monthString.length() == 1) {
                monthString = '0' + monthString;
            }
            this.printer.append(dayString + '-' + monthString + '-' + cal.get(1) + ' ');
        }
    }

    private void cut(String mode) {
        if (mode.equalsIgnoreCase("half")) {
            this.printer.cutHalf();
        } else {
            this.printer.cutFull();
        }
    }

    private Map getAttributes(Element element) {
        HashMap<String, String> retValue = new HashMap<String, String>();
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            retValue.put(attributes.item(i).getNodeName(), attributes.item(i).getNodeValue());
        }
        return retValue;
    }

    private String performReplace(String alterThis, String replace) {
        List<String> splits = StringUtils.splitToList(replace, ";");
        String toReturn = alterThis;
        for (String split : splits) {
            try {
                int index = split.indexOf("=");
                if (index <= 0) continue;
                toReturn = toReturn.replaceAll(split.substring(0, index), split.substring(index + 1));
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot replace string in text", (Throwable)ex);
            }
        }
        return toReturn;
    }

    public static Validator getDocketXMLValidator() throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        InputStream xsd = XMLDocketScanner.class.getResourceAsStream("Docket.xsd");
        Schema schema = schemaFactory.newSchema(new StreamSource(xsd));
        return schema.newValidator();
    }
}

