/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.dockets.international;

import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.Stringifier;
import java.util.HashMap;
import java.util.Map;

public class ArabicPrinterStringifier
implements Stringifier<String> {
    protected static final Map<Character, Character> isolatedMap = new HashMap<Character, Character>();
    protected static final Map<Character, Character> initialMap = new HashMap<Character, Character>();
    protected static final Map<Character, Character> finalMap = new HashMap<Character, Character>();
    protected static final Map<Character, Character> medialMap = new HashMap<Character, Character>();
    protected static final Map<Character, Character> numberMap = new HashMap<Character, Character>();
    protected static final Map<Character, Boolean> linkableMap = new HashMap<Character, Boolean>();
    protected static String LAM_ALIF_UPPER_HAMZA = String.valueOf("\u0161");
    protected static String LAM_ALIF = String.valueOf('\u017e');
    protected static String LAM_ALIF_TILDA_LINKED = String.valueOf("\u00fa");
    protected static String LAM_ALIF_TILDA_ISO = String.valueOf("\u00f9");

    @Override
    public String stringify(String nodeValue) {
        String value = StringUtils.reverseForeignCharSequence(nodeValue);
        StringBuilder SB = new StringBuilder();
        String[] splits = value.split(" ");
        for (int i = 0; i < splits.length; ++i) {
            if (splits[i].length() == 0) continue;
            if (Character.getDirectionality(splits[i].charAt(0)) == 2) {
                SB.append(this.replaceCharsForEscpos(splits[i].trim()));
            } else if (numberMap.containsKey(Character.valueOf(splits[i].charAt(0)))) {
                SB.append(this.replaceNumbersForEscpos(splits[i].trim()));
            } else {
                SB.append(splits[i]);
            }
            if (i >= splits.length - 1) continue;
            SB.append(" ");
        }
        return SB.toString();
    }

    private String replaceCharsForEscpos(String string) {
        this.initMaps();
        StringBuilder SB = new StringBuilder();
        if (string.length() == 1) {
            SB.append(this.getChar(isolatedMap, string.charAt(0)));
        } else {
            char left = string.charAt(0);
            char right = string.charAt(1);
            int start = 1;
            if (this.isLinkable(right)) {
                SB.append(this.getChar(finalMap, left));
                if (this.replaceLamAlif(SB, left, right, Context.Final)) {
                    start = 2;
                }
            } else {
                SB.append(this.getChar(isolatedMap, left));
                this.replaceLamAlif(SB, left, right, Context.Isolated);
            }
            for (int i = start; i < string.length() - 1; ++i) {
                left = string.charAt(i);
                right = string.charAt(i + 1);
                if (this.isLinkable(right)) {
                    SB.append(this.getChar(medialMap, left));
                    if (!this.replaceLamAlif(SB, left, right, Context.Medial)) continue;
                    ++i;
                    continue;
                }
                SB.append(this.getChar(initialMap, left));
                if (!this.replaceLamAlif(SB, left, right, Context.Initial)) continue;
                ++i;
            }
            left = string.charAt(string.length() - 1);
            if (ArabicChar.Lam.character.charValue() != left || SB.charAt(SB.length() - 1) != LAM_ALIF.charAt(0) && SB.charAt(SB.length() - 1) != LAM_ALIF_TILDA_ISO.charAt(0) && SB.charAt(SB.length() - 1) != LAM_ALIF_TILDA_LINKED.charAt(0) && SB.charAt(SB.length() - 1) != LAM_ALIF_UPPER_HAMZA.charAt(0)) {
                SB.append(this.getChar(initialMap, left));
            }
        }
        return SB.toString();
    }

    private String replaceNumbersForEscpos(String string) {
        StringBuilder SB = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            SB.append(this.getChar(numberMap, string.charAt(i)));
        }
        return SB.toString();
    }

    private boolean replaceLamAlif(StringBuilder SB, char leftMost, char rightMost, Context context) {
        if (ArabicChar.Lam.character.charValue() == rightMost) {
            if (ArabicChar.Alif.character.charValue() == leftMost || ArabicChar.AlifUpperHamza.character.charValue() == leftMost || ArabicChar.AlifLowerHamza.character.charValue() == leftMost) {
                SB.replace(SB.length() - 1, SB.length(), ArabicChar.AlifUpperHamza.character.equals(Character.valueOf(leftMost)) ? LAM_ALIF_UPPER_HAMZA : LAM_ALIF);
                return true;
            }
            if (ArabicChar.AlifTildaHamza.character.charValue() == leftMost) {
                if (Context.Initial.equals((Object)context) || Context.Isolated.equals((Object)context)) {
                    SB.replace(SB.length() - 1, SB.length(), LAM_ALIF_TILDA_ISO);
                } else {
                    SB.replace(SB.length() - 1, SB.length(), LAM_ALIF_TILDA_LINKED);
                }
                return true;
            }
        }
        return false;
    }

    private boolean isLinkable(char queryChar) {
        return Boolean.TRUE.equals(linkableMap.get(Character.valueOf(queryChar)));
    }

    private Character getChar(Map<Character, Character> map, char charAt) {
        Character result = map.get(Character.valueOf(charAt));
        return result != null ? result : Character.valueOf(charAt);
    }

    private void initMaps() {
        if (isolatedMap.size() != 0) {
            return;
        }
        this.doIsolated();
        this.doFinal();
        this.doInitial();
        this.doMedial();
        this.doLinkable();
        this.doNumbers();
    }

    protected void map(Map<Character, Character> charMap, ArabicChar unicodeFrom, int unicodeTo) {
        charMap.put(unicodeFrom.character, Character.valueOf((char)unicodeTo));
    }

    protected void doIsolated() {
        isolatedMap.clear();
        Map<Character, Character> map = isolatedMap;
        this.map(map, ArabicChar.Alif, 199);
        this.map(map, ArabicChar.AlifUpperHamza, 195);
        this.map(map, ArabicChar.AlifLowerHamza, 199);
        this.map(map, ArabicChar.AlifTildaHamza, 194);
        this.map(map, ArabicChar.Beh, 169);
        this.map(map, ArabicChar.Teh, 170);
        this.map(map, ArabicChar.TehSecondary, 201);
        this.map(map, ArabicChar.Theh, 171);
        this.map(map, ArabicChar.Ghim, 173);
        this.map(map, ArabicChar.Ha, 174);
        this.map(map, ArabicChar.Kha, 175);
        this.map(map, ArabicChar.Del, 207);
        this.map(map, ArabicChar.Zel, 208);
        this.map(map, ArabicChar.Reh, 209);
        this.map(map, ArabicChar.Zain, 210);
        this.map(map, ArabicChar.Seen, 188);
        this.map(map, ArabicChar.Sheen, 189);
        this.map(map, ArabicChar.Sad, 190);
        this.map(map, ArabicChar.Dad, 235);
        this.map(map, ArabicChar.Tah, 215);
        this.map(map, ArabicChar.Zah, 216);
        this.map(map, ArabicChar.Ayn, 223);
        this.map(map, ArabicChar.Gayn, 238);
        this.map(map, ArabicChar.Feh, 186);
        this.map(map, ArabicChar.Kahf, 248);
        this.map(map, ArabicChar.Kehf, 252);
        this.map(map, ArabicChar.Lam, 251);
        this.map(map, ArabicChar.Meem, 239);
        this.map(map, ArabicChar.Noon, 242);
        this.map(map, ArabicChar.Heh, 243);
        this.map(map, ArabicChar.O, 196);
        this.map(map, ArabicChar.Waw, 232);
        this.map(map, ArabicChar.Yeh, 253);
        this.map(map, ArabicChar.YehSecondary, 233);
        this.map(map, ArabicChar.Hamzah, 193);
        this.map(map, ArabicChar.YehTertiary, 253);
        this.map(map, ArabicChar.UnderscoreLigature, 224);
        this.map(map, ArabicChar.CommaInverted, 172);
    }

    protected void doFinal() {
        finalMap.clear();
        Map<Character, Character> map = finalMap;
        this.map(map, ArabicChar.Alif, 168);
        this.map(map, ArabicChar.AlifUpperHamza, 165);
        this.map(map, ArabicChar.AlifLowerHamza, 168);
        this.map(map, ArabicChar.AlifTildaHamza, 162);
        this.map(map, ArabicChar.Beh, 169);
        this.map(map, ArabicChar.Teh, 170);
        this.map(map, ArabicChar.TehSecondary, 201);
        this.map(map, ArabicChar.Theh, 171);
        this.map(map, ArabicChar.Ghim, 173);
        this.map(map, ArabicChar.Ha, 174);
        this.map(map, ArabicChar.Kha, 175);
        this.map(map, ArabicChar.Del, 207);
        this.map(map, ArabicChar.Zel, 208);
        this.map(map, ArabicChar.Reh, 209);
        this.map(map, ArabicChar.Zain, 210);
        this.map(map, ArabicChar.Seen, 188);
        this.map(map, ArabicChar.Sheen, 189);
        this.map(map, ArabicChar.Sad, 190);
        this.map(map, ArabicChar.Dad, 235);
        this.map(map, ArabicChar.Tah, 215);
        this.map(map, ArabicChar.Zah, 216);
        this.map(map, ArabicChar.Ayn, 197);
        this.map(map, ArabicChar.Gayn, 237);
        this.map(map, ArabicChar.Feh, 186);
        this.map(map, ArabicChar.Kahf, 248);
        this.map(map, ArabicChar.Kehf, 252);
        this.map(map, ArabicChar.Lam, 251);
        this.map(map, ArabicChar.Meem, 239);
        this.map(map, ArabicChar.Noon, 242);
        this.map(map, ArabicChar.Heh, 243);
        this.map(map, ArabicChar.O, 196);
        this.map(map, ArabicChar.Waw, 232);
        this.map(map, ArabicChar.Yeh, 246);
        this.map(map, ArabicChar.YehSecondary, 245);
        this.map(map, ArabicChar.Hamzah, 193);
        this.map(map, ArabicChar.YehTertiary, 253);
        this.map(map, ArabicChar.UnderscoreLigature, 224);
        this.map(map, ArabicChar.CommaInverted, 172);
    }

    protected void doInitial() {
        initialMap.clear();
        Map<Character, Character> map = initialMap;
        this.map(map, ArabicChar.Alif, 199);
        this.map(map, ArabicChar.AlifUpperHamza, 195);
        this.map(map, ArabicChar.AlifLowerHamza, 199);
        this.map(map, ArabicChar.AlifTildaHamza, 194);
        this.map(map, ArabicChar.Beh, 200);
        this.map(map, ArabicChar.Teh, 202);
        this.map(map, ArabicChar.TehSecondary, 201);
        this.map(map, ArabicChar.Theh, 203);
        this.map(map, ArabicChar.Ghim, 204);
        this.map(map, ArabicChar.Ha, 205);
        this.map(map, ArabicChar.Kha, 206);
        this.map(map, ArabicChar.Del, 207);
        this.map(map, ArabicChar.Zel, 208);
        this.map(map, ArabicChar.Reh, 209);
        this.map(map, ArabicChar.Zain, 210);
        this.map(map, ArabicChar.Seen, 211);
        this.map(map, ArabicChar.Sheen, 212);
        this.map(map, ArabicChar.Sad, 213);
        this.map(map, ArabicChar.Dad, 214);
        this.map(map, ArabicChar.Tah, 215);
        this.map(map, ArabicChar.Zah, 216);
        this.map(map, ArabicChar.Ayn, 217);
        this.map(map, ArabicChar.Gayn, 218);
        this.map(map, ArabicChar.Feh, 225);
        this.map(map, ArabicChar.Kahf, 226);
        this.map(map, ArabicChar.Kehf, 227);
        this.map(map, ArabicChar.Lam, 228);
        this.map(map, ArabicChar.Meem, 229);
        this.map(map, ArabicChar.Noon, 230);
        this.map(map, ArabicChar.Heh, 231);
        this.map(map, ArabicChar.O, 231);
        this.map(map, ArabicChar.Waw, 232);
        this.map(map, ArabicChar.Yeh, 234);
        this.map(map, ArabicChar.YehSecondary, 234);
        this.map(map, ArabicChar.Hamzah, 193);
        this.map(map, ArabicChar.YehTertiary, 198);
        this.map(map, ArabicChar.UnderscoreLigature, 224);
        this.map(map, ArabicChar.CommaInverted, 172);
    }

    protected void doMedial() {
        medialMap.clear();
        Map<Character, Character> map = medialMap;
        this.map(map, ArabicChar.Alif, 168);
        this.map(map, ArabicChar.AlifUpperHamza, 165);
        this.map(map, ArabicChar.AlifLowerHamza, 168);
        this.map(map, ArabicChar.AlifTildaHamza, 162);
        this.map(map, ArabicChar.Beh, 200);
        this.map(map, ArabicChar.Teh, 202);
        this.map(map, ArabicChar.TehSecondary, 201);
        this.map(map, ArabicChar.Theh, 203);
        this.map(map, ArabicChar.Ghim, 204);
        this.map(map, ArabicChar.Ha, 205);
        this.map(map, ArabicChar.Kha, 206);
        this.map(map, ArabicChar.Del, 207);
        this.map(map, ArabicChar.Zel, 208);
        this.map(map, ArabicChar.Reh, 209);
        this.map(map, ArabicChar.Zain, 210);
        this.map(map, ArabicChar.Seen, 211);
        this.map(map, ArabicChar.Sheen, 212);
        this.map(map, ArabicChar.Sad, 213);
        this.map(map, ArabicChar.Dad, 214);
        this.map(map, ArabicChar.Tah, 215);
        this.map(map, ArabicChar.Zah, 216);
        this.map(map, ArabicChar.Ayn, 236);
        this.map(map, ArabicChar.Gayn, 247);
        this.map(map, ArabicChar.Feh, 225);
        this.map(map, ArabicChar.Kahf, 226);
        this.map(map, ArabicChar.Kehf, 227);
        this.map(map, ArabicChar.Lam, 228);
        this.map(map, ArabicChar.Meem, 229);
        this.map(map, ArabicChar.Noon, 230);
        this.map(map, ArabicChar.Heh, 244);
        this.map(map, ArabicChar.O, 196);
        this.map(map, ArabicChar.Waw, 232);
        this.map(map, ArabicChar.Yeh, 234);
        this.map(map, ArabicChar.YehSecondary, 234);
        this.map(map, ArabicChar.Hamzah, 193);
        this.map(map, ArabicChar.YehTertiary, 198);
        this.map(map, ArabicChar.UnderscoreLigature, 224);
        this.map(map, ArabicChar.CommaInverted, 172);
    }

    protected void doNumbers() {
        numberMap.clear();
        Map<Character, Character> map = numberMap;
        this.map(map, ArabicChar.Sifr, 176);
        this.map(map, ArabicChar.Wahid, 177);
        this.map(map, ArabicChar.Ithnan, 178);
        this.map(map, ArabicChar.Thalathah, 179);
        this.map(map, ArabicChar.Arbaah, 180);
        this.map(map, ArabicChar.Khamsah, 181);
        this.map(map, ArabicChar.Sitah, 182);
        this.map(map, ArabicChar.Sabah, 183);
        this.map(map, ArabicChar.Thamaniyah, 184);
        this.map(map, ArabicChar.Tisah, 185);
        this.map(map, ArabicChar.CommaInverted, 172);
    }

    protected void doLinkable() {
        linkableMap.clear();
        Map<Character, Boolean> map = linkableMap;
        this.mapLinkable(ArabicChar.Alif, Boolean.FALSE);
        this.mapLinkable(ArabicChar.AlifUpperHamza, Boolean.FALSE);
        this.mapLinkable(ArabicChar.AlifLowerHamza, Boolean.FALSE);
        this.mapLinkable(ArabicChar.AlifTildaHamza, Boolean.FALSE);
        this.mapLinkable(ArabicChar.Beh, Boolean.TRUE);
        this.mapLinkable(ArabicChar.Teh, Boolean.TRUE);
        this.mapLinkable(ArabicChar.TehSecondary, Boolean.TRUE);
        this.mapLinkable(ArabicChar.Theh, Boolean.TRUE);
        this.mapLinkable(ArabicChar.Ghim, Boolean.TRUE);
        this.mapLinkable(ArabicChar.Ha, Boolean.TRUE);
        this.mapLinkable(ArabicChar.Kha, Boolean.TRUE);
        this.mapLinkable(ArabicChar.Del, Boolean.FALSE);
        this.mapLinkable(ArabicChar.Zel, Boolean.FALSE);
        this.mapLinkable(ArabicChar.Reh, Boolean.FALSE);
        this.mapLinkable(ArabicChar.Zain, Boolean.FALSE);
        this.mapLinkable(ArabicChar.Seen, Boolean.TRUE);
        this.mapLinkable(ArabicChar.Sheen, Boolean.TRUE);
        this.mapLinkable(ArabicChar.Sad, Boolean.TRUE);
        this.mapLinkable(ArabicChar.Dad, Boolean.TRUE);
        this.mapLinkable(ArabicChar.Tah, Boolean.TRUE);
        this.mapLinkable(ArabicChar.Zah, Boolean.TRUE);
        this.mapLinkable(ArabicChar.Ayn, Boolean.TRUE);
        this.mapLinkable(ArabicChar.Gayn, Boolean.TRUE);
        this.mapLinkable(ArabicChar.Feh, Boolean.TRUE);
        this.mapLinkable(ArabicChar.Kahf, Boolean.TRUE);
        this.mapLinkable(ArabicChar.Kehf, Boolean.TRUE);
        this.mapLinkable(ArabicChar.Lam, Boolean.TRUE);
        this.mapLinkable(ArabicChar.Meem, Boolean.TRUE);
        this.mapLinkable(ArabicChar.Noon, Boolean.TRUE);
        this.mapLinkable(ArabicChar.Heh, Boolean.TRUE);
        this.mapLinkable(ArabicChar.O, Boolean.FALSE);
        this.mapLinkable(ArabicChar.Waw, Boolean.FALSE);
        this.mapLinkable(ArabicChar.Yeh, Boolean.TRUE);
        this.mapLinkable(ArabicChar.YehSecondary, Boolean.TRUE);
        this.mapLinkable(ArabicChar.Hamzah, Boolean.FALSE);
        this.mapLinkable(ArabicChar.YehTertiary, Boolean.TRUE);
        this.mapLinkable(ArabicChar.YehQuartiary, Boolean.TRUE);
        this.mapLinkable(ArabicChar.CommaInverted, Boolean.FALSE);
    }

    private void mapLinkable(ArabicChar arabicChar, Boolean linkable) {
        linkableMap.put(arabicChar.getCharacter(), linkable);
    }

    private static enum Context {
        Initial,
        Medial,
        Isolated,
        Final;

    }

    public static enum ArabicChar {
        Alif(1575),
        AlifUpperHamza(1571),
        AlifLowerHamza(1573),
        AlifTildaHamza(1570),
        Beh(1576),
        Teh(1578),
        TehSecondary(1577),
        Theh(1579),
        Ghim(1580),
        Ha(1581),
        Kha(1582),
        Del(1583),
        Zel(1584),
        Reh(1585),
        Zain(1586),
        Seen(1587),
        Sheen(1588),
        Sad(1589),
        Dad(1590),
        Tah(1591),
        Zah(1592),
        Ayn(1593),
        Gayn(1594),
        Feh(1601),
        Kahf(1602),
        Kehf(1603),
        KehfIr(1705),
        Lam(1604),
        Meem(1605),
        Noon(1606),
        Heh(1607),
        O(1572),
        Waw(1608),
        Yeh(1610),
        YehSecondary(1609),
        YehTertiary(1574),
        YehQuartiary(1740),
        Hamzah(1569),
        UnderscoreLigature(1600),
        CommaInverted(1548),
        Sifr(1632),
        Wahid(1633),
        Ithnan(1634),
        Thalathah(1635),
        Arbaah(1636),
        Khamsah(1637),
        Sitah(1638),
        Sabah(1639),
        Thamaniyah(1640),
        Tisah(1641),
        Gahf(1711),
        Peh(1662),
        Zjhe(1670),
        Jah(1688),
        Question(1567);

        private final Character character;

        private ArabicChar(int codepoint) {
            this.character = Character.valueOf((char)codepoint);
        }

        public Character getCharacter() {
            return this.character;
        }
    }
}

