/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.duplicate;

import au.com.ordermate.duplicate.Duplicate;
import au.com.ordermate.duplicate.DuplicateDetectionStrategy;
import au.com.ordermate.duplicate.DuplicateDetector;
import au.com.ordermate.duplicate.DuplicateGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class DefaultDuplicateDetector<T>
implements DuplicateDetector<T> {
    private DuplicateDetectionStrategy<T> strategy;

    public DefaultDuplicateDetector(DuplicateDetectionStrategy<T> detectionStrategy) {
        this.setDetectionStrategy(detectionStrategy);
    }

    @Override
    public void setDetectionStrategy(DuplicateDetectionStrategy<T> theStrategy) {
        this.strategy = theStrategy;
    }

    @Override
    public List<DuplicateGroup<T>> detectDuplicates(Collection<T> toExamine) {
        ArrayList<DuplicateGroup<T>> groupsList = new ArrayList<DuplicateGroup<T>>();
        HashSet<T> localSet = new HashSet<T>(toExamine);
        for (T nextT : toExamine) {
            if (!localSet.contains(nextT)) continue;
            localSet.remove(nextT);
            DuplicateGroup group = null;
            for (Object nextComparison : localSet) {
                Duplicate<T> duplicate = this.strategy.compare(nextT, nextComparison);
                if (duplicate == null) continue;
                if (group == null) {
                    group = new DuplicateGroup();
                    group.addDuplicate(nextT);
                }
                group.addDuplicate(nextComparison);
            }
            if (group == null) continue;
            for (Object dupe : group.getGroupedItems()) {
                localSet.remove(dupe);
            }
            groupsList.add(group);
        }
        return groupsList;
    }
}

