/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.duplicate;

import au.com.ordermate.duplicate.Duplicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DuplicateGroup<T>
implements Serializable {
    private final List<T> duplicates = new ArrayList<T>();

    public void addDuplicate(T toAdd) {
        this.duplicates.add(toAdd);
    }

    public void removeDuplicate(T toRemove) {
        this.duplicates.remove(toRemove);
    }

    public T getFirstItem() {
        return this.duplicates.get(0);
    }

    public List<T> getGroupedItems() {
        return Collections.unmodifiableList(this.duplicates);
    }

    public List<Duplicate<T>> getDuplicateItems() {
        ArrayList<Duplicate<T>> groupList = new ArrayList<Duplicate<T>>();
        T master = this.duplicates.get(0);
        for (T nextT : this.duplicates) {
            if (nextT.equals(master)) continue;
            groupList.add(new Duplicate<T>(master, nextT));
        }
        return groupList;
    }

    public void setSortingStrategy(Comparator<T> strategy) {
        Collections.sort(this.duplicates, strategy);
    }

    public int getSize() {
        return this.duplicates.size();
    }
}

