/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.expr;

import au.com.ordermate.expr.Parser;
import au.com.ordermate.expr.Symbol;
import au.com.ordermate.expr.SymbolTree;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Vector;

public class ParseEngine {
    protected String[] tokenizeExpression(String expression, Parser parser) throws IOException {
        Vector<String> tokens = new Vector<String>();
        StreamTokenizer tokenizer = parser.getNewTokenizer(expression);
        int tokenType = tokenizer.nextToken();
        while (tokenType != -1) {
            if (tokenType == -2) {
                tokens.add(String.valueOf((int)tokenizer.nval));
            } else if (tokenType == -3) {
                tokens.add(tokenizer.sval);
            } else if (tokenType != -1 && tokenType != 10) {
                tokens.add(String.valueOf((char)tokenizer.ttype));
            }
            tokenType = tokenizer.nextToken();
        }
        String[] tokenArray = tokens.toArray(new String[0]);
        return tokenArray;
    }

    protected SymbolTree getSymbolList(String[] symbolStrings, Parser parser) {
        SymbolTree root = new SymbolTree();
        for (int i = 0; i < symbolStrings.length; ++i) {
            String token = symbolStrings[i];
            Symbol newSymbol = new Symbol(token);
            newSymbol.setID(parser.getSymbolID(token));
            root.addChild(newSymbol);
        }
        return root;
    }

    protected void formatSymbolTree(SymbolTree root, Parser parser) {
        int currentPass = 0;
        int nextPassCommand = parser.getNextPassCommand(currentPass);
        while (nextPassCommand != 2) {
            SymbolTree.TreeIterator s = null;
            boolean doReverse = nextPassCommand == 1;
            s = root.depthFirstIterator(doReverse);
            Symbol currentSymbol = null;
            parser.onStartPass(root, currentPass);
            while (s.hasNext()) {
                currentSymbol = (Symbol)s.next();
                if (parser.shouldDemote(currentSymbol, currentPass)) {
                    s.demote();
                }
                if (parser.shouldPromote(currentSymbol, currentPass)) {
                    s.promote();
                }
                if (parser.shouldCaptureNextPeer(currentSymbol, currentPass)) {
                    s.captureNextPeer();
                }
                if (parser.shouldCapturePreviousPeer(currentSymbol, currentPass)) {
                    s.capturePreviousPeer();
                }
                if (!parser.shouldDelete(currentSymbol, currentPass)) continue;
                s.remove();
            }
            nextPassCommand = parser.getNextPassCommand(++currentPass);
        }
    }

    public SymbolTree parse(String expression, Parser parser) throws IOException {
        parser.resetState();
        String[] expressionTokens = this.tokenizeExpression(expression, parser);
        SymbolTree root = this.getSymbolList(expressionTokens, parser);
        this.formatSymbolTree(root, parser);
        return root;
    }
}

