/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.expr;

import au.com.ordermate.expr.DefaultParser;
import au.com.ordermate.expr.Symbol;
import java.util.ArrayList;
import java.util.List;

public class RPNParser
extends DefaultParser {
    public static final int OPERATE_ON_NONE = 0;
    public static final int OPERATE_ON_PREVIOUS = 1;
    public static final int OPERATE_ON_NEXT = 2;
    public static final int OPERATE_ON_NEIGHBOURING = 3;
    protected static final int PASS_UNIFY_OPERATORS = 0;
    protected static final int PASS_BRACKETS = 1;
    protected static final int PASS_FIRST_OPERATOR = 2;
    private List<String> operators = new ArrayList<String>();
    private List<String> operatorsClose = new ArrayList<String>();
    private List<Integer> operatorFlags = new ArrayList<Integer>();
    private List<Integer> operatorOrder = new ArrayList<Integer>();
    private boolean demoteNext = false;

    public RPNParser() {
        this.resetState();
    }

    public void addOperator(String operator, int operateOn) {
        this.addOperator(operator, operateOn, false);
    }

    public void addOperator(String operator, int operateOn, boolean samePass) {
        this.operators.add(operator);
        this.operatorsClose.add(null);
        this.operatorFlags.add(operateOn);
        this.setupPass(samePass);
    }

    public void addBracketOperator(String openOp, String closeOp, int operateOn) {
        this.addBracketOperator(openOp, closeOp, operateOn, false);
    }

    public void addBracketOperator(String openOp, String closeOp, int operateOn, boolean samePass) {
        this.operators.add(openOp);
        this.operatorsClose.add(closeOp);
        this.operatorFlags.add(operateOn);
        this.setupPass(samePass);
    }

    @Override
    public boolean shouldPromote(Symbol symbol, int pass) {
        if (pass == 1) {
            return this.isClosingBracket(symbol.getText());
        }
        return false;
    }

    @Override
    public boolean shouldDemote(Symbol symbol, int pass) {
        if (pass == 1) {
            boolean demoteCurrent = this.demoteNext;
            this.demoteNext = this.isOpeningBracket(symbol.getText());
            return demoteCurrent;
        }
        return false;
    }

    @Override
    public boolean shouldDelete(Symbol symbol, int pass) {
        String text = symbol.getText();
        if (pass == 0) {
            if (text.length() == 1) {
                for (int i = 0; i < this.operators.size(); ++i) {
                    Symbol prevSymbol;
                    String operator = this.operators.get(i);
                    if (operator.length() != 2 || operator.charAt(1) != text.charAt(0) || (prevSymbol = symbol.getPreviousPeer()) == null) continue;
                    String prevSymbolText = prevSymbol.getText();
                    if (operator.charAt(0) != prevSymbolText.charAt(0)) continue;
                    prevSymbol.setText(operator);
                    prevSymbol.setID(this.getSymbolID(operator));
                    return true;
                }
            }
        } else if (pass == 1) {
            return this.isClosingBracket(symbol.getText());
        }
        return false;
    }

    public int getPassForOperator(String str) {
        int index = this.operators.indexOf(str);
        if (index == -1) {
            return -1;
        }
        Integer passNum = this.operatorOrder.get(index);
        return passNum;
    }

    @Override
    public boolean shouldCaptureNextPeer(Symbol symbol, int pass) {
        String text = symbol.getText();
        if (pass >= 2 && this.getPassForOperator(text) == pass) {
            int operateOn = this.getOperateOnFlag(text);
            return operateOn == 2 || operateOn == 3;
        }
        return false;
    }

    @Override
    public boolean shouldCapturePreviousPeer(Symbol symbol, int pass) {
        String text = symbol.getText();
        if (pass >= 2 && this.getPassForOperator(text) == pass) {
            int operateOn = this.getOperateOnFlag(text);
            return operateOn == 1 || operateOn == 3;
        }
        return false;
    }

    public int getNumPasses() {
        int lastIndex = this.operatorOrder.size() - 1;
        Integer lastPass = this.operatorOrder.get(lastIndex);
        return lastPass + 2;
    }

    @Override
    public int getNextPassCommand(int nextPass) {
        if (nextPass < this.getNumPasses()) {
            return 0;
        }
        return 2;
    }

    @Override
    public void resetState() {
        this.demoteNext = false;
    }

    public boolean isOpeningBracket(String oper) {
        int index = this.operators.indexOf(oper);
        if (index != -1) {
            return this.operatorsClose.get(index) != null;
        }
        return false;
    }

    public boolean isClosingBracket(String oper) {
        return this.operatorsClose.contains(oper);
    }

    public boolean isOperator(String oper) {
        return this.operators.contains(oper);
    }

    private int getOperateOnFlag(String oper) {
        int index = this.operators.indexOf(oper);
        if (index != -1) {
            Integer flag = this.operatorFlags.get(index);
            return flag;
        }
        return 0;
    }

    private void setupPass(boolean samePass) {
        int lastPass;
        if (this.operatorOrder.isEmpty()) {
            lastPass = -1;
        } else {
            int lastIndex = this.operatorOrder.size() - 1;
            Integer lastElement = this.operatorOrder.get(lastIndex);
            lastPass = lastElement;
        }
        Integer pass = null;
        pass = lastPass == -1 ? Integer.valueOf(2) : (samePass ? Integer.valueOf(lastPass) : Integer.valueOf(lastPass + 1));
        this.operatorOrder.add(pass);
    }
}

