/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.expr;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.expr.SymbolTree;
import java.util.ArrayList;
import java.util.List;

public class Symbol {
    private String text = "";
    private int lastIterationID = 0;
    private SymbolTree root = null;
    private Symbol parent = null;
    private Symbol firstChild;
    private Symbol nextPeer;
    private Symbol prevPeer = null;
    private int id;

    public Symbol(String txt) {
        this.text = txt;
    }

    int getLastIterID() {
        return this.lastIterationID;
    }

    void setLastIterID(int lastId) {
        this.lastIterationID = lastId;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String txt) {
        this.text = txt;
    }

    public int getID() {
        return this.id;
    }

    public void setID(int i) {
        this.id = i;
    }

    public String toString() {
        return this.getText();
    }

    private void setRoot(SymbolTree rootSymbol) {
        if (rootSymbol != this.root) {
            if (this.nextPeer != null) {
                this.nextPeer.setRoot(rootSymbol);
            }
            if (this.firstChild != null) {
                this.firstChild.setRoot(rootSymbol);
            }
            this.root = rootSymbol;
        }
    }

    public Symbol getNextPeer() {
        return this.nextPeer;
    }

    public Symbol getFirstChild() {
        return this.firstChild;
    }

    public Symbol getPreviousPeer() {
        return this.prevPeer;
    }

    public Symbol getLastPeer() {
        if (this.nextPeer == null) {
            return this;
        }
        return this.nextPeer.getLastPeer();
    }

    public Symbol getLastChild() {
        return this.firstChild == null ? null : this.firstChild.getLastPeer();
    }

    public boolean isRoot() {
        return this.parent == null && this.prevPeer == null;
    }

    public synchronized boolean promote() {
        if (this.parent != null) {
            this.separateFromPrevPeer();
            if (this.parent.firstChild == this) {
                this.parent.firstChild = null;
            }
            this.parent.insertPeer(this);
            this.setParent(this.parent.getParent());
            if (this.root != null) {
                this.root.incModCount();
            }
            return true;
        }
        OrderMateLog.LOG.error("Cannot promote node '" + this.getText() + "': Node is already at the top level.");
        return false;
    }

    public synchronized boolean demote() {
        if (this.prevPeer != null) {
            Symbol oldPrevPeer = this.prevPeer;
            this.separateFromPrevPeer();
            oldPrevPeer.addChild(this);
            if (this.root != null) {
                this.root.incModCount();
            }
            return true;
        }
        OrderMateLog.LOG.error("Cannot demote node '" + this.getText() + "': Node has no preceding peers to assume parent status.");
        return false;
    }

    public synchronized boolean capturePreviousPeer() {
        Symbol oldPrevPeer = this.prevPeer;
        if (oldPrevPeer != null) {
            oldPrevPeer.delete();
            this.insertChild(oldPrevPeer);
            if (this.root != null) {
                this.root.incModCount();
            }
            return true;
        }
        return false;
    }

    public synchronized boolean captureNextPeer() {
        Symbol oldNextPeer = this.nextPeer;
        if (oldNextPeer != null) {
            oldNextPeer.delete();
            this.insertChild(oldNextPeer);
            if (this.root != null) {
                this.root.incModCount();
            }
            return true;
        }
        return false;
    }

    public synchronized boolean captureNeighbours() {
        if (this.nextPeer != null && this.prevPeer != null) {
            return this.captureNextPeer() && this.capturePreviousPeer();
        }
        return false;
    }

    public synchronized boolean delete() {
        if (!this.isRoot()) {
            Symbol oldPrevPeer = this.prevPeer;
            Symbol oldNextPeer = this.nextPeer;
            this.separateFromPrevPeer();
            this.separateFromNextPeer();
            if (this.parent != null && this.parent.firstChild == this) {
                this.parent.firstChild = oldNextPeer;
            } else if (oldNextPeer != null && oldPrevPeer != null) {
                oldPrevPeer.addPeer(oldNextPeer);
            }
            this.parent = null;
            if (this.root != null) {
                this.root.incModCount();
            }
            return true;
        }
        OrderMateLog.LOG.error("Cannot delete node '" + this.getText() + "': Deletion of the root is illegal.");
        return false;
    }

    public boolean isLeaf() {
        return this.getFirstChild() == null;
    }

    public List<Symbol> getChildren() {
        ArrayList<Symbol> children = new ArrayList<Symbol>();
        Symbol c = this.firstChild;
        while (c != null) {
            children.add(c);
            c = c.nextPeer;
        }
        return children;
    }

    private void separateFromPrevPeer() {
        if (this.prevPeer != null) {
            this.prevPeer.nextPeer = null;
            this.prevPeer = null;
        }
    }

    private void separateFromNextPeer() {
        if (this.nextPeer != null) {
            this.nextPeer.prevPeer = null;
            this.nextPeer = null;
        }
    }

    public synchronized void addChild(Symbol newChild) {
        if (this.firstChild == null) {
            if (this.root != null) {
                this.root.incModCount();
            }
            newChild.setRoot(this.root);
            this.firstChild = newChild;
        } else {
            this.firstChild.addPeer(newChild);
        }
        newChild.setParent(this);
    }

    private synchronized void setParent(Symbol newParent) {
        this.parent = newParent;
        if (this.nextPeer != null) {
            this.nextPeer.setParent(newParent);
        }
    }

    public synchronized void addPeer(Symbol newPeer) {
        if (this.nextPeer == null) {
            if (this.root != null) {
                this.root.incModCount();
            }
            newPeer.setRoot(this.root);
            this.nextPeer = newPeer;
            newPeer.separateFromPrevPeer();
            newPeer.prevPeer = this;
        } else {
            this.nextPeer.addPeer(newPeer);
        }
    }

    public synchronized void insertChild(Symbol newChild) {
        if (this.firstChild == null) {
            this.addChild(newChild);
        } else {
            newChild.setParent(this);
            Symbol oldChild = this.firstChild;
            this.firstChild = newChild;
            this.addChild(oldChild);
        }
    }

    public synchronized void insertPeer(Symbol newPeer) {
        if (this.nextPeer != null) {
            newPeer.addPeer(this.nextPeer);
        }
        this.addPeer(newPeer);
    }

    public Symbol getParent() {
        return this.parent;
    }

    public void validate() {
        if (this.prevPeer != null && this.prevPeer.getNextPeer() != this) {
            throw new IllegalStateException("Non-matching peer connection : \"" + this.prevPeer + "\" --> \"" + this.prevPeer.getNextPeer() + "\"\n" + this.getPreviousPeer() + "\" <-- \"" + this + "\"\n");
        }
        if (this.nextPeer != null) {
            if (this.nextPeer.getPreviousPeer() != this) {
                throw new IllegalStateException("Non-matching peer connection");
            }
            this.nextPeer.validate();
        }
        if (this.parent != null) {
            boolean childFound = false;
            for (Symbol s = this.parent.getFirstChild(); s != null; s = s.getNextPeer()) {
                if (s != this) continue;
                childFound = true;
                break;
            }
            if (!childFound) {
                throw new IllegalStateException("Non-matching parent/child connection: \nparent \"" + this.parent + "\" --> child ???parent \"" + this.getParent() + "\" <-- child \"" + this + "\"\n");
            }
        }
        if (this.firstChild != null) {
            for (Symbol s = this.firstChild; s != null; s = s.getNextPeer()) {
                if (s.getParent() == this) continue;
                throw new IllegalStateException("Non-matching parent/child connection: \nparent \"" + this + "\" --> child \"" + s + "\"\nparent \"" + s.getParent() + "\" <-- child \"" + s + "\"\n");
            }
            this.firstChild.validate();
        }
    }
}

